package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::SecurityGroupEgress`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:01.930Z")
public interface CfnSecurityGroupEgressProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     */
    java.lang.String getGroupId();
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     */
    java.lang.String getIpProtocol();
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     */
    java.lang.String getCidrIp();
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     */
    java.lang.String getCidrIpv6();
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     */
    java.lang.String getDescription();
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     */
    java.lang.String getDestinationPrefixListId();
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     */
    java.lang.String getDestinationSecurityGroupId();
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     */
    java.lang.Object getFromPort();
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     */
    java.lang.Object getToPort();

    /**
     * @return a {@link Builder} of {@link CfnSecurityGroupEgressProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnSecurityGroupEgressProps}
     */
    final class Builder {
        private java.lang.String _groupId;
        private java.lang.String _ipProtocol;
        @javax.annotation.Nullable
        private java.lang.String _cidrIp;
        @javax.annotation.Nullable
        private java.lang.String _cidrIpv6;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _destinationPrefixListId;
        @javax.annotation.Nullable
        private java.lang.String _destinationSecurityGroupId;
        @javax.annotation.Nullable
        private java.lang.Object _fromPort;
        @javax.annotation.Nullable
        private java.lang.Object _toPort;

        /**
         * Sets the value of GroupId
         * @param value `AWS::EC2::SecurityGroupEgress.GroupId`.
         * @return {@code this}
         */
        public Builder withGroupId(final java.lang.String value) {
            this._groupId = java.util.Objects.requireNonNull(value, "groupId is required");
            return this;
        }
        /**
         * Sets the value of IpProtocol
         * @param value `AWS::EC2::SecurityGroupEgress.IpProtocol`.
         * @return {@code this}
         */
        public Builder withIpProtocol(final java.lang.String value) {
            this._ipProtocol = java.util.Objects.requireNonNull(value, "ipProtocol is required");
            return this;
        }
        /**
         * Sets the value of CidrIp
         * @param value `AWS::EC2::SecurityGroupEgress.CidrIp`.
         * @return {@code this}
         */
        public Builder withCidrIp(@javax.annotation.Nullable final java.lang.String value) {
            this._cidrIp = value;
            return this;
        }
        /**
         * Sets the value of CidrIpv6
         * @param value `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
         * @return {@code this}
         */
        public Builder withCidrIpv6(@javax.annotation.Nullable final java.lang.String value) {
            this._cidrIpv6 = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value `AWS::EC2::SecurityGroupEgress.Description`.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of DestinationPrefixListId
         * @param value `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
         * @return {@code this}
         */
        public Builder withDestinationPrefixListId(@javax.annotation.Nullable final java.lang.String value) {
            this._destinationPrefixListId = value;
            return this;
        }
        /**
         * Sets the value of DestinationSecurityGroupId
         * @param value `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
         * @return {@code this}
         */
        public Builder withDestinationSecurityGroupId(@javax.annotation.Nullable final java.lang.String value) {
            this._destinationSecurityGroupId = value;
            return this;
        }
        /**
         * Sets the value of FromPort
         * @param value `AWS::EC2::SecurityGroupEgress.FromPort`.
         * @return {@code this}
         */
        public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._fromPort = value;
            return this;
        }
        /**
         * Sets the value of FromPort
         * @param value `AWS::EC2::SecurityGroupEgress.FromPort`.
         * @return {@code this}
         */
        public Builder withFromPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._fromPort = value;
            return this;
        }
        /**
         * Sets the value of ToPort
         * @param value `AWS::EC2::SecurityGroupEgress.ToPort`.
         * @return {@code this}
         */
        public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._toPort = value;
            return this;
        }
        /**
         * Sets the value of ToPort
         * @param value `AWS::EC2::SecurityGroupEgress.ToPort`.
         * @return {@code this}
         */
        public Builder withToPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._toPort = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityGroupEgressProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnSecurityGroupEgressProps build() {
            return new CfnSecurityGroupEgressProps() {
                private final java.lang.String $groupId = java.util.Objects.requireNonNull(_groupId, "groupId is required");
                private final java.lang.String $ipProtocol = java.util.Objects.requireNonNull(_ipProtocol, "ipProtocol is required");
                @javax.annotation.Nullable
                private final java.lang.String $cidrIp = _cidrIp;
                @javax.annotation.Nullable
                private final java.lang.String $cidrIpv6 = _cidrIpv6;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.String $destinationPrefixListId = _destinationPrefixListId;
                @javax.annotation.Nullable
                private final java.lang.String $destinationSecurityGroupId = _destinationSecurityGroupId;
                @javax.annotation.Nullable
                private final java.lang.Object $fromPort = _fromPort;
                @javax.annotation.Nullable
                private final java.lang.Object $toPort = _toPort;

                @Override
                public java.lang.String getGroupId() {
                    return this.$groupId;
                }

                @Override
                public java.lang.String getIpProtocol() {
                    return this.$ipProtocol;
                }

                @Override
                public java.lang.String getCidrIp() {
                    return this.$cidrIp;
                }

                @Override
                public java.lang.String getCidrIpv6() {
                    return this.$cidrIpv6;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.String getDestinationPrefixListId() {
                    return this.$destinationPrefixListId;
                }

                @Override
                public java.lang.String getDestinationSecurityGroupId() {
                    return this.$destinationSecurityGroupId;
                }

                @Override
                public java.lang.Object getFromPort() {
                    return this.$fromPort;
                }

                @Override
                public java.lang.Object getToPort() {
                    return this.$toPort;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("groupId", om.valueToTree(this.getGroupId()));
                    obj.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                    obj.set("cidrIp", om.valueToTree(this.getCidrIp()));
                    obj.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
                    obj.set("destinationSecurityGroupId", om.valueToTree(this.getDestinationSecurityGroupId()));
                    obj.set("fromPort", om.valueToTree(this.getFromPort()));
                    obj.set("toPort", om.valueToTree(this.getToPort()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSecurityGroupEgressProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.GroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
         */
        @Override
        public java.lang.String getGroupId() {
            return this.jsiiGet("groupId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.IpProtocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
         */
        @Override
        public java.lang.String getIpProtocol() {
            return this.jsiiGet("ipProtocol", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.CidrIp`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCidrIp() {
            return this.jsiiGet("cidrIp", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.CidrIpv6`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCidrIpv6() {
            return this.jsiiGet("cidrIpv6", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDestinationPrefixListId() {
            return this.jsiiGet("destinationPrefixListId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDestinationSecurityGroupId() {
            return this.jsiiGet("destinationSecurityGroupId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.FromPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getFromPort() {
            return this.jsiiGet("fromPort", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::SecurityGroupEgress.ToPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getToPort() {
            return this.jsiiGet("toPort", java.lang.Object.class);
        }
    }
}
