package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:01.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet")
public class CfnSpotFleet extends software.amazon.awscdk.CfnResource {
    protected CfnSpotFleet(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSpotFleet.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::SpotFleet`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnSpotFleet(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnSpotFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.ec2.CfnSpotFleetProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnSpotFleetProps.class);
    }

    public java.lang.String getSpotFleetName() {
        return this.jsiiGet("spotFleetName", java.lang.String.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        java.lang.String getDeviceName();
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        java.lang.String getNoDevice();
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        java.lang.String getVirtualName();

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        final class Builder {
            private java.lang.String _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.String _noDevice;
            @javax.annotation.Nullable
            private java.lang.String _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            public Builder withDeviceName(final java.lang.String value) {
                this._deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    private final java.lang.String $deviceName = java.util.Objects.requireNonNull(_deviceName, "deviceName is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private final java.lang.String $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private final java.lang.String $virtualName = _virtualName;

                    @Override
                    public java.lang.String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public java.lang.String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public java.lang.String getVirtualName() {
                        return this.$virtualName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deviceName", om.valueToTree(this.getDeviceName()));
                        obj.set("ebs", om.valueToTree(this.getEbs()));
                        obj.set("noDevice", om.valueToTree(this.getNoDevice()));
                        obj.set("virtualName", om.valueToTree(this.getVirtualName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            @Override
            public java.lang.String getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     */
    public static interface ClassicLoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancerProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClassicLoadBalancerProperty}
         */
        final class Builder {
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ClassicLoadBalancerProperty build() {
                return new ClassicLoadBalancerProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancerProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
             */
            @Override
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     */
    public static interface ClassicLoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        java.lang.Object getClassicLoadBalancers();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancersConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClassicLoadBalancersConfigProperty}
         */
        final class Builder {
            private java.lang.Object _classicLoadBalancers;

            /**
             * Sets the value of ClassicLoadBalancers
             * @param value `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
             * @return {@code this}
             */
            public Builder withClassicLoadBalancers(final software.amazon.awscdk.Token value) {
                this._classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }
            /**
             * Sets the value of ClassicLoadBalancers
             * @param value `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
             * @return {@code this}
             */
            public Builder withClassicLoadBalancers(final java.util.List<java.lang.Object> value) {
                this._classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ClassicLoadBalancersConfigProperty build() {
                return new ClassicLoadBalancersConfigProperty() {
                    private final java.lang.Object $classicLoadBalancers = java.util.Objects.requireNonNull(_classicLoadBalancers, "classicLoadBalancers is required");

                    @Override
                    public java.lang.Object getClassicLoadBalancers() {
                        return this.$classicLoadBalancers;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("classicLoadBalancers", om.valueToTree(this.getClassicLoadBalancers()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
             */
            @Override
            public java.lang.Object getClassicLoadBalancers() {
                return this.jsiiGet("classicLoadBalancers", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     */
    public static interface EbsBlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        java.lang.Object getIops();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        java.lang.String getSnapshotId();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        java.lang.String getVolumeType();

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsBlockDeviceProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Object _iops;
            @javax.annotation.Nullable
            private java.lang.String _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Object _volumeSize;
            @javax.annotation.Nullable
            private java.lang.String _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EbsBlockDeviceProperty build() {
                return new EbsBlockDeviceProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Object $iops = _iops;
                    @javax.annotation.Nullable
                    private final java.lang.String $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private final java.lang.String $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public java.lang.Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public java.lang.String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public java.lang.Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public java.lang.String getVolumeType() {
                        return this.$volumeType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                        obj.set("iops", om.valueToTree(this.getIops()));
                        obj.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                        obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                        obj.set("volumeType", om.valueToTree(this.getVolumeType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     */
    public static interface FleetLaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        java.lang.String getVersion();
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        java.lang.String getLaunchTemplateId();
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        java.lang.String getLaunchTemplateName();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FleetLaunchTemplateSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _version;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateId;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateName;

            /**
             * Sets the value of Version
             * @param value `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(final java.lang.String value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of LaunchTemplateId
             * @param value `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FleetLaunchTemplateSpecificationProperty build() {
                return new FleetLaunchTemplateSpecificationProperty() {
                    private final java.lang.String $version = java.util.Objects.requireNonNull(_version, "version is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateId = _launchTemplateId;
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateName = _launchTemplateName;

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("version", om.valueToTree(this.getVersion()));
                        obj.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                        obj.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
             */
            @Override
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     */
    public static interface GroupIdentifierProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        java.lang.String getGroupId();

        /**
         * @return a {@link Builder} of {@link GroupIdentifierProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GroupIdentifierProperty}
         */
        final class Builder {
            private java.lang.String _groupId;

            /**
             * Sets the value of GroupId
             * @param value `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
             * @return {@code this}
             */
            public Builder withGroupId(final java.lang.String value) {
                this._groupId = java.util.Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GroupIdentifierProperty build() {
                return new GroupIdentifierProperty() {
                    private final java.lang.String $groupId = java.util.Objects.requireNonNull(_groupId, "groupId is required");

                    @Override
                    public java.lang.String getGroupId() {
                        return this.$groupId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("groupId", om.valueToTree(this.getGroupId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.GroupIdentifierProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            @Override
            public java.lang.String getGroupId() {
                return this.jsiiGet("groupId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     */
    public static interface IamInstanceProfileSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _arn;

            /**
             * Sets the value of Arn
             * @param value `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
             * @return {@code this}
             */
            public Builder withArn(@javax.annotation.Nullable final java.lang.String value) {
                this._arn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IamInstanceProfileSpecificationProperty build() {
                return new IamInstanceProfileSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $arn = _arn;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("arn", om.valueToTree(this.getArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        final class Builder {
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
             * @return {@code this}
             */
            public Builder withIpv6Address(final java.lang.String value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty() {
                    private final java.lang.String $ipv6Address = java.util.Objects.requireNonNull(_ipv6Address, "ipv6Address is required");

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            @Override
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     */
    public static interface InstanceNetworkInterfaceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        java.lang.String getDescription();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        java.util.List<java.lang.String> getGroups();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        java.lang.String getNetworkInterfaceId();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Object _deviceIndex;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _groups;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.String _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Object _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
             * @return {@code this}
             */
            public Builder withGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceNetworkInterfaceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new InstanceNetworkInterfaceSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deviceIndex = _deviceIndex;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $groups = _groups;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private final java.lang.Object $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public java.util.List<java.lang.String> getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public java.lang.Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public java.lang.String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public java.lang.Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                        obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        obj.set("description", om.valueToTree(this.getDescription()));
                        obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                        obj.set("groups", om.valueToTree(this.getGroups()));
                        obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                        obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                        obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                        obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                        obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                        obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getGroups() {
                return this.jsiiGet("groups", java.util.List.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     */
    public static interface LaunchTemplateConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        java.lang.Object getLaunchTemplateSpecification();
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        java.lang.Object getOverrides();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _overrides;

            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * @return {@code this}
             */
            public Builder withOverrides(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._overrides = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * @return {@code this}
             */
            public Builder withOverrides(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._overrides = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateConfigProperty build() {
                return new LaunchTemplateConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchTemplateSpecification = _launchTemplateSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $overrides = _overrides;

                    @Override
                    public java.lang.Object getLaunchTemplateSpecification() {
                        return this.$launchTemplateSpecification;
                    }

                    @Override
                    public java.lang.Object getOverrides() {
                        return this.$overrides;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                        obj.set("overrides", om.valueToTree(this.getOverrides()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateSpecification() {
                return this.jsiiGet("launchTemplateSpecification", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOverrides() {
                return this.jsiiGet("overrides", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     */
    public static interface LaunchTemplateOverridesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        java.lang.String getAvailabilityZone();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        java.lang.String getSpotPrice();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        java.lang.String getSubnetId();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        java.lang.Object getWeightedCapacity();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateOverridesProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateOverridesProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Object _weightedCapacity;

            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
             * @return {@code this}
             */
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
             * @return {@code this}
             */
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateOverridesProperty build() {
                return new LaunchTemplateOverridesProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public java.lang.Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        obj.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                        obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        obj.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateOverridesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     */
    public static interface LoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        java.lang.Object getClassicLoadBalancersConfig();
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        java.lang.Object getTargetGroupsConfig();

        /**
         * @return a {@link Builder} of {@link LoadBalancersConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancersConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _classicLoadBalancersConfig;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupsConfig;

            /**
             * Sets the value of ClassicLoadBalancersConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * @return {@code this}
             */
            public Builder withClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of ClassicLoadBalancersConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * @return {@code this}
             */
            public Builder withClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupsConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * @return {@code this}
             */
            public Builder withTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._targetGroupsConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupsConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * @return {@code this}
             */
            public Builder withTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty value) {
                this._targetGroupsConfig = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoadBalancersConfigProperty build() {
                return new LoadBalancersConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $classicLoadBalancersConfig = _classicLoadBalancersConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $targetGroupsConfig = _targetGroupsConfig;

                    @Override
                    public java.lang.Object getClassicLoadBalancersConfig() {
                        return this.$classicLoadBalancersConfig;
                    }

                    @Override
                    public java.lang.Object getTargetGroupsConfig() {
                        return this.$targetGroupsConfig;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("classicLoadBalancersConfig", om.valueToTree(this.getClassicLoadBalancersConfig()));
                        obj.set("targetGroupsConfig", om.valueToTree(this.getTargetGroupsConfig()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getClassicLoadBalancersConfig() {
                return this.jsiiGet("classicLoadBalancersConfig", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupsConfig() {
                return this.jsiiGet("targetGroupsConfig", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     */
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        java.lang.String getPrivateIpAddress();
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        java.lang.Object getPrimary();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _primary;

            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._primary = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty() {
                    private final java.lang.String $privateIpAddress = java.util.Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $primary = _primary;

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        obj.set("primary", om.valueToTree(this.getPrimary()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            @Override
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     */
    public static interface SpotFleetLaunchSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        java.lang.String getImageId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        java.lang.Object getBlockDeviceMappings();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        java.lang.Object getEbsOptimized();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        java.lang.Object getIamInstanceProfile();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        java.lang.String getKernelId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        java.lang.String getKeyName();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        java.lang.Object getMonitoring();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        java.lang.Object getNetworkInterfaces();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        java.lang.Object getPlacement();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        java.lang.String getRamdiskId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        java.lang.Object getSecurityGroups();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        java.lang.String getSpotPrice();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        java.lang.String getSubnetId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        java.lang.Object getTagSpecifications();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        java.lang.String getUserData();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        java.lang.Object getWeightedCapacity();

        /**
         * @return a {@link Builder} of {@link SpotFleetLaunchSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetLaunchSpecificationProperty}
         */
        final class Builder {
            private java.lang.String _imageId;
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.Object _blockDeviceMappings;
            @javax.annotation.Nullable
            private java.lang.Object _ebsOptimized;
            @javax.annotation.Nullable
            private java.lang.Object _iamInstanceProfile;
            @javax.annotation.Nullable
            private java.lang.String _kernelId;
            @javax.annotation.Nullable
            private java.lang.String _keyName;
            @javax.annotation.Nullable
            private java.lang.Object _monitoring;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaces;
            @javax.annotation.Nullable
            private java.lang.Object _placement;
            @javax.annotation.Nullable
            private java.lang.String _ramdiskId;
            @javax.annotation.Nullable
            private java.lang.Object _securityGroups;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Object _tagSpecifications;
            @javax.annotation.Nullable
            private java.lang.String _userData;
            @javax.annotation.Nullable
            private java.lang.Object _weightedCapacity;

            /**
             * Sets the value of ImageId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
             * @return {@code this}
             */
            public Builder withImageId(final java.lang.String value) {
                this._imageId = java.util.Objects.requireNonNull(value, "imageId is required");
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
             * @return {@code this}
             */
            public Builder withInstanceType(final java.lang.String value) {
                this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
             * @return {@code this}
             */
            public Builder withKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
             * @return {@code this}
             */
            public Builder withKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of RamdiskId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
             * @return {@code this}
             */
            public Builder withRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
                this._ramdiskId = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
             * @return {@code this}
             */
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
             * @return {@code this}
             */
            public Builder withUserData(@javax.annotation.Nullable final java.lang.String value) {
                this._userData = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
             * @return {@code this}
             */
            public Builder withWeightedCapacity(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetLaunchSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetLaunchSpecificationProperty build() {
                return new SpotFleetLaunchSpecificationProperty() {
                    private final java.lang.String $imageId = java.util.Objects.requireNonNull(_imageId, "imageId is required");
                    private final java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockDeviceMappings = _blockDeviceMappings;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebsOptimized = _ebsOptimized;
                    @javax.annotation.Nullable
                    private final java.lang.Object $iamInstanceProfile = _iamInstanceProfile;
                    @javax.annotation.Nullable
                    private final java.lang.String $kernelId = _kernelId;
                    @javax.annotation.Nullable
                    private final java.lang.String $keyName = _keyName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $monitoring = _monitoring;
                    @javax.annotation.Nullable
                    private final java.lang.Object $networkInterfaces = _networkInterfaces;
                    @javax.annotation.Nullable
                    private final java.lang.Object $placement = _placement;
                    @javax.annotation.Nullable
                    private final java.lang.String $ramdiskId = _ramdiskId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $securityGroups = _securityGroups;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagSpecifications = _tagSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.String $userData = _userData;
                    @javax.annotation.Nullable
                    private final java.lang.Object $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public java.lang.Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public java.lang.Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public java.lang.String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public java.lang.String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public java.lang.Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public java.lang.Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public java.lang.String getRamdiskId() {
                        return this.$ramdiskId;
                    }

                    @Override
                    public java.lang.Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public java.lang.Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public java.lang.String getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public java.lang.Object getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("imageId", om.valueToTree(this.getImageId()));
                        obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                        obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                        obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                        obj.set("kernelId", om.valueToTree(this.getKernelId()));
                        obj.set("keyName", om.valueToTree(this.getKeyName()));
                        obj.set("monitoring", om.valueToTree(this.getMonitoring()));
                        obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                        obj.set("placement", om.valueToTree(this.getPlacement()));
                        obj.set("ramdiskId", om.valueToTree(this.getRamdiskId()));
                        obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                        obj.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                        obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                        obj.set("userData", om.valueToTree(this.getUserData()));
                        obj.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            @Override
            public java.lang.String getImageId() {
                return this.jsiiGet("imageId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            @Override
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKernelId() {
                return this.jsiiGet("kernelId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKeyName() {
                return this.jsiiGet("keyName", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRamdiskId() {
                return this.jsiiGet("ramdiskId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getUserData() {
                return this.jsiiGet("userData", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     */
    public static interface SpotFleetMonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link SpotFleetMonitoringProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetMonitoringProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Enabled
             * @param value `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetMonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetMonitoringProperty build() {
                return new SpotFleetMonitoringProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    public static interface SpotFleetRequestConfigDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        java.lang.String getIamFleetRole();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        java.lang.Object getTargetCapacity();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        java.lang.String getAllocationStrategy();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        java.lang.String getExcessCapacityTerminationPolicy();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        java.lang.String getInstanceInterruptionBehavior();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        java.lang.Object getLaunchSpecifications();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        java.lang.Object getLaunchTemplateConfigs();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        java.lang.Object getLoadBalancersConfig();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        java.lang.Object getReplaceUnhealthyInstances();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        java.lang.String getSpotPrice();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        java.lang.Object getTerminateInstancesWithExpiration();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        java.lang.String getType();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        java.lang.String getValidFrom();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        java.lang.String getValidUntil();

        /**
         * @return a {@link Builder} of {@link SpotFleetRequestConfigDataProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetRequestConfigDataProperty}
         */
        final class Builder {
            private java.lang.String _iamFleetRole;
            private java.lang.Object _targetCapacity;
            @javax.annotation.Nullable
            private java.lang.String _allocationStrategy;
            @javax.annotation.Nullable
            private java.lang.String _excessCapacityTerminationPolicy;
            @javax.annotation.Nullable
            private java.lang.String _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _launchSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateConfigs;
            @javax.annotation.Nullable
            private java.lang.Object _loadBalancersConfig;
            @javax.annotation.Nullable
            private java.lang.Object _replaceUnhealthyInstances;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.Object _terminateInstancesWithExpiration;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _validFrom;
            @javax.annotation.Nullable
            private java.lang.String _validUntil;

            /**
             * Sets the value of IamFleetRole
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
             * @return {@code this}
             */
            public Builder withIamFleetRole(final java.lang.String value) {
                this._iamFleetRole = java.util.Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }
            /**
             * Sets the value of TargetCapacity
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
             * @return {@code this}
             */
            public Builder withTargetCapacity(final java.lang.Number value) {
                this._targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }
            /**
             * Sets the value of TargetCapacity
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
             * @return {@code this}
             */
            public Builder withTargetCapacity(final software.amazon.awscdk.Token value) {
                this._targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }
            /**
             * Sets the value of AllocationStrategy
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
             * @return {@code this}
             */
            public Builder withAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this._allocationStrategy = value;
                return this;
            }
            /**
             * Sets the value of ExcessCapacityTerminationPolicy
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
             * @return {@code this}
             */
            public Builder withExcessCapacityTerminationPolicy(@javax.annotation.Nullable final java.lang.String value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }
            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of LaunchSpecifications
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * @return {@code this}
             */
            public Builder withLaunchSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LaunchSpecifications
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * @return {@code this}
             */
            public Builder withLaunchSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._launchSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateConfigs
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * @return {@code this}
             */
            public Builder withLaunchTemplateConfigs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._launchTemplateConfigs = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateConfigs
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * @return {@code this}
             */
            public Builder withLaunchTemplateConfigs(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._launchTemplateConfigs = value;
                return this;
            }
            /**
             * Sets the value of LoadBalancersConfig
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * @return {@code this}
             */
            public Builder withLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._loadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of LoadBalancersConfig
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * @return {@code this}
             */
            public Builder withLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty value) {
                this._loadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of ReplaceUnhealthyInstances
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * @return {@code this}
             */
            public Builder withReplaceUnhealthyInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }
            /**
             * Sets the value of ReplaceUnhealthyInstances
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * @return {@code this}
             */
            public Builder withReplaceUnhealthyInstances(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
             * @return {@code this}
             */
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of TerminateInstancesWithExpiration
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * @return {@code this}
             */
            public Builder withTerminateInstancesWithExpiration(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }
            /**
             * Sets the value of TerminateInstancesWithExpiration
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * @return {@code this}
             */
            public Builder withTerminateInstancesWithExpiration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of ValidFrom
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
             * @return {@code this}
             */
            public Builder withValidFrom(@javax.annotation.Nullable final java.lang.String value) {
                this._validFrom = value;
                return this;
            }
            /**
             * Sets the value of ValidUntil
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
             * @return {@code this}
             */
            public Builder withValidUntil(@javax.annotation.Nullable final java.lang.String value) {
                this._validUntil = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetRequestConfigDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetRequestConfigDataProperty build() {
                return new SpotFleetRequestConfigDataProperty() {
                    private final java.lang.String $iamFleetRole = java.util.Objects.requireNonNull(_iamFleetRole, "iamFleetRole is required");
                    private final java.lang.Object $targetCapacity = java.util.Objects.requireNonNull(_targetCapacity, "targetCapacity is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $allocationStrategy = _allocationStrategy;
                    @javax.annotation.Nullable
                    private final java.lang.String $excessCapacityTerminationPolicy = _excessCapacityTerminationPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchSpecifications = _launchSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchTemplateConfigs = _launchTemplateConfigs;
                    @javax.annotation.Nullable
                    private final java.lang.Object $loadBalancersConfig = _loadBalancersConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $replaceUnhealthyInstances = _replaceUnhealthyInstances;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private final java.lang.Object $terminateInstancesWithExpiration = _terminateInstancesWithExpiration;
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private final java.lang.String $validFrom = _validFrom;
                    @javax.annotation.Nullable
                    private final java.lang.String $validUntil = _validUntil;

                    @Override
                    public java.lang.String getIamFleetRole() {
                        return this.$iamFleetRole;
                    }

                    @Override
                    public java.lang.Object getTargetCapacity() {
                        return this.$targetCapacity;
                    }

                    @Override
                    public java.lang.String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public java.lang.String getExcessCapacityTerminationPolicy() {
                        return this.$excessCapacityTerminationPolicy;
                    }

                    @Override
                    public java.lang.String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public java.lang.Object getLaunchSpecifications() {
                        return this.$launchSpecifications;
                    }

                    @Override
                    public java.lang.Object getLaunchTemplateConfigs() {
                        return this.$launchTemplateConfigs;
                    }

                    @Override
                    public java.lang.Object getLoadBalancersConfig() {
                        return this.$loadBalancersConfig;
                    }

                    @Override
                    public java.lang.Object getReplaceUnhealthyInstances() {
                        return this.$replaceUnhealthyInstances;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public java.lang.Object getTerminateInstancesWithExpiration() {
                        return this.$terminateInstancesWithExpiration;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.String getValidFrom() {
                        return this.$validFrom;
                    }

                    @Override
                    public java.lang.String getValidUntil() {
                        return this.$validUntil;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("iamFleetRole", om.valueToTree(this.getIamFleetRole()));
                        obj.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                        obj.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                        obj.set("excessCapacityTerminationPolicy", om.valueToTree(this.getExcessCapacityTerminationPolicy()));
                        obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                        obj.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                        obj.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
                        obj.set("loadBalancersConfig", om.valueToTree(this.getLoadBalancersConfig()));
                        obj.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
                        obj.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                        obj.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
                        obj.set("type", om.valueToTree(this.getType()));
                        obj.set("validFrom", om.valueToTree(this.getValidFrom()));
                        obj.set("validUntil", om.valueToTree(this.getValidUntil()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            @Override
            public java.lang.String getIamFleetRole() {
                return this.jsiiGet("iamFleetRole", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            @Override
            public java.lang.Object getTargetCapacity() {
                return this.jsiiGet("targetCapacity", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAllocationStrategy() {
                return this.jsiiGet("allocationStrategy", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getExcessCapacityTerminationPolicy() {
                return this.jsiiGet("excessCapacityTerminationPolicy", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchSpecifications() {
                return this.jsiiGet("launchSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateConfigs() {
                return this.jsiiGet("launchTemplateConfigs", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLoadBalancersConfig() {
                return this.jsiiGet("loadBalancersConfig", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getReplaceUnhealthyInstances() {
                return this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTerminateInstancesWithExpiration() {
                return this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValidFrom() {
                return this.jsiiGet("validFrom", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValidUntil() {
                return this.jsiiGet("validUntil", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     */
    public static interface SpotFleetTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        java.lang.String getResourceType();
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        java.util.List<software.amazon.awscdk.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link SpotFleetTagSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetTagSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _resourceType;
            @javax.annotation.Nullable
            private java.util.List<software.amazon.awscdk.CfnTag> _tags;

            /**
             * Sets the value of ResourceType
             * @param value `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotFleetTagSpecificationProperty build() {
                return new SpotFleetTagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;

                    @Override
                    public java.lang.String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                        return this.$tags;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceType", om.valueToTree(this.getResourceType()));
                        obj.set("tags", om.valueToTree(this.getTags()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getResourceType() {
                return this.jsiiGet("resourceType", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.jsiiGet("tags", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     */
    public static interface SpotPlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        java.lang.String getAvailabilityZone();
        /**
         * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        java.lang.String getGroupName();
        /**
         * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        java.lang.String getTenancy();

        /**
         * @return a {@link Builder} of {@link SpotPlacementProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotPlacementProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _groupName;
            @javax.annotation.Nullable
            private java.lang.String _tenancy;

            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value `CfnSpotFleet.SpotPlacementProperty.GroupName`.
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
             * @return {@code this}
             */
            public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this._tenancy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotPlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotPlacementProperty build() {
                return new SpotPlacementProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $groupName = _groupName;
                    @javax.annotation.Nullable
                    private final java.lang.String $tenancy = _tenancy;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public java.lang.String getTenancy() {
                        return this.$tenancy;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        obj.set("groupName", om.valueToTree(this.getGroupName()));
                        obj.set("tenancy", om.valueToTree(this.getTenancy()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getGroupName() {
                return this.jsiiGet("groupName", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTenancy() {
                return this.jsiiGet("tenancy", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     */
    public static interface TargetGroupProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.TargetGroupProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link TargetGroupProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupProperty}
         */
        final class Builder {
            private java.lang.String _arn;

            /**
             * Sets the value of Arn
             * @param value `CfnSpotFleet.TargetGroupProperty.Arn`.
             * @return {@code this}
             */
            public Builder withArn(final java.lang.String value) {
                this._arn = java.util.Objects.requireNonNull(value, "arn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupProperty build() {
                return new TargetGroupProperty() {
                    private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("arn", om.valueToTree(this.getArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.TargetGroupProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
             */
            @Override
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     */
    public static interface TargetGroupsConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        java.lang.Object getTargetGroups();

        /**
         * @return a {@link Builder} of {@link TargetGroupsConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupsConfigProperty}
         */
        final class Builder {
            private java.lang.Object _targetGroups;

            /**
             * Sets the value of TargetGroups
             * @param value `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
             * @return {@code this}
             */
            public Builder withTargetGroups(final software.amazon.awscdk.Token value) {
                this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }
            /**
             * Sets the value of TargetGroups
             * @param value `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
             * @return {@code this}
             */
            public Builder withTargetGroups(final java.util.List<java.lang.Object> value) {
                this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupsConfigProperty build() {
                return new TargetGroupsConfigProperty() {
                    private final java.lang.Object $targetGroups = java.util.Objects.requireNonNull(_targetGroups, "targetGroups is required");

                    @Override
                    public java.lang.Object getTargetGroups() {
                        return this.$targetGroups;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
             */
            @Override
            public java.lang.Object getTargetGroups() {
                return this.jsiiGet("targetGroups", java.lang.Object.class);
            }
        }
    }
}
