package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPNConnection`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:01.993Z")
public interface CfnVPNConnectionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    java.lang.String getCustomerGatewayId();
    /**
     * `AWS::EC2::VPNConnection.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    java.lang.String getType();
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    java.lang.String getVpnGatewayId();
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    java.lang.Object getStaticRoutesOnly();
    /**
     * `AWS::EC2::VPNConnection.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    java.util.List<software.amazon.awscdk.CfnTag> getTags();
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    java.lang.Object getVpnTunnelOptionsSpecifications();

    /**
     * @return a {@link Builder} of {@link CfnVPNConnectionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnVPNConnectionProps}
     */
    final class Builder {
        private java.lang.String _customerGatewayId;
        private java.lang.String _type;
        private java.lang.String _vpnGatewayId;
        @javax.annotation.Nullable
        private java.lang.Object _staticRoutesOnly;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.CfnTag> _tags;
        @javax.annotation.Nullable
        private java.lang.Object _vpnTunnelOptionsSpecifications;

        /**
         * Sets the value of CustomerGatewayId
         * @param value `AWS::EC2::VPNConnection.CustomerGatewayId`.
         * @return {@code this}
         */
        public Builder withCustomerGatewayId(final java.lang.String value) {
            this._customerGatewayId = java.util.Objects.requireNonNull(value, "customerGatewayId is required");
            return this;
        }
        /**
         * Sets the value of Type
         * @param value `AWS::EC2::VPNConnection.Type`.
         * @return {@code this}
         */
        public Builder withType(final java.lang.String value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of VpnGatewayId
         * @param value `AWS::EC2::VPNConnection.VpnGatewayId`.
         * @return {@code this}
         */
        public Builder withVpnGatewayId(final java.lang.String value) {
            this._vpnGatewayId = java.util.Objects.requireNonNull(value, "vpnGatewayId is required");
            return this;
        }
        /**
         * Sets the value of StaticRoutesOnly
         * @param value `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * @return {@code this}
         */
        public Builder withStaticRoutesOnly(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._staticRoutesOnly = value;
            return this;
        }
        /**
         * Sets the value of StaticRoutesOnly
         * @param value `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * @return {@code this}
         */
        public Builder withStaticRoutesOnly(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._staticRoutesOnly = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::EC2::VPNConnection.Tags`.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
            this._tags = value;
            return this;
        }
        /**
         * Sets the value of VpnTunnelOptionsSpecifications
         * @param value `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * @return {@code this}
         */
        public Builder withVpnTunnelOptionsSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._vpnTunnelOptionsSpecifications = value;
            return this;
        }
        /**
         * Sets the value of VpnTunnelOptionsSpecifications
         * @param value `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * @return {@code this}
         */
        public Builder withVpnTunnelOptionsSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this._vpnTunnelOptionsSpecifications = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPNConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnVPNConnectionProps build() {
            return new CfnVPNConnectionProps() {
                private final java.lang.String $customerGatewayId = java.util.Objects.requireNonNull(_customerGatewayId, "customerGatewayId is required");
                private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");
                private final java.lang.String $vpnGatewayId = java.util.Objects.requireNonNull(_vpnGatewayId, "vpnGatewayId is required");
                @javax.annotation.Nullable
                private final java.lang.Object $staticRoutesOnly = _staticRoutesOnly;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;
                @javax.annotation.Nullable
                private final java.lang.Object $vpnTunnelOptionsSpecifications = _vpnTunnelOptionsSpecifications;

                @Override
                public java.lang.String getCustomerGatewayId() {
                    return this.$customerGatewayId;
                }

                @Override
                public java.lang.String getType() {
                    return this.$type;
                }

                @Override
                public java.lang.String getVpnGatewayId() {
                    return this.$vpnGatewayId;
                }

                @Override
                public java.lang.Object getStaticRoutesOnly() {
                    return this.$staticRoutesOnly;
                }

                @Override
                public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public java.lang.Object getVpnTunnelOptionsSpecifications() {
                    return this.$vpnTunnelOptionsSpecifications;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("customerGatewayId", om.valueToTree(this.getCustomerGatewayId()));
                    obj.set("type", om.valueToTree(this.getType()));
                    obj.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
                    obj.set("staticRoutesOnly", om.valueToTree(this.getStaticRoutesOnly()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    obj.set("vpnTunnelOptionsSpecifications", om.valueToTree(this.getVpnTunnelOptionsSpecifications()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnVPNConnectionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::VPNConnection.CustomerGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
         */
        @Override
        public java.lang.String getCustomerGatewayId() {
            return this.jsiiGet("customerGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPNConnection.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
         */
        @Override
        public java.lang.String getType() {
            return this.jsiiGet("type", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPNConnection.VpnGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
         */
        @Override
        public java.lang.String getVpnGatewayId() {
            return this.jsiiGet("vpnGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getStaticRoutesOnly() {
            return this.jsiiGet("staticRoutesOnly", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::VPNConnection.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getVpnTunnelOptionsSpecifications() {
            return this.jsiiGet("vpnTunnelOptionsSpecifications", java.lang.Object.class);
        }
    }
}
