package software.amazon.awscdk.services.ec2;

/**
 * VpcNetwork deploys an AWS VPC, with public and private subnets per Availability Zone. For example:.
 * 
 * import { VpcNetwork } from '@aws-cdk/aws-ec2'
 * 
 * const vpc = new VpcNetwork(this, {
 *    cidr: "10.0.0.0/16"
 * })
 * 
 * // Iterate the public subnets
 * for (let subnet of vpc.publicSubnets) {
 * 
 * }
 * 
 * // Iterate the private subnets
 * for (let subnet of vpc.privateSubnets) {
 * 
 * }
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:02.043Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpcNetwork")
public class VpcNetwork extends software.amazon.awscdk.Construct {
    protected VpcNetwork(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        DEFAULT_CIDR_RANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcNetwork.class, "DEFAULT_CIDR_RANGE", java.lang.String.class);
        DEFAULT_SUBNETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcNetwork.class, "DEFAULT_SUBNETS", java.util.List.class);
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region. It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone. Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway. Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    public VpcNetwork(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcNetworkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region. It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone. Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway. Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    public VpcNetwork(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an exported VPC.
     */
    public static software.amazon.awscdk.services.ec2.IVpcNetwork import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcNetworkImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.VpcNetwork.class, "import", software.amazon.awscdk.services.ec2.IVpcNetwork.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing VPC from context.
     */
    public static software.amazon.awscdk.services.ec2.IVpcNetwork importFromContext(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcNetworkProviderProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.VpcNetwork.class, "importFromContext", software.amazon.awscdk.services.ec2.IVpcNetwork.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a new DynamoDB gateway endpoint to this VPC.
     */
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addDynamoDbEndpoint(final java.lang.String id, @javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
        return this.jsiiCall("addDynamoDbEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), subnets });
    }

    /**
     * Adds a new DynamoDB gateway endpoint to this VPC.
     */
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addDynamoDbEndpoint(final java.lang.String id) {
        return this.jsiiCall("addDynamoDbEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a new gateway endpoint to this VPC.
     */
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addGatewayEndpoint(final java.lang.String id, final software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions options) {
        return this.jsiiCall("addGatewayEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new interface endpoint to this VPC.
     */
    public software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint addInterfaceEndpoint(final java.lang.String id, final software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions options) {
        return this.jsiiCall("addInterfaceEndpoint", software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new S3 gateway endpoint to this VPC.
     */
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addS3Endpoint(final java.lang.String id, @javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
        return this.jsiiCall("addS3Endpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), subnets });
    }

    /**
     * Adds a new S3 gateway endpoint to this VPC.
     */
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addS3Endpoint(final java.lang.String id) {
        return this.jsiiCall("addS3Endpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a new VPN connection to this VPC.
     */
    public software.amazon.awscdk.services.ec2.VpnConnection addVpnConnection(final java.lang.String id, final software.amazon.awscdk.services.ec2.VpnConnectionOptions options) {
        return this.jsiiCall("addVpnConnection", software.amazon.awscdk.services.ec2.VpnConnection.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Export this VPC from the stack.
     */
    public software.amazon.awscdk.services.ec2.VpcNetworkImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.ec2.VpcNetworkImportProps.class);
    }

    /**
     * Return whether all of the given subnets are from the VPC's public subnets.
     */
    public java.lang.Boolean isPublicSubnets(final java.util.List<java.lang.String> subnetIds) {
        return this.jsiiCall("isPublicSubnets", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(subnetIds, "subnetIds is required") });
    }

    /**
     * Return IDs of the subnets appropriate for the given selection strategy.
     * 
     * Requires that at least one subnet is matched, throws a descriptive
     * error message otherwise.
     */
    public java.util.List<java.lang.String> selectSubnetIds(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return this.jsiiCall("selectSubnetIds", java.util.List.class, new Object[] { selection });
    }

    /**
     * Return IDs of the subnets appropriate for the given selection strategy.
     * 
     * Requires that at least one subnet is matched, throws a descriptive
     * error message otherwise.
     */
    public java.util.List<java.lang.String> selectSubnetIds() {
        return this.jsiiCall("selectSubnetIds", java.util.List.class);
    }

    /**
     * Return the subnets appropriate for the placement strategy.
     */
    protected java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> selectSubnetObjects(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return this.jsiiCall("selectSubnetObjects", java.util.List.class, new Object[] { selection });
    }

    /**
     * Return the subnets appropriate for the placement strategy.
     */
    protected java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> selectSubnetObjects() {
        return this.jsiiCall("selectSubnetObjects", java.util.List.class);
    }

    /**
     * Returns IDs of selected subnets.
     */
    public software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return this.jsiiCall("selectSubnets", software.amazon.awscdk.services.ec2.SelectedSubnets.class, new Object[] { selection });
    }

    /**
     * Returns IDs of selected subnets.
     */
    public software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets() {
        return this.jsiiCall("selectSubnets", software.amazon.awscdk.services.ec2.SelectedSubnets.class);
    }
    /**
     * The default CIDR range used when creating VPCs. This can be overridden using VpcNetworkProps when creating a VPCNetwork resource. e.g. new VpcResource(this, { cidr: '192.168.0.0./16' }).
     */
    public final static java.lang.String DEFAULT_CIDR_RANGE;
    /**
     * The default subnet configuration.
     * 
     * 1 Public and 1 Private subnet per AZ evenly split
     */
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS;

    /**
     * AZs for this VPC.
     */
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return this.jsiiGet("availabilityZones", java.util.List.class);
    }

    /**
     * @return The IPv4 CidrBlock as returned by the VPC
     */
    public java.lang.String getCidr() {
        return this.jsiiGet("cidr", java.lang.String.class);
    }

    /**
     * Dependencies for internet connectivity.
     */
    public java.util.List<software.amazon.awscdk.IConstruct> getInternetDependencies() {
        return this.jsiiGet("internetDependencies", java.util.List.class);
    }

    /**
     * List of isolated subnets in this VPC.
     */
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getIsolatedSubnets() {
        return this.jsiiGet("isolatedSubnets", java.util.List.class);
    }

    /**
     * Dependencies for NAT connectivity.
     */
    public java.util.List<software.amazon.awscdk.IConstruct> getNatDependencies() {
        return this.jsiiGet("natDependencies", java.util.List.class);
    }

    /**
     * List of private subnets in this VPC.
     */
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPrivateSubnets() {
        return this.jsiiGet("privateSubnets", java.util.List.class);
    }

    /**
     * List of public subnets in this VPC.
     */
    public java.util.List<software.amazon.awscdk.services.ec2.IVpcSubnet> getPublicSubnets() {
        return this.jsiiGet("publicSubnets", java.util.List.class);
    }

    /**
     * Identifier for this VPC.
     */
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     * The region where this VPC is defined.
     */
    public java.lang.String getVpcRegion() {
        return this.jsiiGet("vpcRegion", java.lang.String.class);
    }

    /**
     * Identifier for the VPN gateway.
     */
    @javax.annotation.Nullable
    public java.lang.String getVpnGatewayId() {
        return this.jsiiGet("vpnGatewayId", java.lang.String.class);
    }
}
