package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Subnet`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:52:34.297Z")
public interface CfnSubnetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::Subnet.CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     */
    java.lang.String getCidrBlock();
    /**
     * `AWS::EC2::Subnet.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     */
    java.lang.String getVpcId();
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     */
    java.lang.Object getAssignIpv6AddressOnCreation();
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     */
    java.lang.String getAvailabilityZone();
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     */
    java.lang.String getIpv6CidrBlock();
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     */
    java.lang.Object getMapPublicIpOnLaunch();
    /**
     * `AWS::EC2::Subnet.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     */
    java.util.List<software.amazon.awscdk.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnSubnetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnSubnetProps}
     */
    final class Builder {
        private java.lang.String _cidrBlock;
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.lang.Object _assignIpv6AddressOnCreation;
        @javax.annotation.Nullable
        private java.lang.String _availabilityZone;
        @javax.annotation.Nullable
        private java.lang.String _ipv6CidrBlock;
        @javax.annotation.Nullable
        private java.lang.Object _mapPublicIpOnLaunch;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.CfnTag> _tags;

        /**
         * Sets the value of CidrBlock
         * @param value `AWS::EC2::Subnet.CidrBlock`.
         * @return {@code this}
         */
        public Builder withCidrBlock(final java.lang.String value) {
            this._cidrBlock = java.util.Objects.requireNonNull(value, "cidrBlock is required");
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value `AWS::EC2::Subnet.VpcId`.
         * @return {@code this}
         */
        public Builder withVpcId(final java.lang.String value) {
            this._vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
            return this;
        }
        /**
         * Sets the value of AssignIpv6AddressOnCreation
         * @param value `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
         * @return {@code this}
         */
        public Builder withAssignIpv6AddressOnCreation(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._assignIpv6AddressOnCreation = value;
            return this;
        }
        /**
         * Sets the value of AssignIpv6AddressOnCreation
         * @param value `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
         * @return {@code this}
         */
        public Builder withAssignIpv6AddressOnCreation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._assignIpv6AddressOnCreation = value;
            return this;
        }
        /**
         * Sets the value of AvailabilityZone
         * @param value `AWS::EC2::Subnet.AvailabilityZone`.
         * @return {@code this}
         */
        public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
            this._availabilityZone = value;
            return this;
        }
        /**
         * Sets the value of Ipv6CidrBlock
         * @param value `AWS::EC2::Subnet.Ipv6CidrBlock`.
         * @return {@code this}
         */
        public Builder withIpv6CidrBlock(@javax.annotation.Nullable final java.lang.String value) {
            this._ipv6CidrBlock = value;
            return this;
        }
        /**
         * Sets the value of MapPublicIpOnLaunch
         * @param value `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
         * @return {@code this}
         */
        public Builder withMapPublicIpOnLaunch(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._mapPublicIpOnLaunch = value;
            return this;
        }
        /**
         * Sets the value of MapPublicIpOnLaunch
         * @param value `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
         * @return {@code this}
         */
        public Builder withMapPublicIpOnLaunch(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._mapPublicIpOnLaunch = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::EC2::Subnet.Tags`.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubnetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnSubnetProps build() {
            return new CfnSubnetProps() {
                private final java.lang.String $cidrBlock = java.util.Objects.requireNonNull(_cidrBlock, "cidrBlock is required");
                private final java.lang.String $vpcId = java.util.Objects.requireNonNull(_vpcId, "vpcId is required");
                @javax.annotation.Nullable
                private final java.lang.Object $assignIpv6AddressOnCreation = _assignIpv6AddressOnCreation;
                @javax.annotation.Nullable
                private final java.lang.String $availabilityZone = _availabilityZone;
                @javax.annotation.Nullable
                private final java.lang.String $ipv6CidrBlock = _ipv6CidrBlock;
                @javax.annotation.Nullable
                private final java.lang.Object $mapPublicIpOnLaunch = _mapPublicIpOnLaunch;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;

                @Override
                public java.lang.String getCidrBlock() {
                    return this.$cidrBlock;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public java.lang.Object getAssignIpv6AddressOnCreation() {
                    return this.$assignIpv6AddressOnCreation;
                }

                @Override
                public java.lang.String getAvailabilityZone() {
                    return this.$availabilityZone;
                }

                @Override
                public java.lang.String getIpv6CidrBlock() {
                    return this.$ipv6CidrBlock;
                }

                @Override
                public java.lang.Object getMapPublicIpOnLaunch() {
                    return this.$mapPublicIpOnLaunch;
                }

                @Override
                public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                    return this.$tags;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
                    obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    obj.set("assignIpv6AddressOnCreation", om.valueToTree(this.getAssignIpv6AddressOnCreation()));
                    obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                    obj.set("ipv6CidrBlock", om.valueToTree(this.getIpv6CidrBlock()));
                    obj.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSubnetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::Subnet.CidrBlock`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
         */
        @Override
        public java.lang.String getCidrBlock() {
            return this.jsiiGet("cidrBlock", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Subnet.VpcId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getAssignIpv6AddressOnCreation() {
            return this.jsiiGet("assignIpv6AddressOnCreation", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::Subnet.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAvailabilityZone() {
            return this.jsiiGet("availabilityZone", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Subnet.Ipv6CidrBlock`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getIpv6CidrBlock() {
            return this.jsiiGet("ipv6CidrBlock", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Subnet.MapPublicIpOnLaunch`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getMapPublicIpOnLaunch() {
            return this.jsiiGet("mapPublicIpOnLaunch", java.lang.Object.class);
        }

        /**
         * `AWS::EC2::Subnet.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }
    }
}
