package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for a GatewayVpcEndpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:52:34.375Z")
public interface GatewayVpcEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions {
    /**
     * The VPC network in which the gateway endpoint will be used.
     */
    software.amazon.awscdk.services.ec2.IVpcNetwork getVpc();

    /**
     * @return a {@link Builder} of {@link GatewayVpcEndpointProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GatewayVpcEndpointProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        private software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService _service;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> _subnets;

        /**
         * Sets the value of Vpc
         * @param value The VPC network in which the gateway endpoint will be used.
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of Service
         * @param value The service to use for this gateway VPC endpoint.
         * @return {@code this}
         */
        public Builder withService(final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of Subnets
         * @param value Where to add endpoint routing.
         * @return {@code this}
         */
        public Builder withSubnets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> value) {
            this._subnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayVpcEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public GatewayVpcEndpointProps build() {
            return new GatewayVpcEndpointProps() {
                private final software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                private final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> $subnets = _subnets;

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
                    return this.$service;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
                    return this.$subnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("service", om.valueToTree(this.getService()));
                    obj.set("subnets", om.valueToTree(this.getSubnets()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.GatewayVpcEndpointProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC network in which the gateway endpoint will be used.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * The service to use for this gateway VPC endpoint.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
            return this.jsiiGet("service", software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService.class);
        }

        /**
         * Where to add endpoint routing.
         * 
         * Default: private subnets
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
            return this.jsiiGet("subnets", java.util.List.class);
        }
    }
}
