package software.amazon.awscdk.services.ec2;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:52:34.414Z")
public interface VpnConnectionOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ip address of the customer gateway.
     */
    java.lang.String getIp();
    /**
     * The ASN of the customer gateway.
     * 
     * Default: 65000
     */
    java.lang.Number getAsn();
    /**
     * The static routes to be routed from the VPN gateway to the customer gateway.
     * 
     * Default: Dynamic routing (BGP)
     */
    java.util.List<java.lang.String> getStaticRoutes();
    /**
     * The tunnel options for the VPN connection.
     * 
     * At most two elements (one per tunnel).
     * Duplicates not allowed.
     * 
     * Default: Amazon generated tunnel options
     */
    java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions();

    /**
     * @return a {@link Builder} of {@link VpnConnectionOptions}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpnConnectionOptions}
     */
    final class Builder {
        private java.lang.String _ip;
        @javax.annotation.Nullable
        private java.lang.Number _asn;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _staticRoutes;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> _tunnelOptions;

        /**
         * Sets the value of Ip
         * @param value The ip address of the customer gateway.
         * @return {@code this}
         */
        public Builder withIp(final java.lang.String value) {
            this._ip = java.util.Objects.requireNonNull(value, "ip is required");
            return this;
        }
        /**
         * Sets the value of Asn
         * @param value The ASN of the customer gateway.
         * @return {@code this}
         */
        public Builder withAsn(@javax.annotation.Nullable final java.lang.Number value) {
            this._asn = value;
            return this;
        }
        /**
         * Sets the value of StaticRoutes
         * @param value The static routes to be routed from the VPN gateway to the customer gateway.
         * @return {@code this}
         */
        public Builder withStaticRoutes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._staticRoutes = value;
            return this;
        }
        /**
         * Sets the value of TunnelOptions
         * @param value The tunnel options for the VPN connection.
         * @return {@code this}
         */
        public Builder withTunnelOptions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> value) {
            this._tunnelOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnConnectionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpnConnectionOptions build() {
            return new VpnConnectionOptions() {
                private final java.lang.String $ip = java.util.Objects.requireNonNull(_ip, "ip is required");
                @javax.annotation.Nullable
                private final java.lang.Number $asn = _asn;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $staticRoutes = _staticRoutes;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> $tunnelOptions = _tunnelOptions;

                @Override
                public java.lang.String getIp() {
                    return this.$ip;
                }

                @Override
                public java.lang.Number getAsn() {
                    return this.$asn;
                }

                @Override
                public java.util.List<java.lang.String> getStaticRoutes() {
                    return this.$staticRoutes;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
                    return this.$tunnelOptions;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("ip", om.valueToTree(this.getIp()));
                    obj.set("asn", om.valueToTree(this.getAsn()));
                    obj.set("staticRoutes", om.valueToTree(this.getStaticRoutes()));
                    obj.set("tunnelOptions", om.valueToTree(this.getTunnelOptions()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpnConnectionOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ip address of the customer gateway.
         */
        @Override
        public java.lang.String getIp() {
            return this.jsiiGet("ip", java.lang.String.class);
        }

        /**
         * The ASN of the customer gateway.
         * 
         * Default: 65000
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getAsn() {
            return this.jsiiGet("asn", java.lang.Number.class);
        }

        /**
         * The static routes to be routed from the VPN gateway to the customer gateway.
         * 
         * Default: Dynamic routing (BGP)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getStaticRoutes() {
            return this.jsiiGet("staticRoutes", java.util.List.class);
        }

        /**
         * The tunnel options for the VPN connection.
         * 
         * At most two elements (one per tunnel).
         * Duplicates not allowed.
         * 
         * Default: Amazon generated tunnel options
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
            return this.jsiiGet("tunnelOptions", java.util.List.class);
        }
    }
}
