/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate
extends CfnResource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLaunchTemplate.class, (String)"resourceTypeName", String.class);

    protected CfnLaunchTemplate(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnLaunchTemplate(Construct scope, String id, @Nullable CfnLaunchTemplateProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnLaunchTemplate(Construct scope, String id) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    protected Map<String, Object> renderProperties(@Nullable Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{properties});
    }

    public String getLaunchTemplateDefaultVersionNumber() {
        return (String)this.jsiiGet("launchTemplateDefaultVersionNumber", String.class);
    }

    public String getLaunchTemplateId() {
        return (String)this.jsiiGet("launchTemplateId", String.class);
    }

    public String getLaunchTemplateLatestVersionNumber() {
        return (String)this.jsiiGet("launchTemplateLatestVersionNumber", String.class);
    }

    public CfnLaunchTemplateProps getPropertyOverrides() {
        return (CfnLaunchTemplateProps)this.jsiiGet("propertyOverrides", CfnLaunchTemplateProps.class);
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public List<CfnTag> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _resourceType;
            @Nullable
            private List<CfnTag> _tags;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withTags(@Nullable List<CfnTag> value) {
                this._tags = value;
                return this;
            }

            public TagSpecificationProperty build() {
                return new TagSpecificationProperty(){
                    @Nullable
                    private final String $resourceType;
                    @Nullable
                    private final List<CfnTag> $tags;
                    {
                        this.$resourceType = _resourceType;
                        this.$tags = _tags;
                    }

                    @Override
                    public String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public List<CfnTag> getTags() {
                        return this.$tags;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("resourceType", om.valueToTree((Object)this.getResourceType()));
                        obj.set("tags", om.valueToTree(this.getTags()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface SpotOptionsProperty
    extends JsiiSerializable {
        public String getInstanceInterruptionBehavior();

        public String getMaxPrice();

        public String getSpotInstanceType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _instanceInterruptionBehavior;
            @Nullable
            private String _maxPrice;
            @Nullable
            private String _spotInstanceType;

            public Builder withInstanceInterruptionBehavior(@Nullable String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }

            public Builder withMaxPrice(@Nullable String value) {
                this._maxPrice = value;
                return this;
            }

            public Builder withSpotInstanceType(@Nullable String value) {
                this._spotInstanceType = value;
                return this;
            }

            public SpotOptionsProperty build() {
                return new SpotOptionsProperty(){
                    @Nullable
                    private final String $instanceInterruptionBehavior;
                    @Nullable
                    private final String $maxPrice;
                    @Nullable
                    private final String $spotInstanceType;
                    {
                        this.$instanceInterruptionBehavior = _instanceInterruptionBehavior;
                        this.$maxPrice = _maxPrice;
                        this.$spotInstanceType = _spotInstanceType;
                    }

                    @Override
                    public String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public String getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public String getSpotInstanceType() {
                        return this.$spotInstanceType;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("instanceInterruptionBehavior", om.valueToTree((Object)this.getInstanceInterruptionBehavior()));
                        obj.set("maxPrice", om.valueToTree((Object)this.getMaxPrice()));
                        obj.set("spotInstanceType", om.valueToTree((Object)this.getSpotInstanceType()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface PrivateIpAddProperty
    extends JsiiSerializable {
        public Object getPrimary();

        public String getPrivateIpAddress();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _primary;
            @Nullable
            private String _privateIpAddress;

            public Builder withPrimary(@Nullable Boolean value) {
                this._primary = value;
                return this;
            }

            public Builder withPrimary(@Nullable Token value) {
                this._primary = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable String value) {
                this._privateIpAddress = value;
                return this;
            }

            public PrivateIpAddProperty build() {
                return new PrivateIpAddProperty(){
                    @Nullable
                    private final Object $primary;
                    @Nullable
                    private final String $privateIpAddress;
                    {
                        this.$primary = _primary;
                        this.$privateIpAddress = _privateIpAddress;
                    }

                    @Override
                    public Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("primary", om.valueToTree(this.getPrimary()));
                        obj.set("privateIpAddress", om.valueToTree((Object)this.getPrivateIpAddress()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface PlacementProperty
    extends JsiiSerializable {
        public String getAffinity();

        public String getAvailabilityZone();

        public String getGroupName();

        public String getHostId();

        public String getTenancy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _affinity;
            @Nullable
            private String _availabilityZone;
            @Nullable
            private String _groupName;
            @Nullable
            private String _hostId;
            @Nullable
            private String _tenancy;

            public Builder withAffinity(@Nullable String value) {
                this._affinity = value;
                return this;
            }

            public Builder withAvailabilityZone(@Nullable String value) {
                this._availabilityZone = value;
                return this;
            }

            public Builder withGroupName(@Nullable String value) {
                this._groupName = value;
                return this;
            }

            public Builder withHostId(@Nullable String value) {
                this._hostId = value;
                return this;
            }

            public Builder withTenancy(@Nullable String value) {
                this._tenancy = value;
                return this;
            }

            public PlacementProperty build() {
                return new PlacementProperty(){
                    @Nullable
                    private final String $affinity;
                    @Nullable
                    private final String $availabilityZone;
                    @Nullable
                    private final String $groupName;
                    @Nullable
                    private final String $hostId;
                    @Nullable
                    private final String $tenancy;
                    {
                        this.$affinity = _affinity;
                        this.$availabilityZone = _availabilityZone;
                        this.$groupName = _groupName;
                        this.$hostId = _hostId;
                        this.$tenancy = _tenancy;
                    }

                    @Override
                    public String getAffinity() {
                        return this.$affinity;
                    }

                    @Override
                    public String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public String getHostId() {
                        return this.$hostId;
                    }

                    @Override
                    public String getTenancy() {
                        return this.$tenancy;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("affinity", om.valueToTree((Object)this.getAffinity()));
                        obj.set("availabilityZone", om.valueToTree((Object)this.getAvailabilityZone()));
                        obj.set("groupName", om.valueToTree((Object)this.getGroupName()));
                        obj.set("hostId", om.valueToTree((Object)this.getHostId()));
                        obj.set("tenancy", om.valueToTree((Object)this.getTenancy()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public Object getDeleteOnTermination();

        public String getDescription();

        public Object getDeviceIndex();

        public List<String> getGroups();

        public Object getIpv6AddressCount();

        public Object getIpv6Addresses();

        public String getNetworkInterfaceId();

        public String getPrivateIpAddress();

        public Object getPrivateIpAddresses();

        public Object getSecondaryPrivateIpAddressCount();

        public String getSubnetId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _associatePublicIpAddress;
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private String _description;
            @Nullable
            private Object _deviceIndex;
            @Nullable
            private List<String> _groups;
            @Nullable
            private Object _ipv6AddressCount;
            @Nullable
            private Object _ipv6Addresses;
            @Nullable
            private String _networkInterfaceId;
            @Nullable
            private String _privateIpAddress;
            @Nullable
            private Object _privateIpAddresses;
            @Nullable
            private Object _secondaryPrivateIpAddressCount;
            @Nullable
            private String _subnetId;

            public Builder withAssociatePublicIpAddress(@Nullable Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withAssociatePublicIpAddress(@Nullable Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Token value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDescription(@Nullable String value) {
                this._description = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Number value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withDeviceIndex(@Nullable Token value) {
                this._deviceIndex = value;
                return this;
            }

            public Builder withGroups(@Nullable List<String> value) {
                this._groups = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Number value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6AddressCount(@Nullable Token value) {
                this._ipv6AddressCount = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable Token value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withIpv6Addresses(@Nullable List<Object> value) {
                this._ipv6Addresses = value;
                return this;
            }

            public Builder withNetworkInterfaceId(@Nullable String value) {
                this._networkInterfaceId = value;
                return this;
            }

            public Builder withPrivateIpAddress(@Nullable String value) {
                this._privateIpAddress = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable Token value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withPrivateIpAddresses(@Nullable List<Object> value) {
                this._privateIpAddresses = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSecondaryPrivateIpAddressCount(@Nullable Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }

            public Builder withSubnetId(@Nullable String value) {
                this._subnetId = value;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty(){
                    @Nullable
                    private final Object $associatePublicIpAddress;
                    @Nullable
                    private final Object $deleteOnTermination;
                    @Nullable
                    private final String $description;
                    @Nullable
                    private final Object $deviceIndex;
                    @Nullable
                    private final List<String> $groups;
                    @Nullable
                    private final Object $ipv6AddressCount;
                    @Nullable
                    private final Object $ipv6Addresses;
                    @Nullable
                    private final String $networkInterfaceId;
                    @Nullable
                    private final String $privateIpAddress;
                    @Nullable
                    private final Object $privateIpAddresses;
                    @Nullable
                    private final Object $secondaryPrivateIpAddressCount;
                    @Nullable
                    private final String $subnetId;
                    {
                        this.$associatePublicIpAddress = _associatePublicIpAddress;
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$description = _description;
                        this.$deviceIndex = _deviceIndex;
                        this.$groups = _groups;
                        this.$ipv6AddressCount = _ipv6AddressCount;
                        this.$ipv6Addresses = _ipv6Addresses;
                        this.$networkInterfaceId = _networkInterfaceId;
                        this.$privateIpAddress = _privateIpAddress;
                        this.$privateIpAddresses = _privateIpAddresses;
                        this.$secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                        this.$subnetId = _subnetId;
                    }

                    @Override
                    public Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public List<String> getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public String getSubnetId() {
                        return this.$subnetId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                        obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                        obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                        obj.set("groups", om.valueToTree(this.getGroups()));
                        obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                        obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                        obj.set("networkInterfaceId", om.valueToTree((Object)this.getNetworkInterfaceId()));
                        obj.set("privateIpAddress", om.valueToTree((Object)this.getPrivateIpAddress()));
                        obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                        obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                        obj.set("subnetId", om.valueToTree((Object)this.getSubnetId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface MonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _enabled;

            public Builder withEnabled(@Nullable Boolean value) {
                this._enabled = value;
                return this;
            }

            public Builder withEnabled(@Nullable Token value) {
                this._enabled = value;
                return this;
            }

            public MonitoringProperty build() {
                return new MonitoringProperty(){
                    @Nullable
                    private final Object $enabled;
                    {
                        this.$enabled = _enabled;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LicenseSpecificationProperty
    extends JsiiSerializable {
        public String getLicenseConfigurationArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _licenseConfigurationArn;

            public Builder withLicenseConfigurationArn(@Nullable String value) {
                this._licenseConfigurationArn = value;
                return this;
            }

            public LicenseSpecificationProperty build() {
                return new LicenseSpecificationProperty(){
                    @Nullable
                    private final String $licenseConfigurationArn;
                    {
                        this.$licenseConfigurationArn = _licenseConfigurationArn;
                    }

                    @Override
                    public String getLicenseConfigurationArn() {
                        return this.$licenseConfigurationArn;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("licenseConfigurationArn", om.valueToTree((Object)this.getLicenseConfigurationArn()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LaunchTemplateElasticInferenceAcceleratorProperty
    extends JsiiSerializable {
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _type;

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new LaunchTemplateElasticInferenceAcceleratorProperty(){
                    @Nullable
                    private final String $type;
                    {
                        this.$type = _type;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree((Object)this.getType()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface LaunchTemplateDataProperty
    extends JsiiSerializable {
        public Object getBlockDeviceMappings();

        public Object getCapacityReservationSpecification();

        public Object getCpuOptions();

        public Object getCreditSpecification();

        public Object getDisableApiTermination();

        public Object getEbsOptimized();

        public Object getElasticGpuSpecifications();

        public Object getElasticInferenceAccelerators();

        public Object getHibernationOptions();

        public Object getIamInstanceProfile();

        public String getImageId();

        public String getInstanceInitiatedShutdownBehavior();

        public Object getInstanceMarketOptions();

        public String getInstanceType();

        public String getKernelId();

        public String getKeyName();

        public Object getLicenseSpecifications();

        public Object getMonitoring();

        public Object getNetworkInterfaces();

        public Object getPlacement();

        public String getRamDiskId();

        public List<String> getSecurityGroupIds();

        public List<String> getSecurityGroups();

        public Object getTagSpecifications();

        public String getUserData();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _blockDeviceMappings;
            @Nullable
            private Object _capacityReservationSpecification;
            @Nullable
            private Object _cpuOptions;
            @Nullable
            private Object _creditSpecification;
            @Nullable
            private Object _disableApiTermination;
            @Nullable
            private Object _ebsOptimized;
            @Nullable
            private Object _elasticGpuSpecifications;
            @Nullable
            private Object _elasticInferenceAccelerators;
            @Nullable
            private Object _hibernationOptions;
            @Nullable
            private Object _iamInstanceProfile;
            @Nullable
            private String _imageId;
            @Nullable
            private String _instanceInitiatedShutdownBehavior;
            @Nullable
            private Object _instanceMarketOptions;
            @Nullable
            private String _instanceType;
            @Nullable
            private String _kernelId;
            @Nullable
            private String _keyName;
            @Nullable
            private Object _licenseSpecifications;
            @Nullable
            private Object _monitoring;
            @Nullable
            private Object _networkInterfaces;
            @Nullable
            private Object _placement;
            @Nullable
            private String _ramDiskId;
            @Nullable
            private List<String> _securityGroupIds;
            @Nullable
            private List<String> _securityGroups;
            @Nullable
            private Object _tagSpecifications;
            @Nullable
            private String _userData;

            public Builder withBlockDeviceMappings(@Nullable Token value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withBlockDeviceMappings(@Nullable List<Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }

            public Builder withCapacityReservationSpecification(@Nullable Token value) {
                this._capacityReservationSpecification = value;
                return this;
            }

            public Builder withCapacityReservationSpecification(@Nullable CapacityReservationSpecificationProperty value) {
                this._capacityReservationSpecification = value;
                return this;
            }

            public Builder withCpuOptions(@Nullable Token value) {
                this._cpuOptions = value;
                return this;
            }

            public Builder withCpuOptions(@Nullable CpuOptionsProperty value) {
                this._cpuOptions = value;
                return this;
            }

            public Builder withCreditSpecification(@Nullable Token value) {
                this._creditSpecification = value;
                return this;
            }

            public Builder withCreditSpecification(@Nullable CreditSpecificationProperty value) {
                this._creditSpecification = value;
                return this;
            }

            public Builder withDisableApiTermination(@Nullable Boolean value) {
                this._disableApiTermination = value;
                return this;
            }

            public Builder withDisableApiTermination(@Nullable Token value) {
                this._disableApiTermination = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Boolean value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withEbsOptimized(@Nullable Token value) {
                this._ebsOptimized = value;
                return this;
            }

            public Builder withElasticGpuSpecifications(@Nullable Token value) {
                this._elasticGpuSpecifications = value;
                return this;
            }

            public Builder withElasticGpuSpecifications(@Nullable List<Object> value) {
                this._elasticGpuSpecifications = value;
                return this;
            }

            public Builder withElasticInferenceAccelerators(@Nullable Token value) {
                this._elasticInferenceAccelerators = value;
                return this;
            }

            public Builder withElasticInferenceAccelerators(@Nullable List<Object> value) {
                this._elasticInferenceAccelerators = value;
                return this;
            }

            public Builder withHibernationOptions(@Nullable Token value) {
                this._hibernationOptions = value;
                return this;
            }

            public Builder withHibernationOptions(@Nullable HibernationOptionsProperty value) {
                this._hibernationOptions = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable Token value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withIamInstanceProfile(@Nullable IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }

            public Builder withImageId(@Nullable String value) {
                this._imageId = value;
                return this;
            }

            public Builder withInstanceInitiatedShutdownBehavior(@Nullable String value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }

            public Builder withInstanceMarketOptions(@Nullable Token value) {
                this._instanceMarketOptions = value;
                return this;
            }

            public Builder withInstanceMarketOptions(@Nullable InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
                return this;
            }

            public Builder withInstanceType(@Nullable String value) {
                this._instanceType = value;
                return this;
            }

            public Builder withKernelId(@Nullable String value) {
                this._kernelId = value;
                return this;
            }

            public Builder withKeyName(@Nullable String value) {
                this._keyName = value;
                return this;
            }

            public Builder withLicenseSpecifications(@Nullable Token value) {
                this._licenseSpecifications = value;
                return this;
            }

            public Builder withLicenseSpecifications(@Nullable List<Object> value) {
                this._licenseSpecifications = value;
                return this;
            }

            public Builder withMonitoring(@Nullable Token value) {
                this._monitoring = value;
                return this;
            }

            public Builder withMonitoring(@Nullable MonitoringProperty value) {
                this._monitoring = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable Token value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withNetworkInterfaces(@Nullable List<Object> value) {
                this._networkInterfaces = value;
                return this;
            }

            public Builder withPlacement(@Nullable Token value) {
                this._placement = value;
                return this;
            }

            public Builder withPlacement(@Nullable PlacementProperty value) {
                this._placement = value;
                return this;
            }

            public Builder withRamDiskId(@Nullable String value) {
                this._ramDiskId = value;
                return this;
            }

            public Builder withSecurityGroupIds(@Nullable List<String> value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSecurityGroups(@Nullable List<String> value) {
                this._securityGroups = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable Token value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withTagSpecifications(@Nullable List<Object> value) {
                this._tagSpecifications = value;
                return this;
            }

            public Builder withUserData(@Nullable String value) {
                this._userData = value;
                return this;
            }

            public LaunchTemplateDataProperty build() {
                return new LaunchTemplateDataProperty(){
                    @Nullable
                    private final Object $blockDeviceMappings;
                    @Nullable
                    private final Object $capacityReservationSpecification;
                    @Nullable
                    private final Object $cpuOptions;
                    @Nullable
                    private final Object $creditSpecification;
                    @Nullable
                    private final Object $disableApiTermination;
                    @Nullable
                    private final Object $ebsOptimized;
                    @Nullable
                    private final Object $elasticGpuSpecifications;
                    @Nullable
                    private final Object $elasticInferenceAccelerators;
                    @Nullable
                    private final Object $hibernationOptions;
                    @Nullable
                    private final Object $iamInstanceProfile;
                    @Nullable
                    private final String $imageId;
                    @Nullable
                    private final String $instanceInitiatedShutdownBehavior;
                    @Nullable
                    private final Object $instanceMarketOptions;
                    @Nullable
                    private final String $instanceType;
                    @Nullable
                    private final String $kernelId;
                    @Nullable
                    private final String $keyName;
                    @Nullable
                    private final Object $licenseSpecifications;
                    @Nullable
                    private final Object $monitoring;
                    @Nullable
                    private final Object $networkInterfaces;
                    @Nullable
                    private final Object $placement;
                    @Nullable
                    private final String $ramDiskId;
                    @Nullable
                    private final List<String> $securityGroupIds;
                    @Nullable
                    private final List<String> $securityGroups;
                    @Nullable
                    private final Object $tagSpecifications;
                    @Nullable
                    private final String $userData;
                    {
                        this.$blockDeviceMappings = _blockDeviceMappings;
                        this.$capacityReservationSpecification = _capacityReservationSpecification;
                        this.$cpuOptions = _cpuOptions;
                        this.$creditSpecification = _creditSpecification;
                        this.$disableApiTermination = _disableApiTermination;
                        this.$ebsOptimized = _ebsOptimized;
                        this.$elasticGpuSpecifications = _elasticGpuSpecifications;
                        this.$elasticInferenceAccelerators = _elasticInferenceAccelerators;
                        this.$hibernationOptions = _hibernationOptions;
                        this.$iamInstanceProfile = _iamInstanceProfile;
                        this.$imageId = _imageId;
                        this.$instanceInitiatedShutdownBehavior = _instanceInitiatedShutdownBehavior;
                        this.$instanceMarketOptions = _instanceMarketOptions;
                        this.$instanceType = _instanceType;
                        this.$kernelId = _kernelId;
                        this.$keyName = _keyName;
                        this.$licenseSpecifications = _licenseSpecifications;
                        this.$monitoring = _monitoring;
                        this.$networkInterfaces = _networkInterfaces;
                        this.$placement = _placement;
                        this.$ramDiskId = _ramDiskId;
                        this.$securityGroupIds = _securityGroupIds;
                        this.$securityGroups = _securityGroups;
                        this.$tagSpecifications = _tagSpecifications;
                        this.$userData = _userData;
                    }

                    @Override
                    public Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public Object getCapacityReservationSpecification() {
                        return this.$capacityReservationSpecification;
                    }

                    @Override
                    public Object getCpuOptions() {
                        return this.$cpuOptions;
                    }

                    @Override
                    public Object getCreditSpecification() {
                        return this.$creditSpecification;
                    }

                    @Override
                    public Object getDisableApiTermination() {
                        return this.$disableApiTermination;
                    }

                    @Override
                    public Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public Object getElasticGpuSpecifications() {
                        return this.$elasticGpuSpecifications;
                    }

                    @Override
                    public Object getElasticInferenceAccelerators() {
                        return this.$elasticInferenceAccelerators;
                    }

                    @Override
                    public Object getHibernationOptions() {
                        return this.$hibernationOptions;
                    }

                    @Override
                    public Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public String getInstanceInitiatedShutdownBehavior() {
                        return this.$instanceInitiatedShutdownBehavior;
                    }

                    @Override
                    public Object getInstanceMarketOptions() {
                        return this.$instanceMarketOptions;
                    }

                    @Override
                    public String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public Object getLicenseSpecifications() {
                        return this.$licenseSpecifications;
                    }

                    @Override
                    public Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public String getRamDiskId() {
                        return this.$ramDiskId;
                    }

                    @Override
                    public List<String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public List<String> getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public String getUserData() {
                        return this.$userData;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                        obj.set("capacityReservationSpecification", om.valueToTree(this.getCapacityReservationSpecification()));
                        obj.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
                        obj.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
                        obj.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
                        obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                        obj.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
                        obj.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
                        obj.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
                        obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                        obj.set("imageId", om.valueToTree((Object)this.getImageId()));
                        obj.set("instanceInitiatedShutdownBehavior", om.valueToTree((Object)this.getInstanceInitiatedShutdownBehavior()));
                        obj.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));
                        obj.set("instanceType", om.valueToTree((Object)this.getInstanceType()));
                        obj.set("kernelId", om.valueToTree((Object)this.getKernelId()));
                        obj.set("keyName", om.valueToTree((Object)this.getKeyName()));
                        obj.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
                        obj.set("monitoring", om.valueToTree(this.getMonitoring()));
                        obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                        obj.set("placement", om.valueToTree(this.getPlacement()));
                        obj.set("ramDiskId", om.valueToTree((Object)this.getRamDiskId()));
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                        obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                        obj.set("userData", om.valueToTree((Object)this.getUserData()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface Ipv6AddProperty
    extends JsiiSerializable {
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _ipv6Address;

            public Builder withIpv6Address(@Nullable String value) {
                this._ipv6Address = value;
                return this;
            }

            public Ipv6AddProperty build() {
                return new Ipv6AddProperty(){
                    @Nullable
                    private final String $ipv6Address;
                    {
                        this.$ipv6Address = _ipv6Address;
                    }

                    @Override
                    public String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("ipv6Address", om.valueToTree((Object)this.getIpv6Address()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface InstanceMarketOptionsProperty
    extends JsiiSerializable {
        public String getMarketType();

        public Object getSpotOptions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _marketType;
            @Nullable
            private Object _spotOptions;

            public Builder withMarketType(@Nullable String value) {
                this._marketType = value;
                return this;
            }

            public Builder withSpotOptions(@Nullable Token value) {
                this._spotOptions = value;
                return this;
            }

            public Builder withSpotOptions(@Nullable SpotOptionsProperty value) {
                this._spotOptions = value;
                return this;
            }

            public InstanceMarketOptionsProperty build() {
                return new InstanceMarketOptionsProperty(){
                    @Nullable
                    private final String $marketType;
                    @Nullable
                    private final Object $spotOptions;
                    {
                        this.$marketType = _marketType;
                        this.$spotOptions = _spotOptions;
                    }

                    @Override
                    public String getMarketType() {
                        return this.$marketType;
                    }

                    @Override
                    public Object getSpotOptions() {
                        return this.$spotOptions;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("marketType", om.valueToTree((Object)this.getMarketType()));
                        obj.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface IamInstanceProfileProperty
    extends JsiiSerializable {
        public String getArn();

        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _arn;
            @Nullable
            private String _name;

            public Builder withArn(@Nullable String value) {
                this._arn = value;
                return this;
            }

            public Builder withName(@Nullable String value) {
                this._name = value;
                return this;
            }

            public IamInstanceProfileProperty build() {
                return new IamInstanceProfileProperty(){
                    @Nullable
                    private final String $arn;
                    @Nullable
                    private final String $name;
                    {
                        this.$arn = _arn;
                        this.$name = _name;
                    }

                    @Override
                    public String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public String getName() {
                        return this.$name;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("arn", om.valueToTree((Object)this.getArn()));
                        obj.set("name", om.valueToTree((Object)this.getName()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface HibernationOptionsProperty
    extends JsiiSerializable {
        public Object getConfigured();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _configured;

            public Builder withConfigured(@Nullable Boolean value) {
                this._configured = value;
                return this;
            }

            public Builder withConfigured(@Nullable Token value) {
                this._configured = value;
                return this;
            }

            public HibernationOptionsProperty build() {
                return new HibernationOptionsProperty(){
                    @Nullable
                    private final Object $configured;
                    {
                        this.$configured = _configured;
                    }

                    @Override
                    public Object getConfigured() {
                        return this.$configured;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("configured", om.valueToTree(this.getConfigured()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _type;

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty(){
                    @Nullable
                    private final String $type;
                    {
                        this.$type = _type;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree((Object)this.getType()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface EbsProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public Object getEncrypted();

        public Object getIops();

        public String getKmsKeyId();

        public String getSnapshotId();

        public Object getVolumeSize();

        public String getVolumeType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _deleteOnTermination;
            @Nullable
            private Object _encrypted;
            @Nullable
            private Object _iops;
            @Nullable
            private String _kmsKeyId;
            @Nullable
            private String _snapshotId;
            @Nullable
            private Object _volumeSize;
            @Nullable
            private String _volumeType;

            public Builder withDeleteOnTermination(@Nullable Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withDeleteOnTermination(@Nullable Token value) {
                this._deleteOnTermination = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Boolean value) {
                this._encrypted = value;
                return this;
            }

            public Builder withEncrypted(@Nullable Token value) {
                this._encrypted = value;
                return this;
            }

            public Builder withIops(@Nullable Number value) {
                this._iops = value;
                return this;
            }

            public Builder withIops(@Nullable Token value) {
                this._iops = value;
                return this;
            }

            public Builder withKmsKeyId(@Nullable String value) {
                this._kmsKeyId = value;
                return this;
            }

            public Builder withSnapshotId(@Nullable String value) {
                this._snapshotId = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Number value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeSize(@Nullable Token value) {
                this._volumeSize = value;
                return this;
            }

            public Builder withVolumeType(@Nullable String value) {
                this._volumeType = value;
                return this;
            }

            public EbsProperty build() {
                return new EbsProperty(){
                    @Nullable
                    private final Object $deleteOnTermination;
                    @Nullable
                    private final Object $encrypted;
                    @Nullable
                    private final Object $iops;
                    @Nullable
                    private final String $kmsKeyId;
                    @Nullable
                    private final String $snapshotId;
                    @Nullable
                    private final Object $volumeSize;
                    @Nullable
                    private final String $volumeType;
                    {
                        this.$deleteOnTermination = _deleteOnTermination;
                        this.$encrypted = _encrypted;
                        this.$iops = _iops;
                        this.$kmsKeyId = _kmsKeyId;
                        this.$snapshotId = _snapshotId;
                        this.$volumeSize = _volumeSize;
                        this.$volumeType = _volumeType;
                    }

                    @Override
                    public Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public String getKmsKeyId() {
                        return this.$kmsKeyId;
                    }

                    @Override
                    public String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public String getVolumeType() {
                        return this.$volumeType;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                        obj.set("iops", om.valueToTree(this.getIops()));
                        obj.set("kmsKeyId", om.valueToTree((Object)this.getKmsKeyId()));
                        obj.set("snapshotId", om.valueToTree((Object)this.getSnapshotId()));
                        obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                        obj.set("volumeType", om.valueToTree((Object)this.getVolumeType()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        public String getCpuCredits();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _cpuCredits;

            public Builder withCpuCredits(@Nullable String value) {
                this._cpuCredits = value;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty(){
                    @Nullable
                    private final String $cpuCredits;
                    {
                        this.$cpuCredits = _cpuCredits;
                    }

                    @Override
                    public String getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("cpuCredits", om.valueToTree((Object)this.getCpuCredits()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CpuOptionsProperty
    extends JsiiSerializable {
        public Object getCoreCount();

        public Object getThreadsPerCore();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _coreCount;
            @Nullable
            private Object _threadsPerCore;

            public Builder withCoreCount(@Nullable Number value) {
                this._coreCount = value;
                return this;
            }

            public Builder withCoreCount(@Nullable Token value) {
                this._coreCount = value;
                return this;
            }

            public Builder withThreadsPerCore(@Nullable Number value) {
                this._threadsPerCore = value;
                return this;
            }

            public Builder withThreadsPerCore(@Nullable Token value) {
                this._threadsPerCore = value;
                return this;
            }

            public CpuOptionsProperty build() {
                return new CpuOptionsProperty(){
                    @Nullable
                    private final Object $coreCount;
                    @Nullable
                    private final Object $threadsPerCore;
                    {
                        this.$coreCount = _coreCount;
                        this.$threadsPerCore = _threadsPerCore;
                    }

                    @Override
                    public Object getCoreCount() {
                        return this.$coreCount;
                    }

                    @Override
                    public Object getThreadsPerCore() {
                        return this.$threadsPerCore;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("coreCount", om.valueToTree(this.getCoreCount()));
                        obj.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CapacityReservationTargetProperty
    extends JsiiSerializable {
        public String getCapacityReservationId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _capacityReservationId;

            public Builder withCapacityReservationId(@Nullable String value) {
                this._capacityReservationId = value;
                return this;
            }

            public CapacityReservationTargetProperty build() {
                return new CapacityReservationTargetProperty(){
                    @Nullable
                    private final String $capacityReservationId;
                    {
                        this.$capacityReservationId = _capacityReservationId;
                    }

                    @Override
                    public String getCapacityReservationId() {
                        return this.$capacityReservationId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("capacityReservationId", om.valueToTree((Object)this.getCapacityReservationId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CapacityReservationSpecificationProperty
    extends JsiiSerializable {
        public String getCapacityReservationPreference();

        public Object getCapacityReservationTarget();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _capacityReservationPreference;
            @Nullable
            private Object _capacityReservationTarget;

            public Builder withCapacityReservationPreference(@Nullable String value) {
                this._capacityReservationPreference = value;
                return this;
            }

            public Builder withCapacityReservationTarget(@Nullable Token value) {
                this._capacityReservationTarget = value;
                return this;
            }

            public Builder withCapacityReservationTarget(@Nullable CapacityReservationTargetProperty value) {
                this._capacityReservationTarget = value;
                return this;
            }

            public CapacityReservationSpecificationProperty build() {
                return new CapacityReservationSpecificationProperty(){
                    @Nullable
                    private final String $capacityReservationPreference;
                    @Nullable
                    private final Object $capacityReservationTarget;
                    {
                        this.$capacityReservationPreference = _capacityReservationPreference;
                        this.$capacityReservationTarget = _capacityReservationTarget;
                    }

                    @Override
                    public String getCapacityReservationPreference() {
                        return this.$capacityReservationPreference;
                    }

                    @Override
                    public Object getCapacityReservationTarget() {
                        return this.$capacityReservationTarget;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("capacityReservationPreference", om.valueToTree((Object)this.getCapacityReservationPreference()));
                        obj.set("capacityReservationTarget", om.valueToTree(this.getCapacityReservationTarget()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public String getDeviceName();

        public Object getEbs();

        public String getNoDevice();

        public String getVirtualName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _deviceName;
            @Nullable
            private Object _ebs;
            @Nullable
            private String _noDevice;
            @Nullable
            private String _virtualName;

            public Builder withDeviceName(@Nullable String value) {
                this._deviceName = value;
                return this;
            }

            public Builder withEbs(@Nullable Token value) {
                this._ebs = value;
                return this;
            }

            public Builder withEbs(@Nullable EbsProperty value) {
                this._ebs = value;
                return this;
            }

            public Builder withNoDevice(@Nullable String value) {
                this._noDevice = value;
                return this;
            }

            public Builder withVirtualName(@Nullable String value) {
                this._virtualName = value;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty(){
                    @Nullable
                    private final String $deviceName;
                    @Nullable
                    private final Object $ebs;
                    @Nullable
                    private final String $noDevice;
                    @Nullable
                    private final String $virtualName;
                    {
                        this.$deviceName = _deviceName;
                        this.$ebs = _ebs;
                        this.$noDevice = _noDevice;
                        this.$virtualName = _virtualName;
                    }

                    @Override
                    public String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public String getVirtualName() {
                        return this.$virtualName;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("deviceName", om.valueToTree((Object)this.getDeviceName()));
                        obj.set("ebs", om.valueToTree(this.getEbs()));
                        obj.set("noDevice", om.valueToTree((Object)this.getNoDevice()));
                        obj.set("virtualName", om.valueToTree((Object)this.getVirtualName()));
                        return obj;
                    }
                };
            }
        }
    }
}

