/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService;
import software.amazon.awscdk.services.ec2.IVpcNetwork;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface GatewayVpcEndpointProps
extends JsiiSerializable,
GatewayVpcEndpointOptions {
    public IVpcNetwork getVpc();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpcNetwork _vpc;
        private IGatewayVpcEndpointService _service;
        @Nullable
        private List<SubnetSelection> _subnets;

        public Builder withVpc(IVpcNetwork value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withService(IGatewayVpcEndpointService value) {
            this._service = Objects.requireNonNull(value, "service is required");
            return this;
        }

        public Builder withSubnets(@Nullable List<SubnetSelection> value) {
            this._subnets = value;
            return this;
        }

        public GatewayVpcEndpointProps build() {
            return new GatewayVpcEndpointProps(){
                private final IVpcNetwork $vpc;
                private final IGatewayVpcEndpointService $service;
                @Nullable
                private final List<SubnetSelection> $subnets;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$service = Objects.requireNonNull(_service, "service is required");
                    this.$subnets = _subnets;
                }

                @Override
                public IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public IGatewayVpcEndpointService getService() {
                    return this.$service;
                }

                @Override
                public List<SubnetSelection> getSubnets() {
                    return this.$subnets;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    obj.set("service", om.valueToTree((Object)this.getService()));
                    obj.set("subnets", om.valueToTree(this.getSubnets()));
                    return obj;
                }
            };
        }
    }
}

