package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:15:07.417Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate extends software.amazon.awscdk.CfnResource {
    protected CfnLaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnLaunchTemplate(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnLaunchTemplate(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     */
    public java.lang.String getLaunchTemplateDefaultVersionNumber() {
        return this.jsiiGet("launchTemplateDefaultVersionNumber", java.lang.String.class);
    }

    public java.lang.String getLaunchTemplateId() {
        return this.jsiiGet("launchTemplateId", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getLaunchTemplateLatestVersionNumber() {
        return this.jsiiGet("launchTemplateLatestVersionNumber", java.lang.String.class);
    }

    public software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        java.lang.String getDeviceName();
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        java.lang.Object getEbs();
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        java.lang.String getNoDevice();
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        java.lang.String getVirtualName();

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.String _noDevice;
            @javax.annotation.Nullable
            private java.lang.String _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            public Builder withDeviceName(@javax.annotation.Nullable final java.lang.String value) {
                this._deviceName = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            public Builder withNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $deviceName = _deviceName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private final java.lang.String $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private final java.lang.String $virtualName = _virtualName;

                    @Override
                    public java.lang.String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public java.lang.String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public java.lang.String getVirtualName() {
                        return this.$virtualName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deviceName", om.valueToTree(this.getDeviceName()));
                        obj.set("ebs", om.valueToTree(this.getEbs()));
                        obj.set("noDevice", om.valueToTree(this.getNoDevice()));
                        obj.set("virtualName", om.valueToTree(this.getVirtualName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     */
    public static interface CapacityReservationSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         */
        java.lang.String getCapacityReservationPreference();
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         */
        java.lang.Object getCapacityReservationTarget();

        /**
         * @return a {@link Builder} of {@link CapacityReservationSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CapacityReservationSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _capacityReservationPreference;
            @javax.annotation.Nullable
            private java.lang.Object _capacityReservationTarget;

            /**
             * Sets the value of CapacityReservationPreference
             * @param value `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
             * @return {@code this}
             */
            public Builder withCapacityReservationPreference(@javax.annotation.Nullable final java.lang.String value) {
                this._capacityReservationPreference = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationTarget
             * @param value `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            public Builder withCapacityReservationTarget(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._capacityReservationTarget = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationTarget
             * @param value `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * @return {@code this}
             */
            public Builder withCapacityReservationTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty value) {
                this._capacityReservationTarget = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CapacityReservationSpecificationProperty build() {
                return new CapacityReservationSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $capacityReservationPreference = _capacityReservationPreference;
                    @javax.annotation.Nullable
                    private final java.lang.Object $capacityReservationTarget = _capacityReservationTarget;

                    @Override
                    public java.lang.String getCapacityReservationPreference() {
                        return this.$capacityReservationPreference;
                    }

                    @Override
                    public java.lang.Object getCapacityReservationTarget() {
                        return this.$capacityReservationTarget;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                        obj.set("capacityReservationTarget", om.valueToTree(this.getCapacityReservationTarget()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCapacityReservationPreference() {
                return this.jsiiGet("capacityReservationPreference", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCapacityReservationTarget() {
                return this.jsiiGet("capacityReservationTarget", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     */
    public static interface CapacityReservationTargetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         */
        java.lang.String getCapacityReservationId();

        /**
         * @return a {@link Builder} of {@link CapacityReservationTargetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CapacityReservationTargetProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _capacityReservationId;

            /**
             * Sets the value of CapacityReservationId
             * @param value `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
             * @return {@code this}
             */
            public Builder withCapacityReservationId(@javax.annotation.Nullable final java.lang.String value) {
                this._capacityReservationId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CapacityReservationTargetProperty build() {
                return new CapacityReservationTargetProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $capacityReservationId = _capacityReservationId;

                    @Override
                    public java.lang.String getCapacityReservationId() {
                        return this.$capacityReservationId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("capacityReservationId", om.valueToTree(this.getCapacityReservationId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCapacityReservationId() {
                return this.jsiiGet("capacityReservationId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     */
    public static interface CpuOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         */
        java.lang.Object getCoreCount();
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         */
        java.lang.Object getThreadsPerCore();

        /**
         * @return a {@link Builder} of {@link CpuOptionsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CpuOptionsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _coreCount;
            @javax.annotation.Nullable
            private java.lang.Object _threadsPerCore;

            /**
             * Sets the value of CoreCount
             * @param value `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * @return {@code this}
             */
            public Builder withCoreCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._coreCount = value;
                return this;
            }
            /**
             * Sets the value of CoreCount
             * @param value `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * @return {@code this}
             */
            public Builder withCoreCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._coreCount = value;
                return this;
            }
            /**
             * Sets the value of ThreadsPerCore
             * @param value `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * @return {@code this}
             */
            public Builder withThreadsPerCore(@javax.annotation.Nullable final java.lang.Number value) {
                this._threadsPerCore = value;
                return this;
            }
            /**
             * Sets the value of ThreadsPerCore
             * @param value `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * @return {@code this}
             */
            public Builder withThreadsPerCore(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._threadsPerCore = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CpuOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CpuOptionsProperty build() {
                return new CpuOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $coreCount = _coreCount;
                    @javax.annotation.Nullable
                    private final java.lang.Object $threadsPerCore = _threadsPerCore;

                    @Override
                    public java.lang.Object getCoreCount() {
                        return this.$coreCount;
                    }

                    @Override
                    public java.lang.Object getThreadsPerCore() {
                        return this.$threadsPerCore;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("coreCount", om.valueToTree(this.getCoreCount()));
                        obj.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCoreCount() {
                return this.jsiiGet("coreCount", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getThreadsPerCore() {
                return this.jsiiGet("threadsPerCore", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        java.lang.String getCpuCredits();

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param value `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
             * @return {@code this}
             */
            public Builder withCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this._cpuCredits = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $cpuCredits = _cpuCredits;

                    @Override
                    public java.lang.String getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        java.lang.Object getEncrypted();
        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        java.lang.Object getIops();
        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        java.lang.String getKmsKeyId();
        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        java.lang.String getSnapshotId();
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        java.lang.Object getVolumeSize();
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        java.lang.String getVolumeType();

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Object _iops;
            @javax.annotation.Nullable
            private java.lang.String _kmsKeyId;
            @javax.annotation.Nullable
            private java.lang.String _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Object _volumeSize;
            @javax.annotation.Nullable
            private java.lang.String _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnLaunchTemplate.EbsProperty.Iops`.
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnLaunchTemplate.EbsProperty.Iops`.
             * @return {@code this}
             */
            public Builder withIops(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of KmsKeyId
             * @param value `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
             * @return {@code this}
             */
            public Builder withKmsKeyId(@javax.annotation.Nullable final java.lang.String value) {
                this._kmsKeyId = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value `CfnLaunchTemplate.EbsProperty.SnapshotId`.
             * @return {@code this}
             */
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            public Builder withVolumeSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value `CfnLaunchTemplate.EbsProperty.VolumeType`.
             * @return {@code this}
             */
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EbsProperty build() {
                return new EbsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Object $iops = _iops;
                    @javax.annotation.Nullable
                    private final java.lang.String $kmsKeyId = _kmsKeyId;
                    @javax.annotation.Nullable
                    private final java.lang.String $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private final java.lang.String $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public java.lang.Object getIops() {
                        return this.$iops;
                    }

                    @Override
                    public java.lang.String getKmsKeyId() {
                        return this.$kmsKeyId;
                    }

                    @Override
                    public java.lang.String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public java.lang.Object getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public java.lang.String getVolumeType() {
                        return this.$volumeType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                        obj.set("iops", om.valueToTree(this.getIops()));
                        obj.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                        obj.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                        obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                        obj.set("volumeType", om.valueToTree(this.getVolumeType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.Encrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.Iops`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIops() {
                return this.jsiiGet("iops", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.KmsKeyId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKmsKeyId() {
                return this.jsiiGet("kmsKeyId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.SnapshotId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.VolumeSize`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.EbsProperty.VolumeType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _type;

            /**
             * Sets the value of Type
             * @param value `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     */
    public static interface HibernationOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         */
        java.lang.Object getConfigured();

        /**
         * @return a {@link Builder} of {@link HibernationOptionsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link HibernationOptionsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _configured;

            /**
             * Sets the value of Configured
             * @param value `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            public Builder withConfigured(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._configured = value;
                return this;
            }
            /**
             * Sets the value of Configured
             * @param value `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * @return {@code this}
             */
            public Builder withConfigured(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._configured = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HibernationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public HibernationOptionsProperty build() {
                return new HibernationOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $configured = _configured;

                    @Override
                    public java.lang.Object getConfigured() {
                        return this.$configured;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("configured", om.valueToTree(this.getConfigured()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getConfigured() {
                return this.jsiiGet("configured", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    public static interface IamInstanceProfileProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        java.lang.String getArn();
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _arn;
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Arn
             * @param value `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
             * @return {@code this}
             */
            public Builder withArn(@javax.annotation.Nullable final java.lang.String value) {
                this._arn = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IamInstanceProfileProperty build() {
                return new IamInstanceProfileProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $arn = _arn;
                    @javax.annotation.Nullable
                    private final java.lang.String $name = _name;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("arn", om.valueToTree(this.getArn()));
                        obj.set("name", om.valueToTree(this.getName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    public static interface InstanceMarketOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        java.lang.String getMarketType();
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        java.lang.Object getSpotOptions();

        /**
         * @return a {@link Builder} of {@link InstanceMarketOptionsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceMarketOptionsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _marketType;
            @javax.annotation.Nullable
            private java.lang.Object _spotOptions;

            /**
             * Sets the value of MarketType
             * @param value `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
             * @return {@code this}
             */
            public Builder withMarketType(@javax.annotation.Nullable final java.lang.String value) {
                this._marketType = value;
                return this;
            }
            /**
             * Sets the value of SpotOptions
             * @param value `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            public Builder withSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._spotOptions = value;
                return this;
            }
            /**
             * Sets the value of SpotOptions
             * @param value `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * @return {@code this}
             */
            public Builder withSpotOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty value) {
                this._spotOptions = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceMarketOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InstanceMarketOptionsProperty build() {
                return new InstanceMarketOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $marketType = _marketType;
                    @javax.annotation.Nullable
                    private final java.lang.Object $spotOptions = _spotOptions;

                    @Override
                    public java.lang.String getMarketType() {
                        return this.$marketType;
                    }

                    @Override
                    public java.lang.Object getSpotOptions() {
                        return this.$spotOptions;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("marketType", om.valueToTree(this.getMarketType()));
                        obj.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMarketType() {
                return this.jsiiGet("marketType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSpotOptions() {
                return this.jsiiGet("spotOptions", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    public static interface Ipv6AddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link Ipv6AddProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link Ipv6AddProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
             * @return {@code this}
             */
            public Builder withIpv6Address(@javax.annotation.Nullable final java.lang.String value) {
                this._ipv6Address = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ipv6AddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public Ipv6AddProperty build() {
                return new Ipv6AddProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $ipv6Address = _ipv6Address;

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.Ipv6AddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    public static interface LaunchTemplateDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        java.lang.Object getBlockDeviceMappings();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         */
        java.lang.Object getCapacityReservationSpecification();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         */
        java.lang.Object getCpuOptions();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        java.lang.Object getCreditSpecification();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        java.lang.Object getDisableApiTermination();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        java.lang.Object getEbsOptimized();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        java.lang.Object getElasticGpuSpecifications();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         */
        java.lang.Object getElasticInferenceAccelerators();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         */
        java.lang.Object getHibernationOptions();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        java.lang.Object getIamInstanceProfile();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        java.lang.String getImageId();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        java.lang.String getInstanceInitiatedShutdownBehavior();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        java.lang.Object getInstanceMarketOptions();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        java.lang.String getInstanceType();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        java.lang.String getKernelId();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        java.lang.String getKeyName();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         */
        java.lang.Object getLicenseSpecifications();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        java.lang.Object getMonitoring();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        java.lang.Object getNetworkInterfaces();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        java.lang.Object getPlacement();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        java.lang.String getRamDiskId();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        java.util.List<java.lang.String> getSecurityGroupIds();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        java.util.List<java.lang.String> getSecurityGroups();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        java.lang.Object getTagSpecifications();
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        java.lang.String getUserData();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateDataProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateDataProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _blockDeviceMappings;
            @javax.annotation.Nullable
            private java.lang.Object _capacityReservationSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _cpuOptions;
            @javax.annotation.Nullable
            private java.lang.Object _creditSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _disableApiTermination;
            @javax.annotation.Nullable
            private java.lang.Object _ebsOptimized;
            @javax.annotation.Nullable
            private java.lang.Object _elasticGpuSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _elasticInferenceAccelerators;
            @javax.annotation.Nullable
            private java.lang.Object _hibernationOptions;
            @javax.annotation.Nullable
            private java.lang.Object _iamInstanceProfile;
            @javax.annotation.Nullable
            private java.lang.String _imageId;
            @javax.annotation.Nullable
            private java.lang.String _instanceInitiatedShutdownBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _instanceMarketOptions;
            @javax.annotation.Nullable
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.String _kernelId;
            @javax.annotation.Nullable
            private java.lang.String _keyName;
            @javax.annotation.Nullable
            private java.lang.Object _licenseSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _monitoring;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaces;
            @javax.annotation.Nullable
            private java.lang.Object _placement;
            @javax.annotation.Nullable
            private java.lang.String _ramDiskId;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _securityGroupIds;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _securityGroups;
            @javax.annotation.Nullable
            private java.lang.Object _tagSpecifications;
            @javax.annotation.Nullable
            private java.lang.String _userData;

            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            public Builder withCapacityReservationSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._capacityReservationSpecification = value;
                return this;
            }
            /**
             * Sets the value of CapacityReservationSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * @return {@code this}
             */
            public Builder withCapacityReservationSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty value) {
                this._capacityReservationSpecification = value;
                return this;
            }
            /**
             * Sets the value of CpuOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            public Builder withCpuOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cpuOptions = value;
                return this;
            }
            /**
             * Sets the value of CpuOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * @return {@code this}
             */
            public Builder withCpuOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty value) {
                this._cpuOptions = value;
                return this;
            }
            /**
             * Sets the value of CreditSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            public Builder withCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._creditSpecification = value;
                return this;
            }
            /**
             * Sets the value of CreditSpecification
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * @return {@code this}
             */
            public Builder withCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty value) {
                this._creditSpecification = value;
                return this;
            }
            /**
             * Sets the value of DisableApiTermination
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            public Builder withDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._disableApiTermination = value;
                return this;
            }
            /**
             * Sets the value of DisableApiTermination
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * @return {@code this}
             */
            public Builder withDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._disableApiTermination = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * @return {@code this}
             */
            public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of ElasticGpuSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            public Builder withElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * Sets the value of ElasticGpuSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * @return {@code this}
             */
            public Builder withElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elasticGpuSpecifications = value;
                return this;
            }
            /**
             * Sets the value of ElasticInferenceAccelerators
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            public Builder withElasticInferenceAccelerators(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._elasticInferenceAccelerators = value;
                return this;
            }
            /**
             * Sets the value of ElasticInferenceAccelerators
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * @return {@code this}
             */
            public Builder withElasticInferenceAccelerators(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elasticInferenceAccelerators = value;
                return this;
            }
            /**
             * Sets the value of HibernationOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            public Builder withHibernationOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._hibernationOptions = value;
                return this;
            }
            /**
             * Sets the value of HibernationOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * @return {@code this}
             */
            public Builder withHibernationOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty value) {
                this._hibernationOptions = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of ImageId
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
             * @return {@code this}
             */
            public Builder withImageId(@javax.annotation.Nullable final java.lang.String value) {
                this._imageId = value;
                return this;
            }
            /**
             * Sets the value of InstanceInitiatedShutdownBehavior
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
             * @return {@code this}
             */
            public Builder withInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInitiatedShutdownBehavior = value;
                return this;
            }
            /**
             * Sets the value of InstanceMarketOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            public Builder withInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._instanceMarketOptions = value;
                return this;
            }
            /**
             * Sets the value of InstanceMarketOptions
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * @return {@code this}
             */
            public Builder withInstanceMarketOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty value) {
                this._instanceMarketOptions = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
             * @return {@code this}
             */
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
             * @return {@code this}
             */
            public Builder withKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
             * @return {@code this}
             */
            public Builder withKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of LicenseSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            public Builder withLicenseSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._licenseSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LicenseSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * @return {@code this}
             */
            public Builder withLicenseSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._licenseSpecifications = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * @return {@code this}
             */
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * @return {@code this}
             */
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of RamDiskId
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
             * @return {@code this}
             */
            public Builder withRamDiskId(@javax.annotation.Nullable final java.lang.String value) {
                this._ramDiskId = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroupIds
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._securityGroupIds = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
             * @return {@code this}
             */
            public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * @return {@code this}
             */
            public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
             * @return {@code this}
             */
            public Builder withUserData(@javax.annotation.Nullable final java.lang.String value) {
                this._userData = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateDataProperty build() {
                return new LaunchTemplateDataProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockDeviceMappings = _blockDeviceMappings;
                    @javax.annotation.Nullable
                    private final java.lang.Object $capacityReservationSpecification = _capacityReservationSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $cpuOptions = _cpuOptions;
                    @javax.annotation.Nullable
                    private final java.lang.Object $creditSpecification = _creditSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $disableApiTermination = _disableApiTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebsOptimized = _ebsOptimized;
                    @javax.annotation.Nullable
                    private final java.lang.Object $elasticGpuSpecifications = _elasticGpuSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.Object $elasticInferenceAccelerators = _elasticInferenceAccelerators;
                    @javax.annotation.Nullable
                    private final java.lang.Object $hibernationOptions = _hibernationOptions;
                    @javax.annotation.Nullable
                    private final java.lang.Object $iamInstanceProfile = _iamInstanceProfile;
                    @javax.annotation.Nullable
                    private final java.lang.String $imageId = _imageId;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInitiatedShutdownBehavior = _instanceInitiatedShutdownBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.Object $instanceMarketOptions = _instanceMarketOptions;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private final java.lang.String $kernelId = _kernelId;
                    @javax.annotation.Nullable
                    private final java.lang.String $keyName = _keyName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $licenseSpecifications = _licenseSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.Object $monitoring = _monitoring;
                    @javax.annotation.Nullable
                    private final java.lang.Object $networkInterfaces = _networkInterfaces;
                    @javax.annotation.Nullable
                    private final java.lang.Object $placement = _placement;
                    @javax.annotation.Nullable
                    private final java.lang.String $ramDiskId = _ramDiskId;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $securityGroupIds = _securityGroupIds;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $securityGroups = _securityGroups;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagSpecifications = _tagSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.String $userData = _userData;

                    @Override
                    public java.lang.Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public java.lang.Object getCapacityReservationSpecification() {
                        return this.$capacityReservationSpecification;
                    }

                    @Override
                    public java.lang.Object getCpuOptions() {
                        return this.$cpuOptions;
                    }

                    @Override
                    public java.lang.Object getCreditSpecification() {
                        return this.$creditSpecification;
                    }

                    @Override
                    public java.lang.Object getDisableApiTermination() {
                        return this.$disableApiTermination;
                    }

                    @Override
                    public java.lang.Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public java.lang.Object getElasticGpuSpecifications() {
                        return this.$elasticGpuSpecifications;
                    }

                    @Override
                    public java.lang.Object getElasticInferenceAccelerators() {
                        return this.$elasticInferenceAccelerators;
                    }

                    @Override
                    public java.lang.Object getHibernationOptions() {
                        return this.$hibernationOptions;
                    }

                    @Override
                    public java.lang.Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public java.lang.String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public java.lang.String getInstanceInitiatedShutdownBehavior() {
                        return this.$instanceInitiatedShutdownBehavior;
                    }

                    @Override
                    public java.lang.Object getInstanceMarketOptions() {
                        return this.$instanceMarketOptions;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public java.lang.String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public java.lang.Object getLicenseSpecifications() {
                        return this.$licenseSpecifications;
                    }

                    @Override
                    public java.lang.Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public java.lang.Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public java.lang.String getRamDiskId() {
                        return this.$ramDiskId;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public java.util.List<java.lang.String> getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public java.lang.Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public java.lang.String getUserData() {
                        return this.$userData;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                        obj.set("capacityReservationSpecification", om.valueToTree(this.getCapacityReservationSpecification()));
                        obj.set("cpuOptions", om.valueToTree(this.getCpuOptions()));
                        obj.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
                        obj.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
                        obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                        obj.set("elasticGpuSpecifications", om.valueToTree(this.getElasticGpuSpecifications()));
                        obj.set("elasticInferenceAccelerators", om.valueToTree(this.getElasticInferenceAccelerators()));
                        obj.set("hibernationOptions", om.valueToTree(this.getHibernationOptions()));
                        obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                        obj.set("imageId", om.valueToTree(this.getImageId()));
                        obj.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
                        obj.set("instanceMarketOptions", om.valueToTree(this.getInstanceMarketOptions()));
                        obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        obj.set("kernelId", om.valueToTree(this.getKernelId()));
                        obj.set("keyName", om.valueToTree(this.getKeyName()));
                        obj.set("licenseSpecifications", om.valueToTree(this.getLicenseSpecifications()));
                        obj.set("monitoring", om.valueToTree(this.getMonitoring()));
                        obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                        obj.set("placement", om.valueToTree(this.getPlacement()));
                        obj.set("ramDiskId", om.valueToTree(this.getRamDiskId()));
                        obj.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                        obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                        obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                        obj.set("userData", om.valueToTree(this.getUserData()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCapacityReservationSpecification() {
                return this.jsiiGet("capacityReservationSpecification", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCpuOptions() {
                return this.jsiiGet("cpuOptions", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCreditSpecification() {
                return this.jsiiGet("creditSpecification", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDisableApiTermination() {
                return this.jsiiGet("disableApiTermination", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getElasticGpuSpecifications() {
                return this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getElasticInferenceAccelerators() {
                return this.jsiiGet("elasticInferenceAccelerators", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHibernationOptions() {
                return this.jsiiGet("hibernationOptions", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getImageId() {
                return this.jsiiGet("imageId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceInitiatedShutdownBehavior() {
                return this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInstanceMarketOptions() {
                return this.jsiiGet("instanceMarketOptions", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKernelId() {
                return this.jsiiGet("kernelId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKeyName() {
                return this.jsiiGet("keyName", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLicenseSpecifications() {
                return this.jsiiGet("licenseSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRamDiskId() {
                return this.jsiiGet("ramDiskId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.util.List.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.util.List.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getUserData() {
                return this.jsiiGet("userData", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     */
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         */
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateElasticInferenceAcceleratorProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _type;

            /**
             * Sets the value of Type
             * @param value `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new LaunchTemplateElasticInferenceAcceleratorProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     */
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         */
        java.lang.String getLicenseConfigurationArn();

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _licenseConfigurationArn;

            /**
             * Sets the value of LicenseConfigurationArn
             * @param value `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * @return {@code this}
             */
            public Builder withLicenseConfigurationArn(@javax.annotation.Nullable final java.lang.String value) {
                this._licenseConfigurationArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LicenseSpecificationProperty build() {
                return new LicenseSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $licenseConfigurationArn = _licenseConfigurationArn;

                    @Override
                    public java.lang.String getLicenseConfigurationArn() {
                        return this.$licenseConfigurationArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LicenseSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getLicenseConfigurationArn() {
                return this.jsiiGet("licenseConfigurationArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    public static interface MonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link MonitoringProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MonitoringProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Enabled
             * @param value `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MonitoringProperty build() {
                return new MonitoringProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.MonitoringProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        java.lang.String getDescription();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        java.lang.Object getDeviceIndex();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        java.util.List<java.lang.String> getGroups();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        java.lang.Object getIpv6AddressCount();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        java.lang.Object getIpv6Addresses();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        java.lang.String getNetworkInterfaceId();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        java.lang.String getPrivateIpAddress();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        java.lang.Object getPrivateIpAddresses();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        java.lang.Object getSecondaryPrivateIpAddressCount();
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Object _deviceIndex;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _groups;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.String _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.String _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Object _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * @return {@code this}
             */
            public Builder withDeviceIndex(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
             * @return {@code this}
             */
            public Builder withGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
             * @return {@code this}
             */
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deviceIndex = _deviceIndex;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $groups = _groups;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private final java.lang.String $privateIpAddress = _privateIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private final java.lang.Object $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.Object getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public java.util.List<java.lang.String> getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public java.lang.Object getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public java.lang.String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public java.lang.Object getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                        obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        obj.set("description", om.valueToTree(this.getDescription()));
                        obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                        obj.set("groups", om.valueToTree(this.getGroups()));
                        obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                        obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                        obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                        obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                        obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                        obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getGroups() {
                return this.jsiiGet("groups", java.util.List.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        java.lang.String getAffinity();
        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        java.lang.String getAvailabilityZone();
        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        java.lang.String getGroupName();
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        java.lang.String getHostId();
        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        java.lang.String getTenancy();

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PlacementProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _affinity;
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _groupName;
            @javax.annotation.Nullable
            private java.lang.String _hostId;
            @javax.annotation.Nullable
            private java.lang.String _tenancy;

            /**
             * Sets the value of Affinity
             * @param value `CfnLaunchTemplate.PlacementProperty.Affinity`.
             * @return {@code this}
             */
            public Builder withAffinity(@javax.annotation.Nullable final java.lang.String value) {
                this._affinity = value;
                return this;
            }
            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value `CfnLaunchTemplate.PlacementProperty.GroupName`.
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of HostId
             * @param value `CfnLaunchTemplate.PlacementProperty.HostId`.
             * @return {@code this}
             */
            public Builder withHostId(@javax.annotation.Nullable final java.lang.String value) {
                this._hostId = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value `CfnLaunchTemplate.PlacementProperty.Tenancy`.
             * @return {@code this}
             */
            public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this._tenancy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PlacementProperty build() {
                return new PlacementProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $affinity = _affinity;
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $groupName = _groupName;
                    @javax.annotation.Nullable
                    private final java.lang.String $hostId = _hostId;
                    @javax.annotation.Nullable
                    private final java.lang.String $tenancy = _tenancy;

                    @Override
                    public java.lang.String getAffinity() {
                        return this.$affinity;
                    }

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public java.lang.String getHostId() {
                        return this.$hostId;
                    }

                    @Override
                    public java.lang.String getTenancy() {
                        return this.$tenancy;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("affinity", om.valueToTree(this.getAffinity()));
                        obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        obj.set("groupName", om.valueToTree(this.getGroupName()));
                        obj.set("hostId", om.valueToTree(this.getHostId()));
                        obj.set("tenancy", om.valueToTree(this.getTenancy()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.Affinity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAffinity() {
                return this.jsiiGet("affinity", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.GroupName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getGroupName() {
                return this.jsiiGet("groupName", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.HostId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHostId() {
                return this.jsiiGet("hostId", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.PlacementProperty.Tenancy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTenancy() {
                return this.jsiiGet("tenancy", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    public static interface PrivateIpAddProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        java.lang.Object getPrimary();
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        java.lang.String getPrivateIpAddress();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _primary;
            @javax.annotation.Nullable
            private java.lang.String _privateIpAddress;

            /**
             * Sets the value of Primary
             * @param value `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * @return {@code this}
             */
            public Builder withPrimary(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PrivateIpAddProperty build() {
                return new PrivateIpAddProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $primary = _primary;
                    @javax.annotation.Nullable
                    private final java.lang.String $privateIpAddress = _privateIpAddress;

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("primary", om.valueToTree(this.getPrimary()));
                        obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PrivateIpAddProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    public static interface SpotOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        java.lang.String getInstanceInterruptionBehavior();
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        java.lang.String getMaxPrice();
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        java.lang.String getSpotInstanceType();

        /**
         * @return a {@link Builder} of {@link SpotOptionsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotOptionsProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.String _maxPrice;
            @javax.annotation.Nullable
            private java.lang.String _spotInstanceType;

            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of MaxPrice
             * @param value `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
             * @return {@code this}
             */
            public Builder withMaxPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._maxPrice = value;
                return this;
            }
            /**
             * Sets the value of SpotInstanceType
             * @param value `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
             * @return {@code this}
             */
            public Builder withSpotInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._spotInstanceType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SpotOptionsProperty build() {
                return new SpotOptionsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.String $maxPrice = _maxPrice;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotInstanceType = _spotInstanceType;

                    @Override
                    public java.lang.String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public java.lang.String getMaxPrice() {
                        return this.$maxPrice;
                    }

                    @Override
                    public java.lang.String getSpotInstanceType() {
                        return this.$spotInstanceType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                        obj.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                        obj.set("spotInstanceType", om.valueToTree(this.getSpotInstanceType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMaxPrice() {
                return this.jsiiGet("maxPrice", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSpotInstanceType() {
                return this.jsiiGet("spotInstanceType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        java.lang.String getResourceType();
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        java.util.List<software.amazon.awscdk.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagSpecificationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _resourceType;
            @javax.annotation.Nullable
            private java.util.List<software.amazon.awscdk.CfnTag> _tags;

            /**
             * Sets the value of ResourceType
             * @param value `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagSpecificationProperty build() {
                return new TagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;

                    @Override
                    public java.lang.String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                        return this.$tags;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceType", om.valueToTree(this.getResourceType()));
                        obj.set("tags", om.valueToTree(this.getTags()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnLaunchTemplate.TagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getResourceType() {
                return this.jsiiGet("resourceType", java.lang.String.class);
            }

            /**
             * `CfnLaunchTemplate.TagSpecificationProperty.Tags`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.jsiiGet("tags", java.util.List.class);
            }
        }
    }
}
