package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:15:07.457Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkAclEntry")
public class CfnNetworkAclEntry extends software.amazon.awscdk.CfnResource {
    protected CfnNetworkAclEntry(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::NetworkAclEntry`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnNetworkAclEntry(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnNetworkAclEntryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getNetworkAclEntryName() {
        return this.jsiiGet("networkAclEntryName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.ec2.CfnNetworkAclEntryProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.ec2.CfnNetworkAclEntryProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html
     */
    public static interface IcmpProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Code`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         */
        java.lang.Object getCode();
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         */
        java.lang.Object getType();

        /**
         * @return a {@link Builder} of {@link IcmpProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IcmpProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _code;
            @javax.annotation.Nullable
            private java.lang.Object _type;

            /**
             * Sets the value of Code
             * @param value `CfnNetworkAclEntry.IcmpProperty.Code`.
             * @return {@code this}
             */
            public Builder withCode(@javax.annotation.Nullable final java.lang.Number value) {
                this._code = value;
                return this;
            }
            /**
             * Sets the value of Code
             * @param value `CfnNetworkAclEntry.IcmpProperty.Code`.
             * @return {@code this}
             */
            public Builder withCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._code = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnNetworkAclEntry.IcmpProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.Number value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnNetworkAclEntry.IcmpProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IcmpProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IcmpProperty build() {
                return new IcmpProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $code = _code;
                    @javax.annotation.Nullable
                    private final java.lang.Object $type = _type;

                    @Override
                    public java.lang.Object getCode() {
                        return this.$code;
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("code", om.valueToTree(this.getCode()));
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.IcmpProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnNetworkAclEntry.IcmpProperty.Code`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCode() {
                return this.jsiiGet("code", java.lang.Object.class);
            }

            /**
             * `CfnNetworkAclEntry.IcmpProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html
     */
    public static interface PortRangeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.From`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         */
        java.lang.Object getFrom();
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.To`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         */
        java.lang.Object getTo();

        /**
         * @return a {@link Builder} of {@link PortRangeProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PortRangeProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _from;
            @javax.annotation.Nullable
            private java.lang.Object _to;

            /**
             * Sets the value of From
             * @param value `CfnNetworkAclEntry.PortRangeProperty.From`.
             * @return {@code this}
             */
            public Builder withFrom(@javax.annotation.Nullable final java.lang.Number value) {
                this._from = value;
                return this;
            }
            /**
             * Sets the value of From
             * @param value `CfnNetworkAclEntry.PortRangeProperty.From`.
             * @return {@code this}
             */
            public Builder withFrom(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._from = value;
                return this;
            }
            /**
             * Sets the value of To
             * @param value `CfnNetworkAclEntry.PortRangeProperty.To`.
             * @return {@code this}
             */
            public Builder withTo(@javax.annotation.Nullable final java.lang.Number value) {
                this._to = value;
                return this;
            }
            /**
             * Sets the value of To
             * @param value `CfnNetworkAclEntry.PortRangeProperty.To`.
             * @return {@code this}
             */
            public Builder withTo(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._to = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public PortRangeProperty build() {
                return new PortRangeProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $from = _from;
                    @javax.annotation.Nullable
                    private final java.lang.Object $to = _to;

                    @Override
                    public java.lang.Object getFrom() {
                        return this.$from;
                    }

                    @Override
                    public java.lang.Object getTo() {
                        return this.$to;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("from", om.valueToTree(this.getFrom()));
                        obj.set("to", om.valueToTree(this.getTo()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.PortRangeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnNetworkAclEntry.PortRangeProperty.From`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFrom() {
                return this.jsiiGet("from", java.lang.Object.class);
            }

            /**
             * `CfnNetworkAclEntry.PortRangeProperty.To`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTo() {
                return this.jsiiGet("to", java.lang.Object.class);
            }
        }
    }
}
