package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::NetworkInterfaceAttachment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:15:07.462Z")
public interface CfnNetworkInterfaceAttachmentProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     */
    java.lang.String getDeviceIndex();
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     */
    java.lang.String getInstanceId();
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     */
    java.lang.String getNetworkInterfaceId();
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     */
    java.lang.Object getDeleteOnTermination();

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfaceAttachmentProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnNetworkInterfaceAttachmentProps}
     */
    final class Builder {
        private java.lang.String _deviceIndex;
        private java.lang.String _instanceId;
        private java.lang.String _networkInterfaceId;
        @javax.annotation.Nullable
        private java.lang.Object _deleteOnTermination;

        /**
         * Sets the value of DeviceIndex
         * @param value `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
         * @return {@code this}
         */
        public Builder withDeviceIndex(final java.lang.String value) {
            this._deviceIndex = java.util.Objects.requireNonNull(value, "deviceIndex is required");
            return this;
        }
        /**
         * Sets the value of InstanceId
         * @param value `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
         * @return {@code this}
         */
        public Builder withInstanceId(final java.lang.String value) {
            this._instanceId = java.util.Objects.requireNonNull(value, "instanceId is required");
            return this;
        }
        /**
         * Sets the value of NetworkInterfaceId
         * @param value `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
         * @return {@code this}
         */
        public Builder withNetworkInterfaceId(final java.lang.String value) {
            this._networkInterfaceId = java.util.Objects.requireNonNull(value, "networkInterfaceId is required");
            return this;
        }
        /**
         * Sets the value of DeleteOnTermination
         * @param value `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
         * @return {@code this}
         */
        public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deleteOnTermination = value;
            return this;
        }
        /**
         * Sets the value of DeleteOnTermination
         * @param value `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
         * @return {@code this}
         */
        public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this._deleteOnTermination = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfaceAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnNetworkInterfaceAttachmentProps build() {
            return new CfnNetworkInterfaceAttachmentProps() {
                private final java.lang.String $deviceIndex = java.util.Objects.requireNonNull(_deviceIndex, "deviceIndex is required");
                private final java.lang.String $instanceId = java.util.Objects.requireNonNull(_instanceId, "instanceId is required");
                private final java.lang.String $networkInterfaceId = java.util.Objects.requireNonNull(_networkInterfaceId, "networkInterfaceId is required");
                @javax.annotation.Nullable
                private final java.lang.Object $deleteOnTermination = _deleteOnTermination;

                @Override
                public java.lang.String getDeviceIndex() {
                    return this.$deviceIndex;
                }

                @Override
                public java.lang.String getInstanceId() {
                    return this.$instanceId;
                }

                @Override
                public java.lang.String getNetworkInterfaceId() {
                    return this.$networkInterfaceId;
                }

                @Override
                public java.lang.Object getDeleteOnTermination() {
                    return this.$deleteOnTermination;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                    obj.set("instanceId", om.valueToTree(this.getInstanceId()));
                    obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                    obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
         */
        @Override
        public java.lang.String getDeviceIndex() {
            return this.jsiiGet("deviceIndex", java.lang.String.class);
        }

        /**
         * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
         */
        @Override
        public java.lang.String getInstanceId() {
            return this.jsiiGet("instanceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
         */
        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.jsiiGet("networkInterfaceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getDeleteOnTermination() {
            return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
        }
    }
}
