package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpointConnectionNotification`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:15:07.571Z")
public interface CfnVPCEndpointConnectionNotificationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     */
    java.util.List<java.lang.String> getConnectionEvents();
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     */
    java.lang.String getConnectionNotificationArn();
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     */
    java.lang.String getServiceId();
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     */
    java.lang.String getVpcEndpointId();

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointConnectionNotificationProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnVPCEndpointConnectionNotificationProps}
     */
    final class Builder {
        private java.util.List<java.lang.String> _connectionEvents;
        private java.lang.String _connectionNotificationArn;
        @javax.annotation.Nullable
        private java.lang.String _serviceId;
        @javax.annotation.Nullable
        private java.lang.String _vpcEndpointId;

        /**
         * Sets the value of ConnectionEvents
         * @param value `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
         * @return {@code this}
         */
        public Builder withConnectionEvents(final java.util.List<java.lang.String> value) {
            this._connectionEvents = java.util.Objects.requireNonNull(value, "connectionEvents is required");
            return this;
        }
        /**
         * Sets the value of ConnectionNotificationArn
         * @param value `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
         * @return {@code this}
         */
        public Builder withConnectionNotificationArn(final java.lang.String value) {
            this._connectionNotificationArn = java.util.Objects.requireNonNull(value, "connectionNotificationArn is required");
            return this;
        }
        /**
         * Sets the value of ServiceId
         * @param value `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
         * @return {@code this}
         */
        public Builder withServiceId(@javax.annotation.Nullable final java.lang.String value) {
            this._serviceId = value;
            return this;
        }
        /**
         * Sets the value of VpcEndpointId
         * @param value `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
         * @return {@code this}
         */
        public Builder withVpcEndpointId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcEndpointId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointConnectionNotificationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnVPCEndpointConnectionNotificationProps build() {
            return new CfnVPCEndpointConnectionNotificationProps() {
                private final java.util.List<java.lang.String> $connectionEvents = java.util.Objects.requireNonNull(_connectionEvents, "connectionEvents is required");
                private final java.lang.String $connectionNotificationArn = java.util.Objects.requireNonNull(_connectionNotificationArn, "connectionNotificationArn is required");
                @javax.annotation.Nullable
                private final java.lang.String $serviceId = _serviceId;
                @javax.annotation.Nullable
                private final java.lang.String $vpcEndpointId = _vpcEndpointId;

                @Override
                public java.util.List<java.lang.String> getConnectionEvents() {
                    return this.$connectionEvents;
                }

                @Override
                public java.lang.String getConnectionNotificationArn() {
                    return this.$connectionNotificationArn;
                }

                @Override
                public java.lang.String getServiceId() {
                    return this.$serviceId;
                }

                @Override
                public java.lang.String getVpcEndpointId() {
                    return this.$vpcEndpointId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("connectionEvents", om.valueToTree(this.getConnectionEvents()));
                    obj.set("connectionNotificationArn", om.valueToTree(this.getConnectionNotificationArn()));
                    obj.set("serviceId", om.valueToTree(this.getServiceId()));
                    obj.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnVPCEndpointConnectionNotificationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
         */
        @Override
        public java.util.List<java.lang.String> getConnectionEvents() {
            return this.jsiiGet("connectionEvents", java.util.List.class);
        }

        /**
         * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
         */
        @Override
        public java.lang.String getConnectionNotificationArn() {
            return this.jsiiGet("connectionNotificationArn", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getServiceId() {
            return this.jsiiGet("serviceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcEndpointId() {
            return this.jsiiGet("vpcEndpointId", java.lang.String.class);
        }
    }
}
