package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux image properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:30.212Z")
public interface AmazonLinuxImageProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * What edition of Amazon Linux to use.
     * 
     * Default: Standard
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition();
    /**
     * What generation of Amazon Linux to use.
     * 
     * Default: AmazonLinux
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration();
    /**
     * What storage backed image to use.
     * 
     * Default: GeneralPurpose
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage();
    /**
     * Virtualization type.
     * 
     * Default: HVM
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization();

    /**
     * @return a {@link Builder} of {@link AmazonLinuxImageProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AmazonLinuxImageProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxEdition _edition;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxGeneration _generation;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxStorage _storage;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.AmazonLinuxVirt _virtualization;

        /**
         * Sets the value of Edition
         * @param value What edition of Amazon Linux to use.
         * @return {@code this}
         */
        public Builder withEdition(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxEdition value) {
            this._edition = value;
            return this;
        }
        /**
         * Sets the value of Generation
         * @param value What generation of Amazon Linux to use.
         * @return {@code this}
         */
        public Builder withGeneration(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration value) {
            this._generation = value;
            return this;
        }
        /**
         * Sets the value of Storage
         * @param value What storage backed image to use.
         * @return {@code this}
         */
        public Builder withStorage(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxStorage value) {
            this._storage = value;
            return this;
        }
        /**
         * Sets the value of Virtualization
         * @param value Virtualization type.
         * @return {@code this}
         */
        public Builder withVirtualization(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxVirt value) {
            this._virtualization = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AmazonLinuxImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AmazonLinuxImageProps build() {
            return new AmazonLinuxImageProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxEdition $edition = _edition;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration $generation = _generation;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxStorage $storage = _storage;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.AmazonLinuxVirt $virtualization = _virtualization;

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
                    return this.$edition;
                }

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
                    return this.$generation;
                }

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
                    return this.$storage;
                }

                @Override
                public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
                    return this.$virtualization;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("edition", om.valueToTree(this.getEdition()));
                    obj.set("generation", om.valueToTree(this.getGeneration()));
                    obj.set("storage", om.valueToTree(this.getStorage()));
                    obj.set("virtualization", om.valueToTree(this.getVirtualization()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.AmazonLinuxImageProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * What edition of Amazon Linux to use.
         * 
         * Default: Standard
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
            return this.jsiiGet("edition", software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class);
        }

        /**
         * What generation of Amazon Linux to use.
         * 
         * Default: AmazonLinux
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
            return this.jsiiGet("generation", software.amazon.awscdk.services.ec2.AmazonLinuxGeneration.class);
        }

        /**
         * What storage backed image to use.
         * 
         * Default: GeneralPurpose
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
            return this.jsiiGet("storage", software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class);
        }

        /**
         * Virtualization type.
         * 
         * Default: HVM
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
            return this.jsiiGet("virtualization", software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class);
        }
    }
}
