package software.amazon.awscdk.services.ec2;

/**
 * Manage the allowed network connections for constructs with Security Groups.
 * 
 * Security Groups can be thought of as a firewall for network-connected
 * devices. This class makes it easy to allow network connections to and
 * from security groups, and between security groups individually. When
 * establishing connectivity between security groups, it will automatically
 * add rules in both security groups
 * 
 * This object can manage one or more security groups.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:30.383Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Connections")
public class Connections extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {
    protected Connections(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Connections(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ConnectionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }
    public Connections() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a security group to the list of security groups managed by this object.
     */
    public void addSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup... securityGroups) {
        this.jsiiCall("addSecurityGroup", Void.class, java.util.Arrays.<Object>stream(securityGroups).toArray(Object[]::new));
    }

    /**
     * Allow connections from the peer on our default port.
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections from the peer on our default port.
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Allow default connections from all IPv4 ranges.
     */
    public void allowDefaultPortFromAnyIpv4(@javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class, new Object[] { description });
    }

    /**
     * Allow default connections from all IPv4 ranges.
     */
    public void allowDefaultPortFromAnyIpv4() {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class);
    }

    /**
     * Allow hosts inside the security group to connect to each other.
     */
    public void allowDefaultPortInternally(@javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortInternally", Void.class, new Object[] { description });
    }

    /**
     * Allow hosts inside the security group to connect to each other.
     */
    public void allowDefaultPortInternally() {
        this.jsiiCall("allowDefaultPortInternally", Void.class);
    }

    /**
     * Allow connections from the peer on our default port.
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortTo(final software.amazon.awscdk.services.ec2.IConnectable other, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowDefaultPortTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections from the peer on our default port.
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortTo(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowDefaultPortTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    /**
     * Allow connections from the peer on the given port.
     */
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow connections from the peer on the given port.
     */
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowFrom", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow from any IPv4 ranges.
     */
    public void allowFromAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowFromAnyIPv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow from any IPv4 ranges.
     */
    public void allowFromAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowFromAnyIPv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port.
     */
    public void allowInternally(final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowInternally", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow hosts inside the security group to connect to each other on the given port.
     */
    public void allowInternally(final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowInternally", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow connections to the peer on the given port.
     */
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow connections to the peer on the given port.
     */
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowTo", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow to all IPv4 ranges.
     */
    public void allowToAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowToAnyIPv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required"), description });
    }

    /**
     * Allow to all IPv4 ranges.
     */
    public void allowToAnyIPv4(final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("allowToAnyIPv4", Void.class, new Object[] { java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Allow connections to the security group on their default port.
     */
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IConnectable other, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("allowToDefaultPort", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required"), description });
    }

    /**
     * Allow connections to the security group on their default port.
     */
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IConnectable other) {
        this.jsiiCall("allowToDefaultPort", Void.class, new Object[] { java.util.Objects.requireNonNull(other, "other is required") });
    }

    @Override
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return this.jsiiGet("securityGroups", java.util.List.class);
    }

    /**
     * The default port configured for this connection peer, if available.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
        return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
    }
}
