package software.amazon.awscdk.services.ec2;

/**
 * Properties to intialize a new Connections object.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:30.385Z")
public interface ConnectionsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Default port range for initiating connections to and from this object.
     * 
     * Default: No default port range
     */
    software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange();
    /**
     * Class that represents the rule by which others can connect to this connectable.
     * 
     * This object is required, but will be derived from securityGroup if that is passed.
     * 
     * Default: Derived from securityGroup if set.
     */
    software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule();
    /**
     * What securityGroup(s) this object is managing connections for.
     * 
     * Default: No security groups
     */
    java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * @return a {@link Builder} of {@link ConnectionsProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ConnectionsProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.IPortRange _defaultPortRange;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.ISecurityGroupRule _securityGroupRule;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> _securityGroups;

        /**
         * Sets the value of DefaultPortRange
         * @param value Default port range for initiating connections to and from this object.
         * @return {@code this}
         */
        public Builder withDefaultPortRange(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPortRange value) {
            this._defaultPortRange = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroupRule
         * @param value Class that represents the rule by which others can connect to this connectable.
         * @return {@code this}
         */
        public Builder withSecurityGroupRule(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroupRule value) {
            this._securityGroupRule = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroups
         * @param value What securityGroup(s) this object is managing connections for.
         * @return {@code this}
         */
        public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> value) {
            this._securityGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ConnectionsProps build() {
            return new ConnectionsProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.IPortRange $defaultPortRange = _defaultPortRange;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.ISecurityGroupRule $securityGroupRule = _securityGroupRule;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> $securityGroups = _securityGroups;

                @Override
                public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
                    return this.$defaultPortRange;
                }

                @Override
                public software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule() {
                    return this.$securityGroupRule;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
                    return this.$securityGroups;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("defaultPortRange", om.valueToTree(this.getDefaultPortRange()));
                    obj.set("securityGroupRule", om.valueToTree(this.getSecurityGroupRule()));
                    obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ConnectionsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Default port range for initiating connections to and from this object.
         * 
         * Default: No default port range
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
            return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
        }

        /**
         * Class that represents the rule by which others can connect to this connectable.
         * 
         * This object is required, but will be derived from securityGroup if that is passed.
         * 
         * Default: Derived from securityGroup if set.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.ISecurityGroupRule getSecurityGroupRule() {
            return this.jsiiGet("securityGroupRule", software.amazon.awscdk.services.ec2.ISecurityGroupRule.class);
        }

        /**
         * What securityGroup(s) this object is managing connections for.
         * 
         * Default: No security groups
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.jsiiGet("securityGroups", java.util.List.class);
        }
    }
}
