package software.amazon.awscdk.services.ec2;

@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:30.402Z")
public interface SecurityGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The VPC in which to create the security group.
     */
    software.amazon.awscdk.services.ec2.IVpc getVpc();
    /**
     * Whether to allow all outbound traffic by default.
     * 
     * If this is set to true, there will only be a single egress rule which allows all
     * outbound traffic. If this is set to false, no outbound traffic will be allowed by
     * default and all egress traffic must be explicitly authorized.
     * 
     * Default: true
     */
    java.lang.Boolean getAllowAllOutbound();
    /**
     * A description of the security group.
     * 
     * Default: The default name will be the construct's CDK path.
     */
    java.lang.String getDescription();
    /**
     * The name of the security group.
     * 
     * For valid values, see the GroupName
     * parameter of the CreateSecurityGroup action in the Amazon EC2 API
     * Reference.
     * 
     * It is not recommended to use an explicit group name.
     * 
     * Default: If you don't specify a GroupName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     */
    java.lang.String getGroupName();

    /**
     * @return a {@link Builder} of {@link SecurityGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SecurityGroupProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.IVpc _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _allowAllOutbound;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _groupName;

        /**
         * Sets the value of Vpc
         * @param value The VPC in which to create the security group.
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpc value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of AllowAllOutbound
         * @param value Whether to allow all outbound traffic by default.
         * @return {@code this}
         */
        public Builder withAllowAllOutbound(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the security group.
         * @return {@code this}
         */
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of GroupName
         * @param value The name of the security group.
         * @return {@code this}
         */
        public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._groupName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SecurityGroupProps build() {
            return new SecurityGroupProps() {
                private final software.amazon.awscdk.services.ec2.IVpc $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $allowAllOutbound = _allowAllOutbound;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.String $groupName = _groupName;

                @Override
                public software.amazon.awscdk.services.ec2.IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public java.lang.Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.String getGroupName() {
                    return this.$groupName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
                    obj.set("description", om.valueToTree(this.getDescription()));
                    obj.set("groupName", om.valueToTree(this.getGroupName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SecurityGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC in which to create the security group.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Whether to allow all outbound traffic by default.
         * 
         * If this is set to true, there will only be a single egress rule which allows all
         * outbound traffic. If this is set to false, no outbound traffic will be allowed by
         * default and all egress traffic must be explicitly authorized.
         * 
         * Default: true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getAllowAllOutbound() {
            return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
        }

        /**
         * A description of the security group.
         * 
         * Default: The default name will be the construct's CDK path.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * The name of the security group.
         * 
         * For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * 
         * It is not recommended to use an explicit group name.
         * 
         * Default: If you don't specify a GroupName, AWS CloudFormation generates a
         * unique physical ID and uses that ID for the group name.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }
    }
}
