/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnNetworkInterfaceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnNetworkInterface")
public class CfnNetworkInterface
extends CfnResource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnNetworkInterface.class, (String)"resourceTypeName", String.class);

    protected CfnNetworkInterface(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnNetworkInterface(Construct scope, String id, CfnNetworkInterfaceProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> renderProperties(@Nullable Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{properties});
    }

    public String getNetworkInterfaceName() {
        return (String)this.jsiiGet("networkInterfaceName", String.class);
    }

    public String getNetworkInterfacePrimaryPrivateIpAddress() {
        return (String)this.jsiiGet("networkInterfacePrimaryPrivateIpAddress", String.class);
    }

    public List<String> getNetworkInterfaceSecondaryPrivateIpAddresses() {
        return (List)this.jsiiGet("networkInterfaceSecondaryPrivateIpAddresses", List.class);
    }

    public CfnNetworkInterfaceProps getPropertyOverrides() {
        return (CfnNetworkInterfaceProps)this.jsiiGet("propertyOverrides", CfnNetworkInterfaceProps.class);
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        public Object getPrimary();

        public String getPrivateIpAddress();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _primary;
            private String _privateIpAddress;

            public Builder withPrimary(Boolean value) {
                this._primary = Objects.requireNonNull(value, "primary is required");
                return this;
            }

            public Builder withPrimary(Token value) {
                this._primary = Objects.requireNonNull(value, "primary is required");
                return this;
            }

            public Builder withPrivateIpAddress(String value) {
                this._privateIpAddress = Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty(){
                    private final Object $primary;
                    private final String $privateIpAddress;
                    {
                        this.$primary = Objects.requireNonNull(_primary, "primary is required");
                        this.$privateIpAddress = Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");
                    }

                    @Override
                    public Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("primary", om.valueToTree(this.getPrimary()));
                        obj.set("privateIpAddress", om.valueToTree((Object)this.getPrivateIpAddress()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _ipv6Address;

            public Builder withIpv6Address(String value) {
                this._ipv6Address = Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty(){
                    private final String $ipv6Address;
                    {
                        this.$ipv6Address = Objects.requireNonNull(_ipv6Address, "ipv6Address is required");
                    }

                    @Override
                    public String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("ipv6Address", om.valueToTree((Object)this.getIpv6Address()));
                        return obj;
                    }
                };
            }
        }
    }
}

