package software.amazon.awscdk.services.ec2;

/**
 * Creates an Amazon EC2 security group within a VPC.
 * 
 * This class has an additional optimization over imported security groups that it can also create
 * inline ingress and egress rule (which saves on the total number of resources inside
 * the template).
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:04:59.493Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SecurityGroup")
public class SecurityGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.ISecurityGroup {
    protected SecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecurityGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.SecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing security group into this app.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.ec2.ISecurityGroup fromSecurityGroupId(final software.amazon.awscdk.Construct scope, final java.lang.String id, final java.lang.String securityGroupId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "fromSecurityGroupId", software.amazon.awscdk.services.ec2.ISecurityGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required") });
    }

    /**
     * Return whether the indicated object is a security group.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static java.lang.Boolean isSecurityGroup(@javax.annotation.Nullable final java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "isSecurityGroup", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * Add an egress rule for the current security group.
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description, @javax.annotation.Nullable final java.lang.Boolean remoteRule) {
        this.jsiiCall("addEgressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
    }

    /**
     * Add an egress rule for the current security group.
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("addEgressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
    }

    /**
     * Add an egress rule for the current security group.
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection) {
        this.jsiiCall("addEgressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
    }

    /**
     * Add an ingress rule for the current security group.
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description, @javax.annotation.Nullable final java.lang.Boolean remoteRule) {
        this.jsiiCall("addIngressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
    }

    /**
     * Add an ingress rule for the current security group.
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection, @javax.annotation.Nullable final java.lang.String description) {
        this.jsiiCall("addIngressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
    }

    /**
     * Add an ingress rule for the current security group.
     * 
     * `remoteRule` controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.ISecurityGroupRule peer, final software.amazon.awscdk.services.ec2.IPortRange connection) {
        this.jsiiCall("addIngressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
    }

    /**
     * Produce the egress rule JSON for the given connection.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    @javax.annotation.Nullable
    public java.lang.Object toEgressRuleJSON() {
        return this.jsiiCall("toEgressRuleJSON", java.lang.Object.class);
    }

    /**
     * Produce the ingress rule JSON for the given connection.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    @javax.annotation.Nullable
    public java.lang.Object toIngressRuleJSON() {
        return this.jsiiCall("toIngressRuleJSON", java.lang.Object.class);
    }

    /**
     * Whether the rule can be inlined into a SecurityGroup or not.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.Boolean getCanInlineRule() {
        return this.jsiiGet("canInlineRule", java.lang.Boolean.class);
    }

    /**
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The ID of the security group.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", java.lang.String.class);
    }

    /**
     * An attribute that represents the security group name.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getSecurityGroupName() {
        return this.jsiiGet("securityGroupName", java.lang.String.class);
    }

    /**
     * The VPC ID this security group is part of.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getSecurityGroupVpcId() {
        return this.jsiiGet("securityGroupVpcId", java.lang.String.class);
    }

    /**
     * A unique identifier for this connection peer.
     * 
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getUniqueId() {
        return this.jsiiGet("uniqueId", java.lang.String.class);
    }

    /**
     * FIXME: Where to place this??
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
        return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
    }
}
