package software.amazon.awscdk.services.ec2;

/**
 * Result of selecting a subset of subnets from a VPC.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:04:59.494Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SelectedSubnets extends software.amazon.jsii.JsiiSerializable {
    /**
     * The respective AZs of each subnet.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getAvailabilityZones();
    /**
     * Dependency representing internet connectivity for these subnets.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.IDependable getInternetConnectedDependency();
    /**
     * Route table IDs of each respective subnet.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getRouteTableIds();
    /**
     * The subnet IDs.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getSubnetIds();

    /**
     * @return a {@link Builder} of {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.util.List<java.lang.String> _availabilityZones;
        private software.amazon.awscdk.IDependable _internetConnectedDependency;
        private java.util.List<java.lang.String> _routeTableIds;
        private java.util.List<java.lang.String> _subnetIds;

        /**
         * Sets the value of AvailabilityZones
         * @param value The respective AZs of each subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAvailabilityZones(final java.util.List<java.lang.String> value) {
            this._availabilityZones = java.util.Objects.requireNonNull(value, "availabilityZones is required");
            return this;
        }
        /**
         * Sets the value of InternetConnectedDependency
         * @param value Dependency representing internet connectivity for these subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withInternetConnectedDependency(final software.amazon.awscdk.IDependable value) {
            this._internetConnectedDependency = java.util.Objects.requireNonNull(value, "internetConnectedDependency is required");
            return this;
        }
        /**
         * Sets the value of RouteTableIds
         * @param value Route table IDs of each respective subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRouteTableIds(final java.util.List<java.lang.String> value) {
            this._routeTableIds = java.util.Objects.requireNonNull(value, "routeTableIds is required");
            return this;
        }
        /**
         * Sets the value of SubnetIds
         * @param value The subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withSubnetIds(final java.util.List<java.lang.String> value) {
            this._subnetIds = java.util.Objects.requireNonNull(value, "subnetIds is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SelectedSubnets}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public SelectedSubnets build() {
            return new SelectedSubnets() {
                private final java.util.List<java.lang.String> $availabilityZones = java.util.Objects.requireNonNull(_availabilityZones, "availabilityZones is required");
                private final software.amazon.awscdk.IDependable $internetConnectedDependency = java.util.Objects.requireNonNull(_internetConnectedDependency, "internetConnectedDependency is required");
                private final java.util.List<java.lang.String> $routeTableIds = java.util.Objects.requireNonNull(_routeTableIds, "routeTableIds is required");
                private final java.util.List<java.lang.String> $subnetIds = java.util.Objects.requireNonNull(_subnetIds, "subnetIds is required");

                @Override
                public java.util.List<java.lang.String> getAvailabilityZones() {
                    return this.$availabilityZones;
                }

                @Override
                public software.amazon.awscdk.IDependable getInternetConnectedDependency() {
                    return this.$internetConnectedDependency;
                }

                @Override
                public java.util.List<java.lang.String> getRouteTableIds() {
                    return this.$routeTableIds;
                }

                @Override
                public java.util.List<java.lang.String> getSubnetIds() {
                    return this.$subnetIds;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                    obj.set("internetConnectedDependency", om.valueToTree(this.getInternetConnectedDependency()));
                    obj.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
                    obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SelectedSubnets {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The respective AZs of each subnet.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * Dependency representing internet connectivity for these subnets.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.IDependable getInternetConnectedDependency() {
            return this.jsiiGet("internetConnectedDependency", software.amazon.awscdk.IDependable.class);
        }

        /**
         * Route table IDs of each respective subnet.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getRouteTableIds() {
            return this.jsiiGet("routeTableIds", java.util.List.class);
        }

        /**
         * The subnet IDs.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.jsiiGet("subnetIds", java.util.List.class);
        }
    }
}
