package software.amazon.awscdk.services.ec2;

/**
 * Customize subnets that are selected for placement of ENIs.
 * 
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 * 
 * By default, the instances are placed in the private subnets.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:04:59.495Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SubnetSelection extends software.amazon.jsii.JsiiSerializable {
    /**
     * If true, return at most one subnet per AZ.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getOnePerAz();
    /**
     * Place the instances in the subnets with the given name.
     * 
     * (This is the name supplied in subnetConfiguration).
     * 
     * At most one of `subnetType` and `subnetName` can be supplied.
     * 
     * Default: name
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getSubnetName();
    /**
     * Place the instances in the subnets of the given type.
     * 
     * At most one of `subnetType` and `subnetName` can be supplied.
     * 
     * Default: SubnetType.Private
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.SubnetType getSubnetType();

    /**
     * @return a {@link Builder} of {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _onePerAz;
        @javax.annotation.Nullable
        private java.lang.String _subnetName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetType _subnetType;

        /**
         * Sets the value of OnePerAz
         * @param value If true, return at most one subnet per AZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withOnePerAz(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._onePerAz = value;
            return this;
        }
        /**
         * Sets the value of SubnetName
         * @param value Place the instances in the subnets with the given name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withSubnetName(@javax.annotation.Nullable final java.lang.String value) {
            this._subnetName = value;
            return this;
        }
        /**
         * Sets the value of SubnetType
         * @param value Place the instances in the subnets of the given type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withSubnetType(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetType value) {
            this._subnetType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetSelection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public SubnetSelection build() {
            return new SubnetSelection() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $onePerAz = _onePerAz;
                @javax.annotation.Nullable
                private final java.lang.String $subnetName = _subnetName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetType $subnetType = _subnetType;

                @Override
                public java.lang.Boolean getOnePerAz() {
                    return this.$onePerAz;
                }

                @Override
                public java.lang.String getSubnetName() {
                    return this.$subnetName;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
                    return this.$subnetType;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getOnePerAz() != null) {
                        obj.set("onePerAz", om.valueToTree(this.getOnePerAz()));
                    }
                    if (this.getSubnetName() != null) {
                        obj.set("subnetName", om.valueToTree(this.getSubnetName()));
                    }
                    if (this.getSubnetType() != null) {
                        obj.set("subnetType", om.valueToTree(this.getSubnetType()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SubnetSelection {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * If true, return at most one subnet per AZ.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getOnePerAz() {
            return this.jsiiGet("onePerAz", java.lang.Boolean.class);
        }

        /**
         * Place the instances in the subnets with the given name.
         * 
         * (This is the name supplied in subnetConfiguration).
         * 
         * At most one of `subnetType` and `subnetName` can be supplied.
         * 
         * Default: name
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getSubnetName() {
            return this.jsiiGet("subnetName", java.lang.String.class);
        }

        /**
         * Place the instances in the subnets of the given type.
         * 
         * At most one of `subnetType` and `subnetName` can be supplied.
         * 
         * Default: SubnetType.Private
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
        }
    }
}
