/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnVPNConnectionProps
extends JsiiSerializable {
    public String getCustomerGatewayId();

    public String getType();

    public String getVpnGatewayId();

    public Object getStaticRoutesOnly();

    public List<CfnTag> getTags();

    public Object getVpnTunnelOptionsSpecifications();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _customerGatewayId;
        private String _type;
        private String _vpnGatewayId;
        @Nullable
        private Object _staticRoutesOnly;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private Object _vpnTunnelOptionsSpecifications;

        public Builder withCustomerGatewayId(String value) {
            this._customerGatewayId = Objects.requireNonNull(value, "customerGatewayId is required");
            return this;
        }

        public Builder withType(String value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withVpnGatewayId(String value) {
            this._vpnGatewayId = Objects.requireNonNull(value, "vpnGatewayId is required");
            return this;
        }

        public Builder withStaticRoutesOnly(@Nullable Boolean value) {
            this._staticRoutesOnly = value;
            return this;
        }

        public Builder withStaticRoutesOnly(@Nullable Token value) {
            this._staticRoutesOnly = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withVpnTunnelOptionsSpecifications(@Nullable Token value) {
            this._vpnTunnelOptionsSpecifications = value;
            return this;
        }

        public Builder withVpnTunnelOptionsSpecifications(@Nullable List<Object> value) {
            this._vpnTunnelOptionsSpecifications = value;
            return this;
        }

        public CfnVPNConnectionProps build() {
            return new CfnVPNConnectionProps(){
                private final String $customerGatewayId;
                private final String $type;
                private final String $vpnGatewayId;
                @Nullable
                private final Object $staticRoutesOnly;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final Object $vpnTunnelOptionsSpecifications;
                {
                    this.$customerGatewayId = Objects.requireNonNull(_customerGatewayId, "customerGatewayId is required");
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$vpnGatewayId = Objects.requireNonNull(_vpnGatewayId, "vpnGatewayId is required");
                    this.$staticRoutesOnly = _staticRoutesOnly;
                    this.$tags = _tags;
                    this.$vpnTunnelOptionsSpecifications = _vpnTunnelOptionsSpecifications;
                }

                @Override
                public String getCustomerGatewayId() {
                    return this.$customerGatewayId;
                }

                @Override
                public String getType() {
                    return this.$type;
                }

                @Override
                public String getVpnGatewayId() {
                    return this.$vpnGatewayId;
                }

                @Override
                public Object getStaticRoutesOnly() {
                    return this.$staticRoutesOnly;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public Object getVpnTunnelOptionsSpecifications() {
                    return this.$vpnTunnelOptionsSpecifications;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("customerGatewayId", om.valueToTree((Object)this.getCustomerGatewayId()));
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    obj.set("vpnGatewayId", om.valueToTree((Object)this.getVpnGatewayId()));
                    if (this.getStaticRoutesOnly() != null) {
                        obj.set("staticRoutesOnly", om.valueToTree(this.getStaticRoutesOnly()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getVpnTunnelOptionsSpecifications() != null) {
                        obj.set("vpnTunnelOptionsSpecifications", om.valueToTree(this.getVpnTunnelOptionsSpecifications()));
                    }
                    return obj;
                }
            };
        }
    }
}

