/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SecurityGroupProps
extends JsiiSerializable {
    public IVpc getVpc();

    public Boolean getAllowAllOutbound();

    public String getDescription();

    public String getGroupName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc _vpc;
        @Nullable
        private Boolean _allowAllOutbound;
        @Nullable
        private String _description;
        @Nullable
        private String _groupName;

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withAllowAllOutbound(@Nullable Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withGroupName(@Nullable String value) {
            this._groupName = value;
            return this;
        }

        public SecurityGroupProps build() {
            return new SecurityGroupProps(){
                private final IVpc $vpc;
                @Nullable
                private final Boolean $allowAllOutbound;
                @Nullable
                private final String $description;
                @Nullable
                private final String $groupName;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$allowAllOutbound = _allowAllOutbound;
                    this.$description = _description;
                    this.$groupName = _groupName;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getGroupName() {
                    return this.$groupName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    if (this.getAllowAllOutbound() != null) {
                        obj.set("allowAllOutbound", om.valueToTree((Object)this.getAllowAllOutbound()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getGroupName() != null) {
                        obj.set("groupName", om.valueToTree((Object)this.getGroupName()));
                    }
                    return obj;
                }
            };
        }
    }
}

