/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnClientVpnEndpointProps
extends JsiiSerializable {
    public Object getAuthenticationOptions();

    public String getClientCidrBlock();

    public Object getConnectionLogOptions();

    public String getServerCertificateArn();

    public String getDescription();

    public List<String> getDnsServers();

    public Object getTagSpecifications();

    public String getTransportProtocol();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _authenticationOptions;
        private String _clientCidrBlock;
        private Object _connectionLogOptions;
        private String _serverCertificateArn;
        @Nullable
        private String _description;
        @Nullable
        private List<String> _dnsServers;
        @Nullable
        private Object _tagSpecifications;
        @Nullable
        private String _transportProtocol;

        public Builder withAuthenticationOptions(IResolvable value) {
            this._authenticationOptions = Objects.requireNonNull(value, "authenticationOptions is required");
            return this;
        }

        public Builder withAuthenticationOptions(List<Object> value) {
            this._authenticationOptions = Objects.requireNonNull(value, "authenticationOptions is required");
            return this;
        }

        public Builder withClientCidrBlock(String value) {
            this._clientCidrBlock = Objects.requireNonNull(value, "clientCidrBlock is required");
            return this;
        }

        public Builder withConnectionLogOptions(IResolvable value) {
            this._connectionLogOptions = Objects.requireNonNull(value, "connectionLogOptions is required");
            return this;
        }

        public Builder withConnectionLogOptions(CfnClientVpnEndpoint.ConnectionLogOptionsProperty value) {
            this._connectionLogOptions = Objects.requireNonNull(value, "connectionLogOptions is required");
            return this;
        }

        public Builder withServerCertificateArn(String value) {
            this._serverCertificateArn = Objects.requireNonNull(value, "serverCertificateArn is required");
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withDnsServers(@Nullable List<String> value) {
            this._dnsServers = value;
            return this;
        }

        public Builder withTagSpecifications(@Nullable IResolvable value) {
            this._tagSpecifications = value;
            return this;
        }

        public Builder withTagSpecifications(@Nullable List<Object> value) {
            this._tagSpecifications = value;
            return this;
        }

        public Builder withTransportProtocol(@Nullable String value) {
            this._transportProtocol = value;
            return this;
        }

        public CfnClientVpnEndpointProps build() {
            return new CfnClientVpnEndpointProps(){
                private final Object $authenticationOptions;
                private final String $clientCidrBlock;
                private final Object $connectionLogOptions;
                private final String $serverCertificateArn;
                @Nullable
                private final String $description;
                @Nullable
                private final List<String> $dnsServers;
                @Nullable
                private final Object $tagSpecifications;
                @Nullable
                private final String $transportProtocol;
                {
                    this.$authenticationOptions = Objects.requireNonNull(_authenticationOptions, "authenticationOptions is required");
                    this.$clientCidrBlock = Objects.requireNonNull(_clientCidrBlock, "clientCidrBlock is required");
                    this.$connectionLogOptions = Objects.requireNonNull(_connectionLogOptions, "connectionLogOptions is required");
                    this.$serverCertificateArn = Objects.requireNonNull(_serverCertificateArn, "serverCertificateArn is required");
                    this.$description = _description;
                    this.$dnsServers = _dnsServers;
                    this.$tagSpecifications = _tagSpecifications;
                    this.$transportProtocol = _transportProtocol;
                }

                @Override
                public Object getAuthenticationOptions() {
                    return this.$authenticationOptions;
                }

                @Override
                public String getClientCidrBlock() {
                    return this.$clientCidrBlock;
                }

                @Override
                public Object getConnectionLogOptions() {
                    return this.$connectionLogOptions;
                }

                @Override
                public String getServerCertificateArn() {
                    return this.$serverCertificateArn;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public List<String> getDnsServers() {
                    return this.$dnsServers;
                }

                @Override
                public Object getTagSpecifications() {
                    return this.$tagSpecifications;
                }

                @Override
                public String getTransportProtocol() {
                    return this.$transportProtocol;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("authenticationOptions", om.valueToTree(this.getAuthenticationOptions()));
                    obj.set("clientCidrBlock", om.valueToTree((Object)this.getClientCidrBlock()));
                    obj.set("connectionLogOptions", om.valueToTree(this.getConnectionLogOptions()));
                    obj.set("serverCertificateArn", om.valueToTree((Object)this.getServerCertificateArn()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getDnsServers() != null) {
                        obj.set("dnsServers", om.valueToTree(this.getDnsServers()));
                    }
                    if (this.getTagSpecifications() != null) {
                        obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                    }
                    if (this.getTransportProtocol() != null) {
                        obj.set("transportProtocol", om.valueToTree((Object)this.getTransportProtocol()));
                    }
                    return obj;
                }
            };
        }
    }
}

