/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnVPNConnectionProps
extends JsiiSerializable {
    public String getCustomerGatewayId();

    public String getType();

    public Object getStaticRoutesOnly();

    public List<CfnTag> getTags();

    public String getTransitGatewayId();

    public String getVpnGatewayId();

    public Object getVpnTunnelOptionsSpecifications();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _customerGatewayId;
        private String _type;
        @Nullable
        private Object _staticRoutesOnly;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private String _transitGatewayId;
        @Nullable
        private String _vpnGatewayId;
        @Nullable
        private Object _vpnTunnelOptionsSpecifications;

        public Builder withCustomerGatewayId(String value) {
            this._customerGatewayId = Objects.requireNonNull(value, "customerGatewayId is required");
            return this;
        }

        public Builder withType(String value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withStaticRoutesOnly(@Nullable Boolean value) {
            this._staticRoutesOnly = value;
            return this;
        }

        public Builder withStaticRoutesOnly(@Nullable IResolvable value) {
            this._staticRoutesOnly = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withTransitGatewayId(@Nullable String value) {
            this._transitGatewayId = value;
            return this;
        }

        public Builder withVpnGatewayId(@Nullable String value) {
            this._vpnGatewayId = value;
            return this;
        }

        public Builder withVpnTunnelOptionsSpecifications(@Nullable IResolvable value) {
            this._vpnTunnelOptionsSpecifications = value;
            return this;
        }

        public Builder withVpnTunnelOptionsSpecifications(@Nullable List<Object> value) {
            this._vpnTunnelOptionsSpecifications = value;
            return this;
        }

        public CfnVPNConnectionProps build() {
            return new CfnVPNConnectionProps(){
                private final String $customerGatewayId;
                private final String $type;
                @Nullable
                private final Object $staticRoutesOnly;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final String $transitGatewayId;
                @Nullable
                private final String $vpnGatewayId;
                @Nullable
                private final Object $vpnTunnelOptionsSpecifications;
                {
                    this.$customerGatewayId = Objects.requireNonNull(_customerGatewayId, "customerGatewayId is required");
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$staticRoutesOnly = _staticRoutesOnly;
                    this.$tags = _tags;
                    this.$transitGatewayId = _transitGatewayId;
                    this.$vpnGatewayId = _vpnGatewayId;
                    this.$vpnTunnelOptionsSpecifications = _vpnTunnelOptionsSpecifications;
                }

                @Override
                public String getCustomerGatewayId() {
                    return this.$customerGatewayId;
                }

                @Override
                public String getType() {
                    return this.$type;
                }

                @Override
                public Object getStaticRoutesOnly() {
                    return this.$staticRoutesOnly;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public String getTransitGatewayId() {
                    return this.$transitGatewayId;
                }

                @Override
                public String getVpnGatewayId() {
                    return this.$vpnGatewayId;
                }

                @Override
                public Object getVpnTunnelOptionsSpecifications() {
                    return this.$vpnTunnelOptionsSpecifications;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("customerGatewayId", om.valueToTree((Object)this.getCustomerGatewayId()));
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    if (this.getStaticRoutesOnly() != null) {
                        obj.set("staticRoutesOnly", om.valueToTree(this.getStaticRoutesOnly()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getTransitGatewayId() != null) {
                        obj.set("transitGatewayId", om.valueToTree((Object)this.getTransitGatewayId()));
                    }
                    if (this.getVpnGatewayId() != null) {
                        obj.set("vpnGatewayId", om.valueToTree((Object)this.getVpnGatewayId()));
                    }
                    if (this.getVpnTunnelOptionsSpecifications() != null) {
                        obj.set("vpnTunnelOptionsSpecifications", om.valueToTree(this.getVpnTunnelOptionsSpecifications()));
                    }
                    return obj;
                }
            };
        }
    }
}

