package software.amazon.awscdk.services.ec2;

/**
 * Configuration for a machine image.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:05:34.517Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MachineImageConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * The AMI ID of the image to use.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getImageId();
    /**
     * Operating system type for this image.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.OperatingSystemType getOsType();
    /**
     * Initial UserData for this image.
     * 
     * Default: - Default UserData appropriate for the osType is created
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.UserData getUserData();

    /**
     * @return a {@link Builder} of {@link MachineImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MachineImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _imageId;
        private software.amazon.awscdk.services.ec2.OperatingSystemType _osType;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.UserData _userData;

        /**
         * Sets the value of ImageId
         * @param value The AMI ID of the image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withImageId(final java.lang.String value) {
            this._imageId = java.util.Objects.requireNonNull(value, "imageId is required");
            return this;
        }
        /**
         * Sets the value of OsType
         * @param value Operating system type for this image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withOsType(final software.amazon.awscdk.services.ec2.OperatingSystemType value) {
            this._osType = java.util.Objects.requireNonNull(value, "osType is required");
            return this;
        }
        /**
         * Sets the value of UserData
         * @param value Initial UserData for this image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withUserData(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.UserData value) {
            this._userData = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MachineImageConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public MachineImageConfig build() {
            return new MachineImageConfig() {
                private final java.lang.String $imageId = java.util.Objects.requireNonNull(_imageId, "imageId is required");
                private final software.amazon.awscdk.services.ec2.OperatingSystemType $osType = java.util.Objects.requireNonNull(_osType, "osType is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.UserData $userData = _userData;

                @Override
                public java.lang.String getImageId() {
                    return this.$imageId;
                }

                @Override
                public software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
                    return this.$osType;
                }

                @Override
                public software.amazon.awscdk.services.ec2.UserData getUserData() {
                    return this.$userData;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("imageId", om.valueToTree(this.getImageId()));
                    obj.set("osType", om.valueToTree(this.getOsType()));
                    if (this.getUserData() != null) {
                        obj.set("userData", om.valueToTree(this.getUserData()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.MachineImageConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The AMI ID of the image to use.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getImageId() {
            return this.jsiiGet("imageId", java.lang.String.class);
        }

        /**
         * Operating system type for this image.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
            return this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
        }

        /**
         * Initial UserData for this image.
         * 
         * Default: - Default UserData appropriate for the osType is created
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
        }
    }
}
