package software.amazon.awscdk.services.ec2;

/**
 * Properties for looking up an existing VPC.
 * 
 * The combination of properties must specify filter down to exactly one
 * non-default VPC, otherwise an error is raised.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:05:34.533Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcLookupOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to match the default VPC.
     * 
     * Default: Don't care whether we return the default VPC
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getIsDefault();
    /**
     * Tags on the VPC.
     * 
     * The VPC must have all of these tags
     * 
     * Default: Don't filter on tags
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.String> getTags();
    /**
     * The ID of the VPC.
     * 
     * If given, will import exactly this VPC.
     * 
     * Default: Don't filter on vpcId
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getVpcId();
    /**
     * The name of the VPC.
     * 
     * If given, will import the VPC with this name.
     * 
     * Default: Don't filter on vpcName
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getVpcName();

    /**
     * @return a {@link Builder} of {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _isDefault;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _tags;
        @javax.annotation.Nullable
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.lang.String _vpcName;

        /**
         * Sets the value of IsDefault
         * @param value Whether to match the default VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withIsDefault(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._isDefault = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value Tags on the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTags(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._tags = value;
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value The ID of the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcId = value;
            return this;
        }
        /**
         * Sets the value of VpcName
         * @param value The name of the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpcName(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public VpcLookupOptions build() {
            return new VpcLookupOptions() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $isDefault = _isDefault;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $tags = _tags;
                @javax.annotation.Nullable
                private final java.lang.String $vpcId = _vpcId;
                @javax.annotation.Nullable
                private final java.lang.String $vpcName = _vpcName;

                @Override
                public java.lang.Boolean getIsDefault() {
                    return this.$isDefault;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getTags() {
                    return this.$tags;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public java.lang.String getVpcName() {
                    return this.$vpcName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getIsDefault() != null) {
                        obj.set("isDefault", om.valueToTree(this.getIsDefault()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getVpcId() != null) {
                        obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    }
                    if (this.getVpcName() != null) {
                        obj.set("vpcName", om.valueToTree(this.getVpcName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcLookupOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether to match the default VPC.
         * 
         * Default: Don't care whether we return the default VPC
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getIsDefault() {
            return this.jsiiGet("isDefault", java.lang.Boolean.class);
        }

        /**
         * Tags on the VPC.
         * 
         * The VPC must have all of these tags
         * 
         * Default: Don't filter on tags
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.jsiiGet("tags", java.util.Map.class);
        }

        /**
         * The ID of the VPC.
         * 
         * If given, will import exactly this VPC.
         * 
         * Default: Don't filter on vpcId
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * The name of the VPC.
         * 
         * If given, will import the VPC with this name.
         * 
         * Default: Don't filter on vpcName
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getVpcName() {
            return this.jsiiGet("vpcName", java.lang.String.class);
        }
    }
}
