package software.amazon.awscdk.services.ec2;

/**
 * Configuration for Vpc.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:05:34.533Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16. The range will be split evenly into two subnets per Availability Zone (one public, one private).
     * 
     * Default: Vpc.DEFAULT_CIDR_RANGE
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getCidr();
    /**
     * The default tenancy of instances launched into the VPC. By setting this to dedicated tenancy, instances will be launched on hardware dedicated to a single AWS customer, unless specifically specified at instance launch time. Please note, not all instance types are usable with Dedicated tenancy.
     * 
     * Default: DefaultInstanceTenancy.Default (shared) tenancy
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy();
    /**
     * Indicates whether the instances launched in the VPC get public DNS hostnames. If this attribute is true, instances in the VPC get public DNS hostnames, but only if the enableDnsSupport attribute is also set to true.
     * 
     * Default: true
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getEnableDnsHostnames();
    /**
     * Indicates whether the DNS resolution is supported for the VPC.
     * 
     * If this attribute
     * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
     * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
     * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
     * at the base of the VPC IPv4 network range plus two will succeed.
     * 
     * Default: true
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getEnableDnsSupport();
    /**
     * Gateway endpoints to add to this VPC.
     * 
     * Default: - None.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints();
    /**
     * Define the maximum number of AZs to use in this region.
     * 
     * If the region has more AZs than you want to use (for example, because of EIP limits),
     * pick a lower number here. The AZs will be sorted and picked from the start of the list.
     * 
     * If you pick a higher number than the number of AZs in the region, all AZs in
     * the region will be selected. To use "all AZs" available to your account, use a
     * high number (such as 99).
     * 
     * Default: 3
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getMaxAZs();
    /**
     * The number of NAT Gateways to create.
     * 
     * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
     * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
     * 
     * Default: maxAZs
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getNatGateways();
    /**
     * Configures the subnets which will have NAT Gateways.
     * 
     * You can pick a specific group of subnets by specifying the group name;
     * the picked subnets must be public subnets.
     * 
     * Default: - All public subnets.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets();
    /**
     * Configure the subnets to build for each AZ.
     * 
     * The subnets are constructed in the context of the VPC so you only need
     * specify the configuration. The VPC details (VPC ID, specific CIDR,
     * specific AZ will be calculated during creation)
     * 
     * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
     * subnet in each AZ provide the following:
     * subnetConfiguration: [
     *     {
     *       cidrMask: 24,
     *       name: 'ingress',
     *       subnetType: SubnetType.Public,
     *     },
     *     {
     *       cidrMask: 24,
     *       name: 'application',
     *       subnetType: SubnetType.Private,
     *     },
     *     {
     *       cidrMask: 28,
     *       name: 'rds',
     *       subnetType: SubnetType.Isolated,
     *     }
     * ]
     * 
     * `cidrMask` is optional and if not provided the IP space in the VPC will be
     * evenly divided between the requested subnets.
     * 
     * Default: - The VPC CIDR will be evenly divided between 1 public and 1
     * private subnet per AZ.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration();
    /**
     * VPN connections to this VPC.
     * 
     * Default: - No connections.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections();
    /**
     * Indicates whether a VPN gateway should be created and attached to this VPC.
     * 
     * Default: - true when vpnGatewayAsn or vpnConnections is specified.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getVpnGateway();
    /**
     * The private Autonomous System Number (ASN) for the VPN gateway.
     * 
     * Default: - Amazon default ASN.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getVpnGatewayAsn();
    /**
     * Where to propagate VPN routes.
     * 
     * Default: - On the route tables associated with private subnets.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation();

    /**
     * @return a {@link Builder} of {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _cidr;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.DefaultInstanceTenancy _defaultInstanceTenancy;
        @javax.annotation.Nullable
        private java.lang.Boolean _enableDnsHostnames;
        @javax.annotation.Nullable
        private java.lang.Boolean _enableDnsSupport;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> _gatewayEndpoints;
        @javax.annotation.Nullable
        private java.lang.Number _maxAZs;
        @javax.annotation.Nullable
        private java.lang.Number _natGateways;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _natGatewaySubnets;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> _subnetConfiguration;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> _vpnConnections;
        @javax.annotation.Nullable
        private java.lang.Boolean _vpnGateway;
        @javax.annotation.Nullable
        private java.lang.Number _vpnGatewayAsn;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> _vpnRoutePropagation;

        /**
         * Sets the value of Cidr
         * @param value The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16. The range will be split evenly into two subnets per Availability Zone (one public, one private).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCidr(@javax.annotation.Nullable final java.lang.String value) {
            this._cidr = value;
            return this;
        }
        /**
         * Sets the value of DefaultInstanceTenancy
         * @param value The default tenancy of instances launched into the VPC. By setting this to dedicated tenancy, instances will be launched on hardware dedicated to a single AWS customer, unless specifically specified at instance launch time. Please note, not all instance types are usable with Dedicated tenancy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDefaultInstanceTenancy(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy value) {
            this._defaultInstanceTenancy = value;
            return this;
        }
        /**
         * Sets the value of EnableDnsHostnames
         * @param value Indicates whether the instances launched in the VPC get public DNS hostnames. If this attribute is true, instances in the VPC get public DNS hostnames, but only if the enableDnsSupport attribute is also set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnableDnsHostnames(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enableDnsHostnames = value;
            return this;
        }
        /**
         * Sets the value of EnableDnsSupport
         * @param value Indicates whether the DNS resolution is supported for the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnableDnsSupport(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enableDnsSupport = value;
            return this;
        }
        /**
         * Sets the value of GatewayEndpoints
         * @param value Gateway endpoints to add to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withGatewayEndpoints(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> value) {
            this._gatewayEndpoints = value;
            return this;
        }
        /**
         * Sets the value of MaxAZs
         * @param value Define the maximum number of AZs to use in this region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMaxAZs(@javax.annotation.Nullable final java.lang.Number value) {
            this._maxAZs = value;
            return this;
        }
        /**
         * Sets the value of NatGateways
         * @param value The number of NAT Gateways to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withNatGateways(@javax.annotation.Nullable final java.lang.Number value) {
            this._natGateways = value;
            return this;
        }
        /**
         * Sets the value of NatGatewaySubnets
         * @param value Configures the subnets which will have NAT Gateways.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withNatGatewaySubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._natGatewaySubnets = value;
            return this;
        }
        /**
         * Sets the value of SubnetConfiguration
         * @param value Configure the subnets to build for each AZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withSubnetConfiguration(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> value) {
            this._subnetConfiguration = value;
            return this;
        }
        /**
         * Sets the value of VpnConnections
         * @param value VPN connections to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpnConnections(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> value) {
            this._vpnConnections = value;
            return this;
        }
        /**
         * Sets the value of VpnGateway
         * @param value Indicates whether a VPN gateway should be created and attached to this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpnGateway(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._vpnGateway = value;
            return this;
        }
        /**
         * Sets the value of VpnGatewayAsn
         * @param value The private Autonomous System Number (ASN) for the VPN gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpnGatewayAsn(@javax.annotation.Nullable final java.lang.Number value) {
            this._vpnGatewayAsn = value;
            return this;
        }
        /**
         * Sets the value of VpnRoutePropagation
         * @param value Where to propagate VPN routes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpnRoutePropagation(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> value) {
            this._vpnRoutePropagation = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public VpcProps build() {
            return new VpcProps() {
                @javax.annotation.Nullable
                private final java.lang.String $cidr = _cidr;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.DefaultInstanceTenancy $defaultInstanceTenancy = _defaultInstanceTenancy;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enableDnsHostnames = _enableDnsHostnames;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enableDnsSupport = _enableDnsSupport;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> $gatewayEndpoints = _gatewayEndpoints;
                @javax.annotation.Nullable
                private final java.lang.Number $maxAZs = _maxAZs;
                @javax.annotation.Nullable
                private final java.lang.Number $natGateways = _natGateways;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $natGatewaySubnets = _natGatewaySubnets;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> $subnetConfiguration = _subnetConfiguration;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> $vpnConnections = _vpnConnections;
                @javax.annotation.Nullable
                private final java.lang.Boolean $vpnGateway = _vpnGateway;
                @javax.annotation.Nullable
                private final java.lang.Number $vpnGatewayAsn = _vpnGatewayAsn;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> $vpnRoutePropagation = _vpnRoutePropagation;

                @Override
                public java.lang.String getCidr() {
                    return this.$cidr;
                }

                @Override
                public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
                    return this.$defaultInstanceTenancy;
                }

                @Override
                public java.lang.Boolean getEnableDnsHostnames() {
                    return this.$enableDnsHostnames;
                }

                @Override
                public java.lang.Boolean getEnableDnsSupport() {
                    return this.$enableDnsSupport;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints() {
                    return this.$gatewayEndpoints;
                }

                @Override
                public java.lang.Number getMaxAZs() {
                    return this.$maxAZs;
                }

                @Override
                public java.lang.Number getNatGateways() {
                    return this.$natGateways;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets() {
                    return this.$natGatewaySubnets;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
                    return this.$subnetConfiguration;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections() {
                    return this.$vpnConnections;
                }

                @Override
                public java.lang.Boolean getVpnGateway() {
                    return this.$vpnGateway;
                }

                @Override
                public java.lang.Number getVpnGatewayAsn() {
                    return this.$vpnGatewayAsn;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation() {
                    return this.$vpnRoutePropagation;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getCidr() != null) {
                        obj.set("cidr", om.valueToTree(this.getCidr()));
                    }
                    if (this.getDefaultInstanceTenancy() != null) {
                        obj.set("defaultInstanceTenancy", om.valueToTree(this.getDefaultInstanceTenancy()));
                    }
                    if (this.getEnableDnsHostnames() != null) {
                        obj.set("enableDnsHostnames", om.valueToTree(this.getEnableDnsHostnames()));
                    }
                    if (this.getEnableDnsSupport() != null) {
                        obj.set("enableDnsSupport", om.valueToTree(this.getEnableDnsSupport()));
                    }
                    if (this.getGatewayEndpoints() != null) {
                        obj.set("gatewayEndpoints", om.valueToTree(this.getGatewayEndpoints()));
                    }
                    if (this.getMaxAZs() != null) {
                        obj.set("maxAZs", om.valueToTree(this.getMaxAZs()));
                    }
                    if (this.getNatGateways() != null) {
                        obj.set("natGateways", om.valueToTree(this.getNatGateways()));
                    }
                    if (this.getNatGatewaySubnets() != null) {
                        obj.set("natGatewaySubnets", om.valueToTree(this.getNatGatewaySubnets()));
                    }
                    if (this.getSubnetConfiguration() != null) {
                        obj.set("subnetConfiguration", om.valueToTree(this.getSubnetConfiguration()));
                    }
                    if (this.getVpnConnections() != null) {
                        obj.set("vpnConnections", om.valueToTree(this.getVpnConnections()));
                    }
                    if (this.getVpnGateway() != null) {
                        obj.set("vpnGateway", om.valueToTree(this.getVpnGateway()));
                    }
                    if (this.getVpnGatewayAsn() != null) {
                        obj.set("vpnGatewayAsn", om.valueToTree(this.getVpnGatewayAsn()));
                    }
                    if (this.getVpnRoutePropagation() != null) {
                        obj.set("vpnRoutePropagation", om.valueToTree(this.getVpnRoutePropagation()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CIDR range to use for the VPC (e.g. '10.0.0.0/16'). Should be a minimum of /28 and maximum size of /16. The range will be split evenly into two subnets per Availability Zone (one public, one private).
         * 
         * Default: Vpc.DEFAULT_CIDR_RANGE
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getCidr() {
            return this.jsiiGet("cidr", java.lang.String.class);
        }

        /**
         * The default tenancy of instances launched into the VPC. By setting this to dedicated tenancy, instances will be launched on hardware dedicated to a single AWS customer, unless specifically specified at instance launch time. Please note, not all instance types are usable with Dedicated tenancy.
         * 
         * Default: DefaultInstanceTenancy.Default (shared) tenancy
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.DefaultInstanceTenancy getDefaultInstanceTenancy() {
            return this.jsiiGet("defaultInstanceTenancy", software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class);
        }

        /**
         * Indicates whether the instances launched in the VPC get public DNS hostnames. If this attribute is true, instances in the VPC get public DNS hostnames, but only if the enableDnsSupport attribute is also set to true.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableDnsHostnames() {
            return this.jsiiGet("enableDnsHostnames", java.lang.Boolean.class);
        }

        /**
         * Indicates whether the DNS resolution is supported for the VPC.
         * 
         * If this attribute
         * is false, the Amazon-provided DNS server in the VPC that resolves public DNS hostnames
         * to IP addresses is not enabled. If this attribute is true, queries to the Amazon
         * provided DNS server at the 169.254.169.253 IP address, or the reserved IP address
         * at the base of the VPC IPv4 network range plus two will succeed.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableDnsSupport() {
            return this.jsiiGet("enableDnsSupport", java.lang.Boolean.class);
        }

        /**
         * Gateway endpoints to add to this VPC.
         * 
         * Default: - None.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions> getGatewayEndpoints() {
            return this.jsiiGet("gatewayEndpoints", java.util.Map.class);
        }

        /**
         * Define the maximum number of AZs to use in this region.
         * 
         * If the region has more AZs than you want to use (for example, because of EIP limits),
         * pick a lower number here. The AZs will be sorted and picked from the start of the list.
         * 
         * If you pick a higher number than the number of AZs in the region, all AZs in
         * the region will be selected. To use "all AZs" available to your account, use a
         * high number (such as 99).
         * 
         * Default: 3
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getMaxAZs() {
            return this.jsiiGet("maxAZs", java.lang.Number.class);
        }

        /**
         * The number of NAT Gateways to create.
         * 
         * For example, if set this to 1 and your subnet configuration is for 3 Public subnets then only
         * one of the Public subnets will have a gateway and all Private subnets will route to this NAT Gateway.
         * 
         * Default: maxAZs
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getNatGateways() {
            return this.jsiiGet("natGateways", java.lang.Number.class);
        }

        /**
         * Configures the subnets which will have NAT Gateways.
         * 
         * You can pick a specific group of subnets by specifying the group name;
         * the picked subnets must be public subnets.
         * 
         * Default: - All public subnets.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getNatGatewaySubnets() {
            return this.jsiiGet("natGatewaySubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Configure the subnets to build for each AZ.
         * 
         * The subnets are constructed in the context of the VPC so you only need
         * specify the configuration. The VPC details (VPC ID, specific CIDR,
         * specific AZ will be calculated during creation)
         * 
         * For example if you want 1 public subnet, 1 private subnet, and 1 isolated
         * subnet in each AZ provide the following:
         * subnetConfiguration: [
         *     {
         *       cidrMask: 24,
         *       name: 'ingress',
         *       subnetType: SubnetType.Public,
         *     },
         *     {
         *       cidrMask: 24,
         *       name: 'application',
         *       subnetType: SubnetType.Private,
         *     },
         *     {
         *       cidrMask: 28,
         *       name: 'rds',
         *       subnetType: SubnetType.Isolated,
         *     }
         * ]
         * 
         * `cidrMask` is optional and if not provided the IP space in the VPC will be
         * evenly divided between the requested subnets.
         * 
         * Default: - The VPC CIDR will be evenly divided between 1 public and 1
         * private subnet per AZ.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> getSubnetConfiguration() {
            return this.jsiiGet("subnetConfiguration", java.util.List.class);
        }

        /**
         * VPN connections to this VPC.
         * 
         * Default: - No connections.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ec2.VpnConnectionOptions> getVpnConnections() {
            return this.jsiiGet("vpnConnections", java.util.Map.class);
        }

        /**
         * Indicates whether a VPN gateway should be created and attached to this VPC.
         * 
         * Default: - true when vpnGatewayAsn or vpnConnections is specified.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getVpnGateway() {
            return this.jsiiGet("vpnGateway", java.lang.Boolean.class);
        }

        /**
         * The private Autonomous System Number (ASN) for the VPN gateway.
         * 
         * Default: - Amazon default ASN.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getVpnGatewayAsn() {
            return this.jsiiGet("vpnGatewayAsn", java.lang.Number.class);
        }

        /**
         * Where to propagate VPN routes.
         * 
         * Default: - On the route tables associated with private subnets.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpnRoutePropagation() {
            return this.jsiiGet("vpnRoutePropagation", java.util.List.class);
        }
    }
}
