/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnClientVpnEndpoint")
public class CfnClientVpnEndpoint
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnClientVpnEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnClientVpnEndpoint(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public CfnClientVpnEndpoint(Construct scope, String id, CfnClientVpnEndpointProps props) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return (Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    protected Map<String, Object> getCfnProperties() {
        return (Map)this.jsiiGet("cfnProperties", Map.class);
    }

    public Object getAuthenticationOptions() {
        return this.jsiiGet("authenticationOptions", Object.class);
    }

    public void setAuthenticationOptions(IResolvable value) {
        this.jsiiSet("authenticationOptions", Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    public void setAuthenticationOptions(List<Object> value) {
        this.jsiiSet("authenticationOptions", Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    public String getClientCidrBlock() {
        return (String)this.jsiiGet("clientCidrBlock", String.class);
    }

    public void setClientCidrBlock(String value) {
        this.jsiiSet("clientCidrBlock", Objects.requireNonNull(value, "clientCidrBlock is required"));
    }

    public Object getConnectionLogOptions() {
        return this.jsiiGet("connectionLogOptions", Object.class);
    }

    public void setConnectionLogOptions(IResolvable value) {
        this.jsiiSet("connectionLogOptions", Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    public void setConnectionLogOptions(ConnectionLogOptionsProperty value) {
        this.jsiiSet("connectionLogOptions", Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    public String getServerCertificateArn() {
        return (String)this.jsiiGet("serverCertificateArn", String.class);
    }

    public void setServerCertificateArn(String value) {
        this.jsiiSet("serverCertificateArn", Objects.requireNonNull(value, "serverCertificateArn is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public List<String> getDnsServers() {
        return (List)this.jsiiGet("dnsServers", List.class);
    }

    public void setDnsServers(@Nullable List<String> value) {
        this.jsiiSet("dnsServers", value);
    }

    @Nullable
    public Object getTagSpecifications() {
        return this.jsiiGet("tagSpecifications", Object.class);
    }

    public void setTagSpecifications(@Nullable IResolvable value) {
        this.jsiiSet("tagSpecifications", value);
    }

    public void setTagSpecifications(@Nullable List<Object> value) {
        this.jsiiSet("tagSpecifications", value);
    }

    @Nullable
    public String getTransportProtocol() {
        return (String)this.jsiiGet("transportProtocol", String.class);
    }

    public void setTransportProtocol(@Nullable String value) {
        this.jsiiSet("transportProtocol", value);
    }

    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public List<CfnTag> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private String _resourceType;
            @Nullable
            private List<CfnTag> _tags;

            public Builder withResourceType(@Nullable String value) {
                this._resourceType = value;
                return this;
            }

            public Builder withTags(@Nullable List<CfnTag> value) {
                this._tags = value;
                return this;
            }

            public TagSpecificationProperty build() {
                return new TagSpecificationProperty(){
                    @Nullable
                    private final String $resourceType;
                    @Nullable
                    private final List<CfnTag> $tags;
                    {
                        this.$resourceType = _resourceType;
                        this.$tags = _tags;
                    }

                    @Override
                    public String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public List<CfnTag> getTags() {
                        return this.$tags;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        if (this.getResourceType() != null) {
                            obj.set("resourceType", om.valueToTree((Object)this.getResourceType()));
                        }
                        if (this.getTags() != null) {
                            obj.set("tags", om.valueToTree(this.getTags()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface DirectoryServiceAuthenticationRequestProperty
    extends JsiiSerializable {
        public String getDirectoryId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _directoryId;

            public Builder withDirectoryId(String value) {
                this._directoryId = Objects.requireNonNull(value, "directoryId is required");
                return this;
            }

            public DirectoryServiceAuthenticationRequestProperty build() {
                return new DirectoryServiceAuthenticationRequestProperty(){
                    private final String $directoryId;
                    {
                        this.$directoryId = Objects.requireNonNull(_directoryId, "directoryId is required");
                    }

                    @Override
                    public String getDirectoryId() {
                        return this.$directoryId;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("directoryId", om.valueToTree((Object)this.getDirectoryId()));
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ConnectionLogOptionsProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public String getCloudwatchLogGroup();

        public String getCloudwatchLogStream();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _enabled;
            @Nullable
            private String _cloudwatchLogGroup;
            @Nullable
            private String _cloudwatchLogStream;

            public Builder withEnabled(Boolean value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withEnabled(IResolvable value) {
                this._enabled = Objects.requireNonNull(value, "enabled is required");
                return this;
            }

            public Builder withCloudwatchLogGroup(@Nullable String value) {
                this._cloudwatchLogGroup = value;
                return this;
            }

            public Builder withCloudwatchLogStream(@Nullable String value) {
                this._cloudwatchLogStream = value;
                return this;
            }

            public ConnectionLogOptionsProperty build() {
                return new ConnectionLogOptionsProperty(){
                    private final Object $enabled;
                    @Nullable
                    private final String $cloudwatchLogGroup;
                    @Nullable
                    private final String $cloudwatchLogStream;
                    {
                        this.$enabled = Objects.requireNonNull(_enabled, "enabled is required");
                        this.$cloudwatchLogGroup = _cloudwatchLogGroup;
                        this.$cloudwatchLogStream = _cloudwatchLogStream;
                    }

                    @Override
                    public Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public String getCloudwatchLogGroup() {
                        return this.$cloudwatchLogGroup;
                    }

                    @Override
                    public String getCloudwatchLogStream() {
                        return this.$cloudwatchLogStream;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        if (this.getCloudwatchLogGroup() != null) {
                            obj.set("cloudwatchLogGroup", om.valueToTree((Object)this.getCloudwatchLogGroup()));
                        }
                        if (this.getCloudwatchLogStream() != null) {
                            obj.set("cloudwatchLogStream", om.valueToTree((Object)this.getCloudwatchLogStream()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface ClientAuthenticationRequestProperty
    extends JsiiSerializable {
        public String getType();

        public Object getActiveDirectory();

        public Object getMutualAuthentication();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _type;
            @Nullable
            private Object _activeDirectory;
            @Nullable
            private Object _mutualAuthentication;

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withActiveDirectory(@Nullable IResolvable value) {
                this._activeDirectory = value;
                return this;
            }

            public Builder withActiveDirectory(@Nullable DirectoryServiceAuthenticationRequestProperty value) {
                this._activeDirectory = value;
                return this;
            }

            public Builder withMutualAuthentication(@Nullable IResolvable value) {
                this._mutualAuthentication = value;
                return this;
            }

            public Builder withMutualAuthentication(@Nullable CertificateAuthenticationRequestProperty value) {
                this._mutualAuthentication = value;
                return this;
            }

            public ClientAuthenticationRequestProperty build() {
                return new ClientAuthenticationRequestProperty(){
                    private final String $type;
                    @Nullable
                    private final Object $activeDirectory;
                    @Nullable
                    private final Object $mutualAuthentication;
                    {
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$activeDirectory = _activeDirectory;
                        this.$mutualAuthentication = _mutualAuthentication;
                    }

                    @Override
                    public String getType() {
                        return this.$type;
                    }

                    @Override
                    public Object getActiveDirectory() {
                        return this.$activeDirectory;
                    }

                    @Override
                    public Object getMutualAuthentication() {
                        return this.$mutualAuthentication;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree((Object)this.getType()));
                        if (this.getActiveDirectory() != null) {
                            obj.set("activeDirectory", om.valueToTree(this.getActiveDirectory()));
                        }
                        if (this.getMutualAuthentication() != null) {
                            obj.set("mutualAuthentication", om.valueToTree(this.getMutualAuthentication()));
                        }
                        return obj;
                    }
                };
            }
        }
    }

    public static interface CertificateAuthenticationRequestProperty
    extends JsiiSerializable {
        public String getClientRootCertificateChainArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String _clientRootCertificateChainArn;

            public Builder withClientRootCertificateChainArn(String value) {
                this._clientRootCertificateChainArn = Objects.requireNonNull(value, "clientRootCertificateChainArn is required");
                return this;
            }

            public CertificateAuthenticationRequestProperty build() {
                return new CertificateAuthenticationRequestProperty(){
                    private final String $clientRootCertificateChainArn;
                    {
                        this.$clientRootCertificateChainArn = Objects.requireNonNull(_clientRootCertificateChainArn, "clientRootCertificateChainArn is required");
                    }

                    @Override
                    public String getClientRootCertificateChainArn() {
                        return this.$clientRootCertificateChainArn;
                    }

                    public JsonNode $jsii$toJson() {
                        ObjectMapper om = JsiiObjectMapper.INSTANCE;
                        ObjectNode obj = JsonNodeFactory.instance.objectNode();
                        obj.set("clientRootCertificateChainArn", om.valueToTree((Object)this.getClientRootCertificateChainArn()));
                        return obj;
                    }
                };
            }
        }
    }
}

