/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnSubnetProps
extends JsiiSerializable {
    public String getCidrBlock();

    public String getVpcId();

    public Object getAssignIpv6AddressOnCreation();

    public String getAvailabilityZone();

    public String getIpv6CidrBlock();

    public Object getMapPublicIpOnLaunch();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _cidrBlock;
        private String _vpcId;
        @Nullable
        private Object _assignIpv6AddressOnCreation;
        @Nullable
        private String _availabilityZone;
        @Nullable
        private String _ipv6CidrBlock;
        @Nullable
        private Object _mapPublicIpOnLaunch;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withCidrBlock(String value) {
            this._cidrBlock = Objects.requireNonNull(value, "cidrBlock is required");
            return this;
        }

        public Builder withVpcId(String value) {
            this._vpcId = Objects.requireNonNull(value, "vpcId is required");
            return this;
        }

        public Builder withAssignIpv6AddressOnCreation(@Nullable Boolean value) {
            this._assignIpv6AddressOnCreation = value;
            return this;
        }

        public Builder withAssignIpv6AddressOnCreation(@Nullable IResolvable value) {
            this._assignIpv6AddressOnCreation = value;
            return this;
        }

        public Builder withAvailabilityZone(@Nullable String value) {
            this._availabilityZone = value;
            return this;
        }

        public Builder withIpv6CidrBlock(@Nullable String value) {
            this._ipv6CidrBlock = value;
            return this;
        }

        public Builder withMapPublicIpOnLaunch(@Nullable Boolean value) {
            this._mapPublicIpOnLaunch = value;
            return this;
        }

        public Builder withMapPublicIpOnLaunch(@Nullable IResolvable value) {
            this._mapPublicIpOnLaunch = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnSubnetProps build() {
            return new CfnSubnetProps(){
                private final String $cidrBlock;
                private final String $vpcId;
                @Nullable
                private final Object $assignIpv6AddressOnCreation;
                @Nullable
                private final String $availabilityZone;
                @Nullable
                private final String $ipv6CidrBlock;
                @Nullable
                private final Object $mapPublicIpOnLaunch;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$cidrBlock = Objects.requireNonNull(_cidrBlock, "cidrBlock is required");
                    this.$vpcId = Objects.requireNonNull(_vpcId, "vpcId is required");
                    this.$assignIpv6AddressOnCreation = _assignIpv6AddressOnCreation;
                    this.$availabilityZone = _availabilityZone;
                    this.$ipv6CidrBlock = _ipv6CidrBlock;
                    this.$mapPublicIpOnLaunch = _mapPublicIpOnLaunch;
                    this.$tags = _tags;
                }

                @Override
                public String getCidrBlock() {
                    return this.$cidrBlock;
                }

                @Override
                public String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public Object getAssignIpv6AddressOnCreation() {
                    return this.$assignIpv6AddressOnCreation;
                }

                @Override
                public String getAvailabilityZone() {
                    return this.$availabilityZone;
                }

                @Override
                public String getIpv6CidrBlock() {
                    return this.$ipv6CidrBlock;
                }

                @Override
                public Object getMapPublicIpOnLaunch() {
                    return this.$mapPublicIpOnLaunch;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("cidrBlock", om.valueToTree((Object)this.getCidrBlock()));
                    obj.set("vpcId", om.valueToTree((Object)this.getVpcId()));
                    if (this.getAssignIpv6AddressOnCreation() != null) {
                        obj.set("assignIpv6AddressOnCreation", om.valueToTree(this.getAssignIpv6AddressOnCreation()));
                    }
                    if (this.getAvailabilityZone() != null) {
                        obj.set("availabilityZone", om.valueToTree((Object)this.getAvailabilityZone()));
                    }
                    if (this.getIpv6CidrBlock() != null) {
                        obj.set("ipv6CidrBlock", om.valueToTree((Object)this.getIpv6CidrBlock()));
                    }
                    if (this.getMapPublicIpOnLaunch() != null) {
                        obj.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

