package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SpotFleet`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:12:28.595Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleet")
public class CfnSpotFleet extends software.amazon.awscdk.core.CfnResource {
    protected CfnSpotFleet(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSpotFleet.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::SpotFleet`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSpotFleet(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnSpotFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object getSpotFleetRequestConfigData() {
        return this.jsiiGet("spotFleetRequestConfigData", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotFleetRequestConfigData(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotFleetRequestConfigData(final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty value) {
        this.jsiiSet("spotFleetRequestConfigData", java.util.Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getDeviceName();
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEbs();
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getNoDevice();
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getVirtualName();

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.String _noDevice;
            @javax.annotation.Nullable
            private java.lang.String _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDeviceName(final java.lang.String value) {
                this._deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNoDevice(@javax.annotation.Nullable final java.lang.String value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    private final java.lang.String $deviceName = java.util.Objects.requireNonNull(_deviceName, "deviceName is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private final java.lang.String $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private final java.lang.String $virtualName = _virtualName;

                    @Override
                    public java.lang.String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public java.lang.String getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public java.lang.String getVirtualName() {
                        return this.$virtualName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deviceName", om.valueToTree(this.getDeviceName()));
                        if (this.getEbs() != null) {
                            obj.set("ebs", om.valueToTree(this.getEbs()));
                        }
                        if (this.getNoDevice() != null) {
                            obj.set("noDevice", om.valueToTree(this.getNoDevice()));
                        }
                        if (this.getVirtualName() != null) {
                            obj.set("virtualName", om.valueToTree(this.getVirtualName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassicLoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClassicLoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ClassicLoadBalancerProperty build() {
                return new ClassicLoadBalancerProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancerProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassicLoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getClassicLoadBalancers();

        /**
         * @return a {@link Builder} of {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClassicLoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _classicLoadBalancers;

            /**
             * Sets the value of ClassicLoadBalancers
             * @param value `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withClassicLoadBalancers(final software.amazon.awscdk.core.IResolvable value) {
                this._classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }
            /**
             * Sets the value of ClassicLoadBalancers
             * @param value `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withClassicLoadBalancers(final java.util.List<java.lang.Object> value) {
                this._classicLoadBalancers = java.util.Objects.requireNonNull(value, "classicLoadBalancers is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassicLoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ClassicLoadBalancersConfigProperty build() {
                return new ClassicLoadBalancersConfigProperty() {
                    private final java.lang.Object $classicLoadBalancers = java.util.Objects.requireNonNull(_classicLoadBalancers, "classicLoadBalancers is required");

                    @Override
                    public java.lang.Object getClassicLoadBalancers() {
                        return this.$classicLoadBalancers;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("classicLoadBalancers", om.valueToTree(this.getClassicLoadBalancers()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getClassicLoadBalancers() {
                return this.jsiiGet("classicLoadBalancers", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsBlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEncrypted();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getIops();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSnapshotId();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getVolumeSize();
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getVolumeType();

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsBlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Number _iops;
            @javax.annotation.Nullable
            private java.lang.String _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Number _volumeSize;
            @javax.annotation.Nullable
            private java.lang.String _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public EbsBlockDeviceProperty build() {
                return new EbsBlockDeviceProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Number $iops = _iops;
                    @javax.annotation.Nullable
                    private final java.lang.String $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private final java.lang.Number $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private final java.lang.String $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public java.lang.Number getIops() {
                        return this.$iops;
                    }

                    @Override
                    public java.lang.String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public java.lang.Number getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public java.lang.String getVolumeType() {
                        return this.$volumeType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDeleteOnTermination() != null) {
                            obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        }
                        if (this.getEncrypted() != null) {
                            obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                        }
                        if (this.getIops() != null) {
                            obj.set("iops", om.valueToTree(this.getIops()));
                        }
                        if (this.getSnapshotId() != null) {
                            obj.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                        }
                        if (this.getVolumeSize() != null) {
                            obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                        }
                        if (this.getVolumeType() != null) {
                            obj.set("volumeType", om.valueToTree(this.getVolumeType()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getIops() {
                return this.jsiiGet("iops", java.lang.Number.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Number.class);
            }

            /**
             * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getVersion();
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getLaunchTemplateId();
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getLaunchTemplateName();

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FleetLaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _version;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateId;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateName;

            /**
             * Sets the value of Version
             * @param value `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withVersion(final java.lang.String value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of LaunchTemplateId
             * @param value `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public FleetLaunchTemplateSpecificationProperty build() {
                return new FleetLaunchTemplateSpecificationProperty() {
                    private final java.lang.String $version = java.util.Objects.requireNonNull(_version, "version is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateId = _launchTemplateId;
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateName = _launchTemplateName;

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("version", om.valueToTree(this.getVersion()));
                        if (this.getLaunchTemplateId() != null) {
                            obj.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                        }
                        if (this.getLaunchTemplateName() != null) {
                            obj.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupIdentifierProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getGroupId();

        /**
         * @return a {@link Builder} of {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GroupIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _groupId;

            /**
             * Sets the value of GroupId
             * @param value `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withGroupId(final java.lang.String value) {
                this._groupId = java.util.Objects.requireNonNull(value, "groupId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public GroupIdentifierProperty build() {
                return new GroupIdentifierProperty() {
                    private final java.lang.String $groupId = java.util.Objects.requireNonNull(_groupId, "groupId is required");

                    @Override
                    public java.lang.String getGroupId() {
                        return this.$groupId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("groupId", om.valueToTree(this.getGroupId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.GroupIdentifierProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.GroupIdentifierProperty.GroupId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getGroupId() {
                return this.jsiiGet("groupId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamInstanceProfileSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IamInstanceProfileSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _arn;

            /**
             * Sets the value of Arn
             * @param value `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withArn(@javax.annotation.Nullable final java.lang.String value) {
                this._arn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamInstanceProfileSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public IamInstanceProfileSpecificationProperty build() {
                return new IamInstanceProfileSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $arn = _arn;

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getArn() != null) {
                            obj.set("arn", om.valueToTree(this.getArn()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIpv6Address(final java.lang.String value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty() {
                    private final java.lang.String $ipv6Address = java.util.Objects.requireNonNull(_ipv6Address, "ipv6Address is required");

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceNetworkInterfaceSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getDescription();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getDeviceIndex();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<java.lang.String> getGroups();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getIpv6AddressCount();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getIpv6Addresses();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getNetworkInterfaceId();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getPrivateIpAddresses();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getSecondaryPrivateIpAddressCount();
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceNetworkInterfaceSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Number _deviceIndex;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _groups;
            @javax.annotation.Nullable
            private java.lang.Number _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.String _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Number _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;

            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of DeviceIndex
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withDeviceIndex(@javax.annotation.Nullable final java.lang.Number value) {
                this._deviceIndex = value;
                return this;
            }
            /**
             * Sets the value of Groups
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._groups = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceNetworkInterfaceSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new InstanceNetworkInterfaceSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.Number $deviceIndex = _deviceIndex;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $groups = _groups;
                    @javax.annotation.Nullable
                    private final java.lang.Number $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private final java.lang.Number $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.Number getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public java.util.List<java.lang.String> getGroups() {
                        return this.$groups;
                    }

                    @Override
                    public java.lang.Number getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public java.lang.String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public java.lang.Number getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getAssociatePublicIpAddress() != null) {
                            obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                        }
                        if (this.getDeleteOnTermination() != null) {
                            obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        }
                        if (this.getDescription() != null) {
                            obj.set("description", om.valueToTree(this.getDescription()));
                        }
                        if (this.getDeviceIndex() != null) {
                            obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                        }
                        if (this.getGroups() != null) {
                            obj.set("groups", om.valueToTree(this.getGroups()));
                        }
                        if (this.getIpv6AddressCount() != null) {
                            obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                        }
                        if (this.getIpv6Addresses() != null) {
                            obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                        }
                        if (this.getNetworkInterfaceId() != null) {
                            obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                        }
                        if (this.getPrivateIpAddresses() != null) {
                            obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                        }
                        if (this.getSecondaryPrivateIpAddressCount() != null) {
                            obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                        }
                        if (this.getSubnetId() != null) {
                            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.Number.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getGroups() {
                return this.jsiiGet("groups", java.util.List.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
            }

            /**
             * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getLaunchTemplateSpecification();
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getOverrides();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateSpecification;
            @javax.annotation.Nullable
            private java.lang.Object _overrides;

            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateSpecification
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchTemplateSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty value) {
                this._launchTemplateSpecification = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOverrides(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._overrides = value;
                return this;
            }
            /**
             * Sets the value of Overrides
             * @param value `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOverrides(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._overrides = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public LaunchTemplateConfigProperty build() {
                return new LaunchTemplateConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchTemplateSpecification = _launchTemplateSpecification;
                    @javax.annotation.Nullable
                    private final java.lang.Object $overrides = _overrides;

                    @Override
                    public java.lang.Object getLaunchTemplateSpecification() {
                        return this.$launchTemplateSpecification;
                    }

                    @Override
                    public java.lang.Object getOverrides() {
                        return this.$overrides;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getLaunchTemplateSpecification() != null) {
                            obj.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                        }
                        if (this.getOverrides() != null) {
                            obj.set("overrides", om.valueToTree(this.getOverrides()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateSpecification() {
                return this.jsiiGet("launchTemplateSpecification", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getOverrides() {
                return this.jsiiGet("overrides", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchTemplateOverridesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getAvailabilityZone();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getInstanceType();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSpotPrice();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSubnetId();
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getWeightedCapacity();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Number _weightedCapacity;

            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInstanceType(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceType = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public LaunchTemplateOverridesProperty build() {
                return new LaunchTemplateOverridesProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceType = _instanceType;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private final java.lang.Number $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public java.lang.Number getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getAvailabilityZone() != null) {
                            obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        }
                        if (this.getInstanceType() != null) {
                            obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        }
                        if (this.getSpotPrice() != null) {
                            obj.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                        }
                        if (this.getSubnetId() != null) {
                            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        }
                        if (this.getWeightedCapacity() != null) {
                            obj.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateOverridesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancersConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getClassicLoadBalancersConfig();
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTargetGroupsConfig();

        /**
         * @return a {@link Builder} of {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _classicLoadBalancersConfig;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupsConfig;

            /**
             * Sets the value of ClassicLoadBalancersConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of ClassicLoadBalancersConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withClassicLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty value) {
                this._classicLoadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupsConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._targetGroupsConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupsConfig
             * @param value `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTargetGroupsConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty value) {
                this._targetGroupsConfig = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public LoadBalancersConfigProperty build() {
                return new LoadBalancersConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $classicLoadBalancersConfig = _classicLoadBalancersConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $targetGroupsConfig = _targetGroupsConfig;

                    @Override
                    public java.lang.Object getClassicLoadBalancersConfig() {
                        return this.$classicLoadBalancersConfig;
                    }

                    @Override
                    public java.lang.Object getTargetGroupsConfig() {
                        return this.$targetGroupsConfig;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getClassicLoadBalancersConfig() != null) {
                            obj.set("classicLoadBalancersConfig", om.valueToTree(this.getClassicLoadBalancersConfig()));
                        }
                        if (this.getTargetGroupsConfig() != null) {
                            obj.set("targetGroupsConfig", om.valueToTree(this.getTargetGroupsConfig()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getClassicLoadBalancersConfig() {
                return this.jsiiGet("classicLoadBalancersConfig", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupsConfig() {
                return this.jsiiGet("targetGroupsConfig", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPrivateIpAddress();
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getPrimary();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _primary;

            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrimary(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._primary = value;
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPrimary(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._primary = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty() {
                    private final java.lang.String $privateIpAddress = java.util.Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $primary = _primary;

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        if (this.getPrimary() != null) {
                            obj.set("primary", om.valueToTree(this.getPrimary()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetLaunchSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getImageId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getInstanceType();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getBlockDeviceMappings();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEbsOptimized();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getIamInstanceProfile();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getKernelId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getKeyName();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getMonitoring();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getNetworkInterfaces();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getPlacement();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRamdiskId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getSecurityGroups();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSpotPrice();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSubnetId();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTagSpecifications();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getUserData();
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getWeightedCapacity();

        /**
         * @return a {@link Builder} of {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetLaunchSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _imageId;
            private java.lang.String _instanceType;
            @javax.annotation.Nullable
            private java.lang.Object _blockDeviceMappings;
            @javax.annotation.Nullable
            private java.lang.Object _ebsOptimized;
            @javax.annotation.Nullable
            private java.lang.Object _iamInstanceProfile;
            @javax.annotation.Nullable
            private java.lang.String _kernelId;
            @javax.annotation.Nullable
            private java.lang.String _keyName;
            @javax.annotation.Nullable
            private java.lang.Object _monitoring;
            @javax.annotation.Nullable
            private java.lang.Object _networkInterfaces;
            @javax.annotation.Nullable
            private java.lang.Object _placement;
            @javax.annotation.Nullable
            private java.lang.String _ramdiskId;
            @javax.annotation.Nullable
            private java.lang.Object _securityGroups;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;
            @javax.annotation.Nullable
            private java.lang.Object _tagSpecifications;
            @javax.annotation.Nullable
            private java.lang.String _userData;
            @javax.annotation.Nullable
            private java.lang.Number _weightedCapacity;

            /**
             * Sets the value of ImageId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withImageId(final java.lang.String value) {
                this._imageId = java.util.Objects.requireNonNull(value, "imageId is required");
                return this;
            }
            /**
             * Sets the value of InstanceType
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInstanceType(final java.lang.String value) {
                this._instanceType = java.util.Objects.requireNonNull(value, "instanceType is required");
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of BlockDeviceMappings
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._blockDeviceMappings = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of EbsOptimized
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ebsOptimized = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of IamInstanceProfile
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIamInstanceProfile(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty value) {
                this._iamInstanceProfile = value;
                return this;
            }
            /**
             * Sets the value of KernelId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKernelId(@javax.annotation.Nullable final java.lang.String value) {
                this._kernelId = value;
                return this;
            }
            /**
             * Sets the value of KeyName
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKeyName(@javax.annotation.Nullable final java.lang.String value) {
                this._keyName = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of Monitoring
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty value) {
                this._monitoring = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaces
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._networkInterfaces = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of Placement
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty value) {
                this._placement = value;
                return this;
            }
            /**
             * Sets the value of RamdiskId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
                this._ramdiskId = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSecurityGroups(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroups
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._securityGroups = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of TagSpecifications
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTagSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._tagSpecifications = value;
                return this;
            }
            /**
             * Sets the value of UserData
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withUserData(@javax.annotation.Nullable final java.lang.String value) {
                this._userData = value;
                return this;
            }
            /**
             * Sets the value of WeightedCapacity
             * @param value `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withWeightedCapacity(@javax.annotation.Nullable final java.lang.Number value) {
                this._weightedCapacity = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetLaunchSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SpotFleetLaunchSpecificationProperty build() {
                return new SpotFleetLaunchSpecificationProperty() {
                    private final java.lang.String $imageId = java.util.Objects.requireNonNull(_imageId, "imageId is required");
                    private final java.lang.String $instanceType = java.util.Objects.requireNonNull(_instanceType, "instanceType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $blockDeviceMappings = _blockDeviceMappings;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebsOptimized = _ebsOptimized;
                    @javax.annotation.Nullable
                    private final java.lang.Object $iamInstanceProfile = _iamInstanceProfile;
                    @javax.annotation.Nullable
                    private final java.lang.String $kernelId = _kernelId;
                    @javax.annotation.Nullable
                    private final java.lang.String $keyName = _keyName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $monitoring = _monitoring;
                    @javax.annotation.Nullable
                    private final java.lang.Object $networkInterfaces = _networkInterfaces;
                    @javax.annotation.Nullable
                    private final java.lang.Object $placement = _placement;
                    @javax.annotation.Nullable
                    private final java.lang.String $ramdiskId = _ramdiskId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $securityGroups = _securityGroups;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $tagSpecifications = _tagSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.String $userData = _userData;
                    @javax.annotation.Nullable
                    private final java.lang.Number $weightedCapacity = _weightedCapacity;

                    @Override
                    public java.lang.String getImageId() {
                        return this.$imageId;
                    }

                    @Override
                    public java.lang.String getInstanceType() {
                        return this.$instanceType;
                    }

                    @Override
                    public java.lang.Object getBlockDeviceMappings() {
                        return this.$blockDeviceMappings;
                    }

                    @Override
                    public java.lang.Object getEbsOptimized() {
                        return this.$ebsOptimized;
                    }

                    @Override
                    public java.lang.Object getIamInstanceProfile() {
                        return this.$iamInstanceProfile;
                    }

                    @Override
                    public java.lang.String getKernelId() {
                        return this.$kernelId;
                    }

                    @Override
                    public java.lang.String getKeyName() {
                        return this.$keyName;
                    }

                    @Override
                    public java.lang.Object getMonitoring() {
                        return this.$monitoring;
                    }

                    @Override
                    public java.lang.Object getNetworkInterfaces() {
                        return this.$networkInterfaces;
                    }

                    @Override
                    public java.lang.Object getPlacement() {
                        return this.$placement;
                    }

                    @Override
                    public java.lang.String getRamdiskId() {
                        return this.$ramdiskId;
                    }

                    @Override
                    public java.lang.Object getSecurityGroups() {
                        return this.$securityGroups;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    @Override
                    public java.lang.Object getTagSpecifications() {
                        return this.$tagSpecifications;
                    }

                    @Override
                    public java.lang.String getUserData() {
                        return this.$userData;
                    }

                    @Override
                    public java.lang.Number getWeightedCapacity() {
                        return this.$weightedCapacity;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("imageId", om.valueToTree(this.getImageId()));
                        obj.set("instanceType", om.valueToTree(this.getInstanceType()));
                        if (this.getBlockDeviceMappings() != null) {
                            obj.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
                        }
                        if (this.getEbsOptimized() != null) {
                            obj.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                        }
                        if (this.getIamInstanceProfile() != null) {
                            obj.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
                        }
                        if (this.getKernelId() != null) {
                            obj.set("kernelId", om.valueToTree(this.getKernelId()));
                        }
                        if (this.getKeyName() != null) {
                            obj.set("keyName", om.valueToTree(this.getKeyName()));
                        }
                        if (this.getMonitoring() != null) {
                            obj.set("monitoring", om.valueToTree(this.getMonitoring()));
                        }
                        if (this.getNetworkInterfaces() != null) {
                            obj.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                        }
                        if (this.getPlacement() != null) {
                            obj.set("placement", om.valueToTree(this.getPlacement()));
                        }
                        if (this.getRamdiskId() != null) {
                            obj.set("ramdiskId", om.valueToTree(this.getRamdiskId()));
                        }
                        if (this.getSecurityGroups() != null) {
                            obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                        }
                        if (this.getSpotPrice() != null) {
                            obj.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                        }
                        if (this.getSubnetId() != null) {
                            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        }
                        if (this.getTagSpecifications() != null) {
                            obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                        }
                        if (this.getUserData() != null) {
                            obj.set("userData", om.valueToTree(this.getUserData()));
                        }
                        if (this.getWeightedCapacity() != null) {
                            obj.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getImageId() {
                return this.jsiiGet("imageId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getInstanceType() {
                return this.jsiiGet("instanceType", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getBlockDeviceMappings() {
                return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getEbsOptimized() {
                return this.jsiiGet("ebsOptimized", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getIamInstanceProfile() {
                return this.jsiiGet("iamInstanceProfile", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getKernelId() {
                return this.jsiiGet("kernelId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getKeyName() {
                return this.jsiiGet("keyName", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getMonitoring() {
                return this.jsiiGet("monitoring", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getNetworkInterfaces() {
                return this.jsiiGet("networkInterfaces", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getPlacement() {
                return this.jsiiGet("placement", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getRamdiskId() {
                return this.jsiiGet("ramdiskId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroups() {
                return this.jsiiGet("securityGroups", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTagSpecifications() {
                return this.jsiiGet("tagSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getUserData() {
                return this.jsiiGet("userData", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getWeightedCapacity() {
                return this.jsiiGet("weightedCapacity", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetMonitoringProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;

            /**
             * Sets the value of Enabled
             * @param value `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._enabled = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetMonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SpotFleetMonitoringProperty build() {
                return new SpotFleetMonitoringProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getEnabled() != null) {
                            obj.set("enabled", om.valueToTree(this.getEnabled()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetRequestConfigDataProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getIamFleetRole();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getTargetCapacity();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getAllocationStrategy();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getExcessCapacityTerminationPolicy();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getInstanceInterruptionBehavior();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getLaunchSpecifications();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getLaunchTemplateConfigs();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getLoadBalancersConfig();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getReplaceUnhealthyInstances();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSpotPrice();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTerminateInstancesWithExpiration();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getType();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getValidFrom();
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getValidUntil();

        /**
         * @return a {@link Builder} of {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetRequestConfigDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _iamFleetRole;
            private java.lang.Number _targetCapacity;
            @javax.annotation.Nullable
            private java.lang.String _allocationStrategy;
            @javax.annotation.Nullable
            private java.lang.String _excessCapacityTerminationPolicy;
            @javax.annotation.Nullable
            private java.lang.String _instanceInterruptionBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _launchSpecifications;
            @javax.annotation.Nullable
            private java.lang.Object _launchTemplateConfigs;
            @javax.annotation.Nullable
            private java.lang.Object _loadBalancersConfig;
            @javax.annotation.Nullable
            private java.lang.Object _replaceUnhealthyInstances;
            @javax.annotation.Nullable
            private java.lang.String _spotPrice;
            @javax.annotation.Nullable
            private java.lang.Object _terminateInstancesWithExpiration;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _validFrom;
            @javax.annotation.Nullable
            private java.lang.String _validUntil;

            /**
             * Sets the value of IamFleetRole
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withIamFleetRole(final java.lang.String value) {
                this._iamFleetRole = java.util.Objects.requireNonNull(value, "iamFleetRole is required");
                return this;
            }
            /**
             * Sets the value of TargetCapacity
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTargetCapacity(final java.lang.Number value) {
                this._targetCapacity = java.util.Objects.requireNonNull(value, "targetCapacity is required");
                return this;
            }
            /**
             * Sets the value of AllocationStrategy
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAllocationStrategy(@javax.annotation.Nullable final java.lang.String value) {
                this._allocationStrategy = value;
                return this;
            }
            /**
             * Sets the value of ExcessCapacityTerminationPolicy
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withExcessCapacityTerminationPolicy(@javax.annotation.Nullable final java.lang.String value) {
                this._excessCapacityTerminationPolicy = value;
                return this;
            }
            /**
             * Sets the value of InstanceInterruptionBehavior
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInstanceInterruptionBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._instanceInterruptionBehavior = value;
                return this;
            }
            /**
             * Sets the value of LaunchSpecifications
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._launchSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LaunchSpecifications
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._launchSpecifications = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateConfigs
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchTemplateConfigs(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._launchTemplateConfigs = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateConfigs
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLaunchTemplateConfigs(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._launchTemplateConfigs = value;
                return this;
            }
            /**
             * Sets the value of LoadBalancersConfig
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._loadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of LoadBalancersConfig
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLoadBalancersConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty value) {
                this._loadBalancersConfig = value;
                return this;
            }
            /**
             * Sets the value of ReplaceUnhealthyInstances
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReplaceUnhealthyInstances(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }
            /**
             * Sets the value of ReplaceUnhealthyInstances
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReplaceUnhealthyInstances(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._replaceUnhealthyInstances = value;
                return this;
            }
            /**
             * Sets the value of SpotPrice
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSpotPrice(@javax.annotation.Nullable final java.lang.String value) {
                this._spotPrice = value;
                return this;
            }
            /**
             * Sets the value of TerminateInstancesWithExpiration
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTerminateInstancesWithExpiration(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }
            /**
             * Sets the value of TerminateInstancesWithExpiration
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTerminateInstancesWithExpiration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._terminateInstancesWithExpiration = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of ValidFrom
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValidFrom(@javax.annotation.Nullable final java.lang.String value) {
                this._validFrom = value;
                return this;
            }
            /**
             * Sets the value of ValidUntil
             * @param value `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValidUntil(@javax.annotation.Nullable final java.lang.String value) {
                this._validUntil = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetRequestConfigDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SpotFleetRequestConfigDataProperty build() {
                return new SpotFleetRequestConfigDataProperty() {
                    private final java.lang.String $iamFleetRole = java.util.Objects.requireNonNull(_iamFleetRole, "iamFleetRole is required");
                    private final java.lang.Number $targetCapacity = java.util.Objects.requireNonNull(_targetCapacity, "targetCapacity is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $allocationStrategy = _allocationStrategy;
                    @javax.annotation.Nullable
                    private final java.lang.String $excessCapacityTerminationPolicy = _excessCapacityTerminationPolicy;
                    @javax.annotation.Nullable
                    private final java.lang.String $instanceInterruptionBehavior = _instanceInterruptionBehavior;
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchSpecifications = _launchSpecifications;
                    @javax.annotation.Nullable
                    private final java.lang.Object $launchTemplateConfigs = _launchTemplateConfigs;
                    @javax.annotation.Nullable
                    private final java.lang.Object $loadBalancersConfig = _loadBalancersConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $replaceUnhealthyInstances = _replaceUnhealthyInstances;
                    @javax.annotation.Nullable
                    private final java.lang.String $spotPrice = _spotPrice;
                    @javax.annotation.Nullable
                    private final java.lang.Object $terminateInstancesWithExpiration = _terminateInstancesWithExpiration;
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private final java.lang.String $validFrom = _validFrom;
                    @javax.annotation.Nullable
                    private final java.lang.String $validUntil = _validUntil;

                    @Override
                    public java.lang.String getIamFleetRole() {
                        return this.$iamFleetRole;
                    }

                    @Override
                    public java.lang.Number getTargetCapacity() {
                        return this.$targetCapacity;
                    }

                    @Override
                    public java.lang.String getAllocationStrategy() {
                        return this.$allocationStrategy;
                    }

                    @Override
                    public java.lang.String getExcessCapacityTerminationPolicy() {
                        return this.$excessCapacityTerminationPolicy;
                    }

                    @Override
                    public java.lang.String getInstanceInterruptionBehavior() {
                        return this.$instanceInterruptionBehavior;
                    }

                    @Override
                    public java.lang.Object getLaunchSpecifications() {
                        return this.$launchSpecifications;
                    }

                    @Override
                    public java.lang.Object getLaunchTemplateConfigs() {
                        return this.$launchTemplateConfigs;
                    }

                    @Override
                    public java.lang.Object getLoadBalancersConfig() {
                        return this.$loadBalancersConfig;
                    }

                    @Override
                    public java.lang.Object getReplaceUnhealthyInstances() {
                        return this.$replaceUnhealthyInstances;
                    }

                    @Override
                    public java.lang.String getSpotPrice() {
                        return this.$spotPrice;
                    }

                    @Override
                    public java.lang.Object getTerminateInstancesWithExpiration() {
                        return this.$terminateInstancesWithExpiration;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.String getValidFrom() {
                        return this.$validFrom;
                    }

                    @Override
                    public java.lang.String getValidUntil() {
                        return this.$validUntil;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("iamFleetRole", om.valueToTree(this.getIamFleetRole()));
                        obj.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                        if (this.getAllocationStrategy() != null) {
                            obj.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                        }
                        if (this.getExcessCapacityTerminationPolicy() != null) {
                            obj.set("excessCapacityTerminationPolicy", om.valueToTree(this.getExcessCapacityTerminationPolicy()));
                        }
                        if (this.getInstanceInterruptionBehavior() != null) {
                            obj.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                        }
                        if (this.getLaunchSpecifications() != null) {
                            obj.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                        }
                        if (this.getLaunchTemplateConfigs() != null) {
                            obj.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
                        }
                        if (this.getLoadBalancersConfig() != null) {
                            obj.set("loadBalancersConfig", om.valueToTree(this.getLoadBalancersConfig()));
                        }
                        if (this.getReplaceUnhealthyInstances() != null) {
                            obj.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
                        }
                        if (this.getSpotPrice() != null) {
                            obj.set("spotPrice", om.valueToTree(this.getSpotPrice()));
                        }
                        if (this.getTerminateInstancesWithExpiration() != null) {
                            obj.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
                        }
                        if (this.getType() != null) {
                            obj.set("type", om.valueToTree(this.getType()));
                        }
                        if (this.getValidFrom() != null) {
                            obj.set("validFrom", om.valueToTree(this.getValidFrom()));
                        }
                        if (this.getValidUntil() != null) {
                            obj.set("validUntil", om.valueToTree(this.getValidUntil()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getIamFleetRole() {
                return this.jsiiGet("iamFleetRole", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Number getTargetCapacity() {
                return this.jsiiGet("targetCapacity", java.lang.Number.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getAllocationStrategy() {
                return this.jsiiGet("allocationStrategy", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getExcessCapacityTerminationPolicy() {
                return this.jsiiGet("excessCapacityTerminationPolicy", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getInstanceInterruptionBehavior() {
                return this.jsiiGet("instanceInterruptionBehavior", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getLaunchSpecifications() {
                return this.jsiiGet("launchSpecifications", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getLaunchTemplateConfigs() {
                return this.jsiiGet("launchTemplateConfigs", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getLoadBalancersConfig() {
                return this.jsiiGet("loadBalancersConfig", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getReplaceUnhealthyInstances() {
                return this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getSpotPrice() {
                return this.jsiiGet("spotPrice", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getTerminateInstancesWithExpiration() {
                return this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getValidFrom() {
                return this.jsiiGet("validFrom", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getValidUntil() {
                return this.jsiiGet("validUntil", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotFleetTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceType();
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotFleetTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _resourceType;
            @javax.annotation.Nullable
            private java.util.List<software.amazon.awscdk.core.CfnTag> _tags;

            /**
             * Sets the value of ResourceType
             * @param value `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceType(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceType = value;
                return this;
            }
            /**
             * Sets the value of Tags
             * @param value `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.core.CfnTag> value) {
                this._tags = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotFleetTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SpotFleetTagSpecificationProperty build() {
                return new SpotFleetTagSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceType = _resourceType;
                    @javax.annotation.Nullable
                    private final java.util.List<software.amazon.awscdk.core.CfnTag> $tags = _tags;

                    @Override
                    public java.lang.String getResourceType() {
                        return this.$resourceType;
                    }

                    @Override
                    public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                        return this.$tags;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getResourceType() != null) {
                            obj.set("resourceType", om.valueToTree(this.getResourceType()));
                        }
                        if (this.getTags() != null) {
                            obj.set("tags", om.valueToTree(this.getTags()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getResourceType() {
                return this.jsiiGet("resourceType", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.jsiiGet("tags", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotPlacementProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getAvailabilityZone();
        /**
         * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getGroupName();
        /**
         * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTenancy();

        /**
         * @return a {@link Builder} of {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SpotPlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _availabilityZone;
            @javax.annotation.Nullable
            private java.lang.String _groupName;
            @javax.annotation.Nullable
            private java.lang.String _tenancy;

            /**
             * Sets the value of AvailabilityZone
             * @param value `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
                this._availabilityZone = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value `CfnSpotFleet.SpotPlacementProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of Tenancy
             * @param value `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTenancy(@javax.annotation.Nullable final java.lang.String value) {
                this._tenancy = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotPlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SpotPlacementProperty build() {
                return new SpotPlacementProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $availabilityZone = _availabilityZone;
                    @javax.annotation.Nullable
                    private final java.lang.String $groupName = _groupName;
                    @javax.annotation.Nullable
                    private final java.lang.String $tenancy = _tenancy;

                    @Override
                    public java.lang.String getAvailabilityZone() {
                        return this.$availabilityZone;
                    }

                    @Override
                    public java.lang.String getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public java.lang.String getTenancy() {
                        return this.$tenancy;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getAvailabilityZone() != null) {
                            obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                        }
                        if (this.getGroupName() != null) {
                            obj.set("groupName", om.valueToTree(this.getGroupName()));
                        }
                        if (this.getTenancy() != null) {
                            obj.set("tenancy", om.valueToTree(this.getTenancy()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getAvailabilityZone() {
                return this.jsiiGet("availabilityZone", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotPlacementProperty.GroupName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getGroupName() {
                return this.jsiiGet("groupName", java.lang.String.class);
            }

            /**
             * `CfnSpotFleet.SpotPlacementProperty.Tenancy`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getTenancy() {
                return this.jsiiGet("tenancy", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.TargetGroupProperty.Arn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _arn;

            /**
             * Sets the value of Arn
             * @param value `CfnSpotFleet.TargetGroupProperty.Arn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withArn(final java.lang.String value) {
                this._arn = java.util.Objects.requireNonNull(value, "arn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public TargetGroupProperty build() {
                return new TargetGroupProperty() {
                    private final java.lang.String $arn = java.util.Objects.requireNonNull(_arn, "arn is required");

                    @Override
                    public java.lang.String getArn() {
                        return this.$arn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("arn", om.valueToTree(this.getArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.TargetGroupProperty.Arn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getArn() {
                return this.jsiiGet("arn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupsConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getTargetGroups();

        /**
         * @return a {@link Builder} of {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _targetGroups;

            /**
             * Sets the value of TargetGroups
             * @param value `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTargetGroups(final software.amazon.awscdk.core.IResolvable value) {
                this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }
            /**
             * Sets the value of TargetGroups
             * @param value `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTargetGroups(final java.util.List<java.lang.Object> value) {
                this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public TargetGroupsConfigProperty build() {
                return new TargetGroupsConfigProperty() {
                    private final java.lang.Object $targetGroups = java.util.Objects.requireNonNull(_targetGroups, "targetGroups is required");

                    @Override
                    public java.lang.Object getTargetGroups() {
                        return this.$targetGroups;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getTargetGroups() {
                return this.jsiiGet("targetGroups", java.lang.Object.class);
            }
        }
    }
}
