package software.amazon.awscdk.services.ec2;

/**
 * Properties to intialize a new Connections object.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:12:28.639Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Default port range for initiating connections to and from this object.
     * 
     * Default: - No default port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.Port getDefaultPort();
    /**
     * Class that represents the rule by which others can connect to this connectable.
     * 
     * This object is required, but will be derived from securityGroup if that is passed.
     * 
     * Default: Derived from securityGroup if set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IPeer getPeer();
    /**
     * What securityGroup(s) this object is managing connections for.
     * 
     * Default: No security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * @return a {@link Builder} of {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.Port _defaultPort;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.IPeer _peer;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> _securityGroups;

        /**
         * Sets the value of DefaultPort
         * @param value Default port range for initiating connections to and from this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDefaultPort(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.Port value) {
            this._defaultPort = value;
            return this;
        }
        /**
         * Sets the value of Peer
         * @param value Class that represents the rule by which others can connect to this connectable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPeer(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPeer value) {
            this._peer = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroups
         * @param value What securityGroup(s) this object is managing connections for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSecurityGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> value) {
            this._securityGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ConnectionsProps build() {
            return new ConnectionsProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.Port $defaultPort = _defaultPort;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.IPeer $peer = _peer;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> $securityGroups = _securityGroups;

                @Override
                public software.amazon.awscdk.services.ec2.Port getDefaultPort() {
                    return this.$defaultPort;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IPeer getPeer() {
                    return this.$peer;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
                    return this.$securityGroups;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDefaultPort() != null) {
                        obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
                    }
                    if (this.getPeer() != null) {
                        obj.set("peer", om.valueToTree(this.getPeer()));
                    }
                    if (this.getSecurityGroups() != null) {
                        obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ConnectionsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Default port range for initiating connections to and from this object.
         * 
         * Default: - No default port
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.Port getDefaultPort() {
            return this.jsiiGet("defaultPort", software.amazon.awscdk.services.ec2.Port.class);
        }

        /**
         * Class that represents the rule by which others can connect to this connectable.
         * 
         * This object is required, but will be derived from securityGroup if that is passed.
         * 
         * Default: Derived from securityGroup if set.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.IPeer getPeer() {
            return this.jsiiGet("peer", software.amazon.awscdk.services.ec2.IPeer.class);
        }

        /**
         * What securityGroup(s) this object is managing connections for.
         * 
         * Default: No security groups
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.jsiiGet("securityGroups", java.util.List.class);
        }
    }
}
