package software.amazon.awscdk.services.ec2;

/**
 * Properties that reference an external VpcNetwork.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:12:28.653Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * List of availability zones for the subnets in this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAvailabilityZones();
    /**
     * VPC's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpcId();
    /**
     * List of isolated subnet IDs.
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIsolatedSubnetIds();
    /**
     * List of names for the isolated subnets.
     * 
     * Must be undefined or have a name for every isolated subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getIsolatedSubnetNames();
    /**
     * List of private subnet IDs.
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPrivateSubnetIds();
    /**
     * List of names for the private subnets.
     * 
     * Must be undefined or have a name for every private subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPrivateSubnetNames();
    /**
     * List of public subnet IDs.
     * 
     * Must be undefined or match the availability zones in length and order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPublicSubnetIds();
    /**
     * List of names for the public subnets.
     * 
     * Must be undefined or have a name for every public subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getPublicSubnetNames();
    /**
     * VPN gateway's identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpnGatewayId();

    /**
     * @return a {@link Builder} of {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<java.lang.String> _availabilityZones;
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _isolatedSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _isolatedSubnetNames;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _privateSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _privateSubnetNames;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _publicSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _publicSubnetNames;
        @javax.annotation.Nullable
        private java.lang.String _vpnGatewayId;

        /**
         * Sets the value of AvailabilityZones
         * @param value List of availability zones for the subnets in this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAvailabilityZones(final java.util.List<java.lang.String> value) {
            this._availabilityZones = java.util.Objects.requireNonNull(value, "availabilityZones is required");
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value VPC's identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpcId(final java.lang.String value) {
            this._vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
            return this;
        }
        /**
         * Sets the value of IsolatedSubnetIds
         * @param value List of isolated subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIsolatedSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._isolatedSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of IsolatedSubnetNames
         * @param value List of names for the isolated subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIsolatedSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._isolatedSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of PrivateSubnetIds
         * @param value List of private subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrivateSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._privateSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of PrivateSubnetNames
         * @param value List of names for the private subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPrivateSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._privateSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of PublicSubnetIds
         * @param value List of public subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPublicSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._publicSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of PublicSubnetNames
         * @param value List of names for the public subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPublicSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._publicSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of VpnGatewayId
         * @param value VPN gateway's identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpnGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpnGatewayId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpcAttributes build() {
            return new VpcAttributes() {
                private final java.util.List<java.lang.String> $availabilityZones = java.util.Objects.requireNonNull(_availabilityZones, "availabilityZones is required");
                private final java.lang.String $vpcId = java.util.Objects.requireNonNull(_vpcId, "vpcId is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $isolatedSubnetIds = _isolatedSubnetIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $isolatedSubnetNames = _isolatedSubnetNames;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $privateSubnetIds = _privateSubnetIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $privateSubnetNames = _privateSubnetNames;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $publicSubnetIds = _publicSubnetIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $publicSubnetNames = _publicSubnetNames;
                @javax.annotation.Nullable
                private final java.lang.String $vpnGatewayId = _vpnGatewayId;

                @Override
                public java.util.List<java.lang.String> getAvailabilityZones() {
                    return this.$availabilityZones;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public java.util.List<java.lang.String> getIsolatedSubnetIds() {
                    return this.$isolatedSubnetIds;
                }

                @Override
                public java.util.List<java.lang.String> getIsolatedSubnetNames() {
                    return this.$isolatedSubnetNames;
                }

                @Override
                public java.util.List<java.lang.String> getPrivateSubnetIds() {
                    return this.$privateSubnetIds;
                }

                @Override
                public java.util.List<java.lang.String> getPrivateSubnetNames() {
                    return this.$privateSubnetNames;
                }

                @Override
                public java.util.List<java.lang.String> getPublicSubnetIds() {
                    return this.$publicSubnetIds;
                }

                @Override
                public java.util.List<java.lang.String> getPublicSubnetNames() {
                    return this.$publicSubnetNames;
                }

                @Override
                public java.lang.String getVpnGatewayId() {
                    return this.$vpnGatewayId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                    obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    if (this.getIsolatedSubnetIds() != null) {
                        obj.set("isolatedSubnetIds", om.valueToTree(this.getIsolatedSubnetIds()));
                    }
                    if (this.getIsolatedSubnetNames() != null) {
                        obj.set("isolatedSubnetNames", om.valueToTree(this.getIsolatedSubnetNames()));
                    }
                    if (this.getPrivateSubnetIds() != null) {
                        obj.set("privateSubnetIds", om.valueToTree(this.getPrivateSubnetIds()));
                    }
                    if (this.getPrivateSubnetNames() != null) {
                        obj.set("privateSubnetNames", om.valueToTree(this.getPrivateSubnetNames()));
                    }
                    if (this.getPublicSubnetIds() != null) {
                        obj.set("publicSubnetIds", om.valueToTree(this.getPublicSubnetIds()));
                    }
                    if (this.getPublicSubnetNames() != null) {
                        obj.set("publicSubnetNames", om.valueToTree(this.getPublicSubnetNames()));
                    }
                    if (this.getVpnGatewayId() != null) {
                        obj.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpcAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * List of availability zones for the subnets in this VPC.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * VPC's identifier.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * List of isolated subnet IDs.
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIsolatedSubnetIds() {
            return this.jsiiGet("isolatedSubnetIds", java.util.List.class);
        }

        /**
         * List of names for the isolated subnets.
         * 
         * Must be undefined or have a name for every isolated subnet group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIsolatedSubnetNames() {
            return this.jsiiGet("isolatedSubnetNames", java.util.List.class);
        }

        /**
         * List of private subnet IDs.
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPrivateSubnetIds() {
            return this.jsiiGet("privateSubnetIds", java.util.List.class);
        }

        /**
         * List of names for the private subnets.
         * 
         * Must be undefined or have a name for every private subnet group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPrivateSubnetNames() {
            return this.jsiiGet("privateSubnetNames", java.util.List.class);
        }

        /**
         * List of public subnet IDs.
         * 
         * Must be undefined or match the availability zones in length and order.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPublicSubnetIds() {
            return this.jsiiGet("publicSubnetIds", java.util.List.class);
        }

        /**
         * List of names for the public subnets.
         * 
         * Must be undefined or have a name for every public subnet group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPublicSubnetNames() {
            return this.jsiiGet("publicSubnetNames", java.util.List.class);
        }

        /**
         * VPN gateway's identifier.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getVpnGatewayId() {
            return this.jsiiGet("vpnGatewayId", java.lang.String.class);
        }
    }
}
