/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnRouteProps
extends JsiiSerializable {
    public String getRouteTableId();

    public String getDestinationCidrBlock();

    public String getDestinationIpv6CidrBlock();

    public String getEgressOnlyInternetGatewayId();

    public String getGatewayId();

    public String getInstanceId();

    public String getNatGatewayId();

    public String getNetworkInterfaceId();

    public String getTransitGatewayId();

    public String getVpcPeeringConnectionId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _routeTableId;
        @Nullable
        private String _destinationCidrBlock;
        @Nullable
        private String _destinationIpv6CidrBlock;
        @Nullable
        private String _egressOnlyInternetGatewayId;
        @Nullable
        private String _gatewayId;
        @Nullable
        private String _instanceId;
        @Nullable
        private String _natGatewayId;
        @Nullable
        private String _networkInterfaceId;
        @Nullable
        private String _transitGatewayId;
        @Nullable
        private String _vpcPeeringConnectionId;

        public Builder withRouteTableId(String value) {
            this._routeTableId = Objects.requireNonNull(value, "routeTableId is required");
            return this;
        }

        public Builder withDestinationCidrBlock(@Nullable String value) {
            this._destinationCidrBlock = value;
            return this;
        }

        public Builder withDestinationIpv6CidrBlock(@Nullable String value) {
            this._destinationIpv6CidrBlock = value;
            return this;
        }

        public Builder withEgressOnlyInternetGatewayId(@Nullable String value) {
            this._egressOnlyInternetGatewayId = value;
            return this;
        }

        public Builder withGatewayId(@Nullable String value) {
            this._gatewayId = value;
            return this;
        }

        public Builder withInstanceId(@Nullable String value) {
            this._instanceId = value;
            return this;
        }

        public Builder withNatGatewayId(@Nullable String value) {
            this._natGatewayId = value;
            return this;
        }

        public Builder withNetworkInterfaceId(@Nullable String value) {
            this._networkInterfaceId = value;
            return this;
        }

        public Builder withTransitGatewayId(@Nullable String value) {
            this._transitGatewayId = value;
            return this;
        }

        public Builder withVpcPeeringConnectionId(@Nullable String value) {
            this._vpcPeeringConnectionId = value;
            return this;
        }

        public CfnRouteProps build() {
            return new CfnRouteProps(){
                private final String $routeTableId;
                @Nullable
                private final String $destinationCidrBlock;
                @Nullable
                private final String $destinationIpv6CidrBlock;
                @Nullable
                private final String $egressOnlyInternetGatewayId;
                @Nullable
                private final String $gatewayId;
                @Nullable
                private final String $instanceId;
                @Nullable
                private final String $natGatewayId;
                @Nullable
                private final String $networkInterfaceId;
                @Nullable
                private final String $transitGatewayId;
                @Nullable
                private final String $vpcPeeringConnectionId;
                {
                    this.$routeTableId = Objects.requireNonNull(_routeTableId, "routeTableId is required");
                    this.$destinationCidrBlock = _destinationCidrBlock;
                    this.$destinationIpv6CidrBlock = _destinationIpv6CidrBlock;
                    this.$egressOnlyInternetGatewayId = _egressOnlyInternetGatewayId;
                    this.$gatewayId = _gatewayId;
                    this.$instanceId = _instanceId;
                    this.$natGatewayId = _natGatewayId;
                    this.$networkInterfaceId = _networkInterfaceId;
                    this.$transitGatewayId = _transitGatewayId;
                    this.$vpcPeeringConnectionId = _vpcPeeringConnectionId;
                }

                @Override
                public String getRouteTableId() {
                    return this.$routeTableId;
                }

                @Override
                public String getDestinationCidrBlock() {
                    return this.$destinationCidrBlock;
                }

                @Override
                public String getDestinationIpv6CidrBlock() {
                    return this.$destinationIpv6CidrBlock;
                }

                @Override
                public String getEgressOnlyInternetGatewayId() {
                    return this.$egressOnlyInternetGatewayId;
                }

                @Override
                public String getGatewayId() {
                    return this.$gatewayId;
                }

                @Override
                public String getInstanceId() {
                    return this.$instanceId;
                }

                @Override
                public String getNatGatewayId() {
                    return this.$natGatewayId;
                }

                @Override
                public String getNetworkInterfaceId() {
                    return this.$networkInterfaceId;
                }

                @Override
                public String getTransitGatewayId() {
                    return this.$transitGatewayId;
                }

                @Override
                public String getVpcPeeringConnectionId() {
                    return this.$vpcPeeringConnectionId;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("routeTableId", om.valueToTree((Object)this.getRouteTableId()));
                    if (this.getDestinationCidrBlock() != null) {
                        obj.set("destinationCidrBlock", om.valueToTree((Object)this.getDestinationCidrBlock()));
                    }
                    if (this.getDestinationIpv6CidrBlock() != null) {
                        obj.set("destinationIpv6CidrBlock", om.valueToTree((Object)this.getDestinationIpv6CidrBlock()));
                    }
                    if (this.getEgressOnlyInternetGatewayId() != null) {
                        obj.set("egressOnlyInternetGatewayId", om.valueToTree((Object)this.getEgressOnlyInternetGatewayId()));
                    }
                    if (this.getGatewayId() != null) {
                        obj.set("gatewayId", om.valueToTree((Object)this.getGatewayId()));
                    }
                    if (this.getInstanceId() != null) {
                        obj.set("instanceId", om.valueToTree((Object)this.getInstanceId()));
                    }
                    if (this.getNatGatewayId() != null) {
                        obj.set("natGatewayId", om.valueToTree((Object)this.getNatGatewayId()));
                    }
                    if (this.getNetworkInterfaceId() != null) {
                        obj.set("networkInterfaceId", om.valueToTree((Object)this.getNetworkInterfaceId()));
                    }
                    if (this.getTransitGatewayId() != null) {
                        obj.set("transitGatewayId", om.valueToTree((Object)this.getTransitGatewayId()));
                    }
                    if (this.getVpcPeeringConnectionId() != null) {
                        obj.set("vpcPeeringConnectionId", om.valueToTree((Object)this.getVpcPeeringConnectionId()));
                    }
                    return obj;
                }
            };
        }
    }
}

