package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for a GatewayVpcEndpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:30:18.143Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayVpcEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions {
    /**
     * The VPC network in which the gateway endpoint will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link GatewayVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link GatewayVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.ec2.IVpc _vpc;
        private software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService _service;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> _subnets;

        /**
         * Sets the value of Vpc
         * @param value The VPC network in which the gateway endpoint will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpc value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of Service
         * @param value The service to use for this gateway VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withService(final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of Subnets
         * @param value Where to add endpoint routing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubnets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> value) {
            this._subnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayVpcEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public GatewayVpcEndpointProps build() {
            return new GatewayVpcEndpointProps() {
                private final software.amazon.awscdk.services.ec2.IVpc $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                private final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> $subnets = _subnets;

                @Override
                public software.amazon.awscdk.services.ec2.IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
                    return this.$service;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
                    return this.$subnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("service", om.valueToTree(this.getService()));
                    if (this.getSubnets() != null) {
                        obj.set("subnets", om.valueToTree(this.getSubnets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.GatewayVpcEndpointProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC network in which the gateway endpoint will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * The service to use for this gateway VPC endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
            return this.jsiiGet("service", software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService.class);
        }

        /**
         * Where to add endpoint routing.
         * 
         * Default: private subnets
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
            return this.jsiiGet("subnets", java.util.List.class);
        }
    }
}
