package software.amazon.awscdk.services.ec2;

/**
 * Properties to create a port range.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:06:12.036Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The protocol for the range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.Protocol getProtocol();
    /**
     * String representation for this object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getStringRepresentation();
    /**
     * The starting port for the range.
     * 
     * Default: - Not included in the rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getFromPort();
    /**
     * The ending port for the range.
     * 
     * Default: - Not included in the rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getToPort();

    /**
     * @return a {@link Builder} of {@link PortProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PortProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.ec2.Protocol _protocol;
        private java.lang.String _stringRepresentation;
        @javax.annotation.Nullable
        private java.lang.Number _fromPort;
        @javax.annotation.Nullable
        private java.lang.Number _toPort;

        /**
         * Sets the value of Protocol
         * @param value The protocol for the range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(final software.amazon.awscdk.services.ec2.Protocol value) {
            this._protocol = java.util.Objects.requireNonNull(value, "protocol is required");
            return this;
        }
        /**
         * Sets the value of StringRepresentation
         * @param value String representation for this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStringRepresentation(final java.lang.String value) {
            this._stringRepresentation = java.util.Objects.requireNonNull(value, "stringRepresentation is required");
            return this;
        }
        /**
         * Sets the value of FromPort
         * @param value The starting port for the range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFromPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._fromPort = value;
            return this;
        }
        /**
         * Sets the value of ToPort
         * @param value The ending port for the range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withToPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._toPort = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public PortProps build() {
            return new PortProps() {
                private final software.amazon.awscdk.services.ec2.Protocol $protocol = java.util.Objects.requireNonNull(_protocol, "protocol is required");
                private final java.lang.String $stringRepresentation = java.util.Objects.requireNonNull(_stringRepresentation, "stringRepresentation is required");
                @javax.annotation.Nullable
                private final java.lang.Number $fromPort = _fromPort;
                @javax.annotation.Nullable
                private final java.lang.Number $toPort = _toPort;

                @Override
                public software.amazon.awscdk.services.ec2.Protocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public java.lang.String getStringRepresentation() {
                    return this.$stringRepresentation;
                }

                @Override
                public java.lang.Number getFromPort() {
                    return this.$fromPort;
                }

                @Override
                public java.lang.Number getToPort() {
                    return this.$toPort;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("protocol", om.valueToTree(this.getProtocol()));
                    obj.set("stringRepresentation", om.valueToTree(this.getStringRepresentation()));
                    if (this.getFromPort() != null) {
                        obj.set("fromPort", om.valueToTree(this.getFromPort()));
                    }
                    if (this.getToPort() != null) {
                        obj.set("toPort", om.valueToTree(this.getToPort()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.PortProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The protocol for the range.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.Protocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.ec2.Protocol.class);
        }

        /**
         * String representation for this object.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getStringRepresentation() {
            return this.jsiiGet("stringRepresentation", java.lang.String.class);
        }

        /**
         * The starting port for the range.
         * 
         * Default: - Not included in the rule
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getFromPort() {
            return this.jsiiGet("fromPort", java.lang.Number.class);
        }

        /**
         * The ending port for the range.
         * 
         * Default: - Not included in the rule
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getToPort() {
            return this.jsiiGet("toPort", java.lang.Number.class);
        }
    }
}
