package software.amazon.awscdk.services.ec2;

/**
 * Result of selecting a subset of subnets from a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:06:12.039Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SelectedSubnets extends software.amazon.jsii.JsiiSerializable {
    /**
     * The respective AZs of each subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getAvailabilityZones();
    /**
     * Whether any of the given subnets are from the VPC's public subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getHasPublic();
    /**
     * Dependency representing internet connectivity for these subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished();
    /**
     * The subnet IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getSubnetIds();
    /**
     * Selected subnet objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * @return a {@link Builder} of {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<java.lang.String> _availabilityZones;
        private java.lang.Boolean _hasPublic;
        private software.amazon.awscdk.core.IDependable _internetConnectivityEstablished;
        private java.util.List<java.lang.String> _subnetIds;
        private java.util.List<software.amazon.awscdk.services.ec2.ISubnet> _subnets;

        /**
         * Sets the value of AvailabilityZones
         * @param value The respective AZs of each subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAvailabilityZones(final java.util.List<java.lang.String> value) {
            this._availabilityZones = java.util.Objects.requireNonNull(value, "availabilityZones is required");
            return this;
        }
        /**
         * Sets the value of HasPublic
         * @param value Whether any of the given subnets are from the VPC's public subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHasPublic(final java.lang.Boolean value) {
            this._hasPublic = java.util.Objects.requireNonNull(value, "hasPublic is required");
            return this;
        }
        /**
         * Sets the value of InternetConnectivityEstablished
         * @param value Dependency representing internet connectivity for these subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withInternetConnectivityEstablished(final software.amazon.awscdk.core.IDependable value) {
            this._internetConnectivityEstablished = java.util.Objects.requireNonNull(value, "internetConnectivityEstablished is required");
            return this;
        }
        /**
         * Sets the value of SubnetIds
         * @param value The subnet IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubnetIds(final java.util.List<java.lang.String> value) {
            this._subnetIds = java.util.Objects.requireNonNull(value, "subnetIds is required");
            return this;
        }
        /**
         * Sets the value of Subnets
         * @param value Selected subnet objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSubnets(final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> value) {
            this._subnets = java.util.Objects.requireNonNull(value, "subnets is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SelectedSubnets}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SelectedSubnets build() {
            return new SelectedSubnets() {
                private final java.util.List<java.lang.String> $availabilityZones = java.util.Objects.requireNonNull(_availabilityZones, "availabilityZones is required");
                private final java.lang.Boolean $hasPublic = java.util.Objects.requireNonNull(_hasPublic, "hasPublic is required");
                private final software.amazon.awscdk.core.IDependable $internetConnectivityEstablished = java.util.Objects.requireNonNull(_internetConnectivityEstablished, "internetConnectivityEstablished is required");
                private final java.util.List<java.lang.String> $subnetIds = java.util.Objects.requireNonNull(_subnetIds, "subnetIds is required");
                private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> $subnets = java.util.Objects.requireNonNull(_subnets, "subnets is required");

                @Override
                public java.util.List<java.lang.String> getAvailabilityZones() {
                    return this.$availabilityZones;
                }

                @Override
                public java.lang.Boolean getHasPublic() {
                    return this.$hasPublic;
                }

                @Override
                public software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
                    return this.$internetConnectivityEstablished;
                }

                @Override
                public java.util.List<java.lang.String> getSubnetIds() {
                    return this.$subnetIds;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
                    return this.$subnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                    obj.set("hasPublic", om.valueToTree(this.getHasPublic()));
                    obj.set("internetConnectivityEstablished", om.valueToTree(this.getInternetConnectivityEstablished()));
                    obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                    obj.set("subnets", om.valueToTree(this.getSubnets()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SelectedSubnets {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The respective AZs of each subnet.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * Whether any of the given subnets are from the VPC's public subnets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Boolean getHasPublic() {
            return this.jsiiGet("hasPublic", java.lang.Boolean.class);
        }

        /**
         * Dependency representing internet connectivity for these subnets.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
            return this.jsiiGet("internetConnectivityEstablished", software.amazon.awscdk.core.IDependable.class);
        }

        /**
         * The subnet IDs.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.jsiiGet("subnetIds", java.util.List.class);
        }

        /**
         * Selected subnet objects.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.jsiiGet("subnets", java.util.List.class);
        }
    }
}
