package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VolumeAttachment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:34:37.724Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVolumeAttachmentProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::VolumeAttachment.Device`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDevice();
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getInstanceId();
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVolumeId();

    /**
     * @return a {@link Builder} of {@link CfnVolumeAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnVolumeAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _device;
        private java.lang.String _instanceId;
        private java.lang.String _volumeId;

        /**
         * Sets the value of Device
         * @param value `AWS::EC2::VolumeAttachment.Device`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDevice(final java.lang.String value) {
            this._device = java.util.Objects.requireNonNull(value, "device is required");
            return this;
        }
        /**
         * Sets the value of InstanceId
         * @param value `AWS::EC2::VolumeAttachment.InstanceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withInstanceId(final java.lang.String value) {
            this._instanceId = java.util.Objects.requireNonNull(value, "instanceId is required");
            return this;
        }
        /**
         * Sets the value of VolumeId
         * @param value `AWS::EC2::VolumeAttachment.VolumeId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVolumeId(final java.lang.String value) {
            this._volumeId = java.util.Objects.requireNonNull(value, "volumeId is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnVolumeAttachmentProps build() {
            return new CfnVolumeAttachmentProps() {
                private final java.lang.String $device = java.util.Objects.requireNonNull(_device, "device is required");
                private final java.lang.String $instanceId = java.util.Objects.requireNonNull(_instanceId, "instanceId is required");
                private final java.lang.String $volumeId = java.util.Objects.requireNonNull(_volumeId, "volumeId is required");

                @Override
                public java.lang.String getDevice() {
                    return this.$device;
                }

                @Override
                public java.lang.String getInstanceId() {
                    return this.$instanceId;
                }

                @Override
                public java.lang.String getVolumeId() {
                    return this.$volumeId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("device", om.valueToTree(this.getDevice()));
                    obj.set("instanceId", om.valueToTree(this.getInstanceId()));
                    obj.set("volumeId", om.valueToTree(this.getVolumeId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnVolumeAttachmentProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::VolumeAttachment.Device`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDevice() {
            return this.jsiiGet("device", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VolumeAttachment.InstanceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getInstanceId() {
            return this.jsiiGet("instanceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::VolumeAttachment.VolumeId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getVolumeId() {
            return this.jsiiGet("volumeId", java.lang.String.class);
        }
    }
}
