package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for an ImportedInterfaceVpcEndpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:34:37.734Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The port of the service of the interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();
    /**
     * The identifier of the security group associated with the interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSecurityGroupId();
    /**
     * The interface VPC endpoint identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpcEndpointId();

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link InterfaceVpcEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _port;
        private java.lang.String _securityGroupId;
        private java.lang.String _vpcEndpointId;

        /**
         * Sets the value of Port
         * @param value The port of the service of the interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of SecurityGroupId
         * @param value The identifier of the security group associated with the interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSecurityGroupId(final java.lang.String value) {
            this._securityGroupId = java.util.Objects.requireNonNull(value, "securityGroupId is required");
            return this;
        }
        /**
         * Sets the value of VpcEndpointId
         * @param value The interface VPC endpoint identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVpcEndpointId(final java.lang.String value) {
            this._vpcEndpointId = java.util.Objects.requireNonNull(value, "vpcEndpointId is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InterfaceVpcEndpointAttributes build() {
            return new InterfaceVpcEndpointAttributes() {
                private final java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                private final java.lang.String $securityGroupId = java.util.Objects.requireNonNull(_securityGroupId, "securityGroupId is required");
                private final java.lang.String $vpcEndpointId = java.util.Objects.requireNonNull(_vpcEndpointId, "vpcEndpointId is required");

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public java.lang.String getSecurityGroupId() {
                    return this.$securityGroupId;
                }

                @Override
                public java.lang.String getVpcEndpointId() {
                    return this.$vpcEndpointId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree(this.getPort()));
                    obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                    obj.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port of the service of the interface VPC endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The identifier of the security group associated with the interface VPC endpoint.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }

        /**
         * The interface VPC endpoint identifier.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getVpcEndpointId() {
            return this.jsiiGet("vpcEndpointId", java.lang.String.class);
        }
    }
}
