package software.amazon.awscdk.services.ec2;

/**
 * Interface for classes that provide the connection-specification parts of a security group rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:34:37.737Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Port")
public class Port extends software.amazon.jsii.JsiiObject {
    protected Port(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Port(final software.amazon.awscdk.services.ec2.PortProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * All ICMP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port allIcmp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allIcmp", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * Any TCP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port allTcp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allTcp", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * All traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port allTraffic() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allTraffic", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * Any UDP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port allUdp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allUdp", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * ICMP ping (echo) traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port icmpPing() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpPing", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * All codes for a single ICMP type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port icmpType(final java.lang.Number type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpType", software.amazon.awscdk.services.ec2.Port.class, new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * A specific combination of ICMP type and code.
     * 
     * @see https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port icmpTypeAndCode(final java.lang.Number type, final java.lang.Number code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpTypeAndCode", software.amazon.awscdk.services.ec2.Port.class, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * A single TCP port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port tcp(final java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "tcp", software.amazon.awscdk.services.ec2.Port.class, new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * A TCP port range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port tcpRange(final java.lang.Number startPort, final java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "tcpRange", software.amazon.awscdk.services.ec2.Port.class, new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * A single UDP port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port udp(final java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "udp", software.amazon.awscdk.services.ec2.Port.class, new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * A UDP port range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.Port udpRange(final java.lang.Number startPort, final java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "udpRange", software.amazon.awscdk.services.ec2.Port.class, new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * Produce the ingress/egress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object toRuleJson() {
        return this.jsiiCall("toRuleJson", java.lang.Object.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Whether the rule containing this port range can be inlined into a securitygroup or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getCanInlineRule() {
        return this.jsiiGet("canInlineRule", java.lang.Boolean.class);
    }
}
