package software.amazon.awscdk.services.ec2;

/**
 * VpcNetwork deploys an AWS VPC, with public and private subnets per Availability Zone. For example:.
 * 
 * ```ts
 * import { Vpc } from '@aws-cdk/aws-ec2'
 * 
 * const vpc = new Vpc(this, {
 *    cidr: "10.0.0.0/16"
 * })
 * 
 * // Iterate the public subnets
 * for (let subnet of vpc.publicSubnets) {
 * 
 * }
 * 
 * // Iterate the private subnets
 * for (let subnet of vpc.privateSubnets) {
 * 
 * }
 * ```
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:34:37.741Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Vpc")
public class Vpc extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IVpc {
    protected Vpc(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        DEFAULT_CIDR_RANGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_CIDR_RANGE", java.lang.String.class);
        DEFAULT_SUBNETS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Vpc.class, "DEFAULT_SUBNETS", java.util.List.class);
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region. It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone. Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway. Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Vpc(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * VpcNetwork creates a VPC that spans a whole region. It will automatically divide the provided VPC CIDR range, and create public and private subnets per Availability Zone. Network routing for the public subnets will be configured to allow outbound access directly via an Internet Gateway. Network routing for the private subnets will be configured to allow outbound access via a set of resilient NAT Gateways (one per AZ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Vpc(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing VPC from by querying the AWS environment this stack is deployed to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.IVpc fromLookup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Vpc.class, "fromLookup", software.amazon.awscdk.services.ec2.IVpc.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Import an exported VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.IVpc fromVpcAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.VpcAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Vpc.class, "fromVpcAttributes", software.amazon.awscdk.services.ec2.IVpc.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds a new DynamoDB gateway endpoint to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addDynamoDbEndpoint(final java.lang.String id, @javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
        return this.jsiiCall("addDynamoDbEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), subnets });
    }

    /**
     * Adds a new DynamoDB gateway endpoint to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addDynamoDbEndpoint(final java.lang.String id) {
        return this.jsiiCall("addDynamoDbEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a new gateway endpoint to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addGatewayEndpoint(final java.lang.String id, final software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions options) {
        return this.jsiiCall("addGatewayEndpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new interface endpoint to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint addInterfaceEndpoint(final java.lang.String id, final software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions options) {
        return this.jsiiCall("addInterfaceEndpoint", software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new S3 gateway endpoint to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addS3Endpoint(final java.lang.String id, @javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
        return this.jsiiCall("addS3Endpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), subnets });
    }

    /**
     * Adds a new S3 gateway endpoint to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.GatewayVpcEndpoint addS3Endpoint(final java.lang.String id) {
        return this.jsiiCall("addS3Endpoint", software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a new VPN connection to this VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.VpnConnection addVpnConnection(final java.lang.String id, final software.amazon.awscdk.services.ec2.VpnConnectionOptions options) {
        return this.jsiiCall("addVpnConnection", software.amazon.awscdk.services.ec2.VpnConnection.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Return the subnets appropriate for the placement strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnetObjects(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return this.jsiiCall("selectSubnetObjects", java.util.List.class, new Object[] { selection });
    }

    /**
     * Return the subnets appropriate for the placement strategy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<software.amazon.awscdk.services.ec2.ISubnet> selectSubnetObjects() {
        return this.jsiiCall("selectSubnetObjects", java.util.List.class);
    }

    /**
     * Returns IDs of selected subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection selection) {
        return this.jsiiCall("selectSubnets", software.amazon.awscdk.services.ec2.SelectedSubnets.class, new Object[] { selection });
    }

    /**
     * Returns IDs of selected subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.ec2.SelectedSubnets selectSubnets() {
        return this.jsiiCall("selectSubnets", software.amazon.awscdk.services.ec2.SelectedSubnets.class);
    }
    /**
     * The default CIDR range used when creating VPCs. This can be overridden using VpcNetworkProps when creating a VPCNetwork resource. e.g. new VpcResource(this, { cidr: '192.168.0.0./16' }).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_CIDR_RANGE;
    /**
     * The default subnet configuration.
     * 
     * 1 Public and 1 Private subnet per AZ evenly split
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<software.amazon.awscdk.services.ec2.SubnetConfiguration> DEFAULT_SUBNETS;

    /**
     * AZs for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return this.jsiiGet("availabilityZones", java.util.List.class);
    }

    /**
     * Dependencies for internet connectivity.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
        return this.jsiiGet("internetConnectivityEstablished", software.amazon.awscdk.core.IDependable.class);
    }

    /**
     * List of isolated subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getIsolatedSubnets() {
        return this.jsiiGet("isolatedSubnets", java.util.List.class);
    }

    /**
     * Dependencies for NAT connectivity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<software.amazon.awscdk.core.IConstruct> getNatDependencies() {
        return this.jsiiGet("natDependencies", java.util.List.class);
    }

    /**
     * List of private subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getPrivateSubnets() {
        return this.jsiiGet("privateSubnets", java.util.List.class);
    }

    /**
     * List of public subnets in this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getPublicSubnets() {
        return this.jsiiGet("publicSubnets", java.util.List.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcCidrBlock() {
        return this.jsiiGet("vpcCidrBlock", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getVpcCidrBlockAssociations() {
        return this.jsiiGet("vpcCidrBlockAssociations", java.util.List.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcDefaultNetworkAcl() {
        return this.jsiiGet("vpcDefaultNetworkAcl", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcDefaultSecurityGroup() {
        return this.jsiiGet("vpcDefaultSecurityGroup", java.lang.String.class);
    }

    /**
     * Identifier for this VPC.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getVpcIpv6CidrBlocks() {
        return this.jsiiGet("vpcIpv6CidrBlocks", java.util.List.class);
    }

    /**
     * Identifier for the VPN gateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getVpnGatewayId() {
        return this.jsiiGet("vpnGatewayId", java.lang.String.class);
    }
}
