/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.SubnetType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SubnetConfiguration
extends JsiiSerializable {
    public String getName();

    public SubnetType getSubnetType();

    public Number getCidrMask();

    public Boolean getReserved();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        private SubnetType _subnetType;
        @Nullable
        private Number _cidrMask;
        @Nullable
        private Boolean _reserved;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withSubnetType(SubnetType value) {
            this._subnetType = Objects.requireNonNull(value, "subnetType is required");
            return this;
        }

        public Builder withCidrMask(@Nullable Number value) {
            this._cidrMask = value;
            return this;
        }

        public Builder withReserved(@Nullable Boolean value) {
            this._reserved = value;
            return this;
        }

        public SubnetConfiguration build() {
            return new SubnetConfiguration(){
                private final String $name;
                private final SubnetType $subnetType;
                @Nullable
                private final Number $cidrMask;
                @Nullable
                private final Boolean $reserved;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$subnetType = Objects.requireNonNull(_subnetType, "subnetType is required");
                    this.$cidrMask = _cidrMask;
                    this.$reserved = _reserved;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public SubnetType getSubnetType() {
                    return this.$subnetType;
                }

                @Override
                public Number getCidrMask() {
                    return this.$cidrMask;
                }

                @Override
                public Boolean getReserved() {
                    return this.$reserved;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("subnetType", om.valueToTree((Object)this.getSubnetType()));
                    if (this.getCidrMask() != null) {
                        obj.set("cidrMask", om.valueToTree((Object)this.getCidrMask()));
                    }
                    if (this.getReserved() != null) {
                        obj.set("reserved", om.valueToTree((Object)this.getReserved()));
                    }
                    return obj;
                }
            };
        }
    }
}

