/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.DefaultInstanceTenancy;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.SubnetConfiguration;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.VpnConnectionOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface VpcProps
extends JsiiSerializable {
    public String getCidr();

    public DefaultInstanceTenancy getDefaultInstanceTenancy();

    public Boolean getEnableDnsHostnames();

    public Boolean getEnableDnsSupport();

    public Map<String, GatewayVpcEndpointOptions> getGatewayEndpoints();

    public Number getMaxAzs();

    public Number getNatGateways();

    public SubnetSelection getNatGatewaySubnets();

    public List<SubnetConfiguration> getSubnetConfiguration();

    public Map<String, VpnConnectionOptions> getVpnConnections();

    public Boolean getVpnGateway();

    public Number getVpnGatewayAsn();

    public List<SubnetSelection> getVpnRoutePropagation();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String _cidr;
        @Nullable
        private DefaultInstanceTenancy _defaultInstanceTenancy;
        @Nullable
        private Boolean _enableDnsHostnames;
        @Nullable
        private Boolean _enableDnsSupport;
        @Nullable
        private Map<String, GatewayVpcEndpointOptions> _gatewayEndpoints;
        @Nullable
        private Number _maxAzs;
        @Nullable
        private Number _natGateways;
        @Nullable
        private SubnetSelection _natGatewaySubnets;
        @Nullable
        private List<SubnetConfiguration> _subnetConfiguration;
        @Nullable
        private Map<String, VpnConnectionOptions> _vpnConnections;
        @Nullable
        private Boolean _vpnGateway;
        @Nullable
        private Number _vpnGatewayAsn;
        @Nullable
        private List<SubnetSelection> _vpnRoutePropagation;

        public Builder withCidr(@Nullable String value) {
            this._cidr = value;
            return this;
        }

        public Builder withDefaultInstanceTenancy(@Nullable DefaultInstanceTenancy value) {
            this._defaultInstanceTenancy = value;
            return this;
        }

        public Builder withEnableDnsHostnames(@Nullable Boolean value) {
            this._enableDnsHostnames = value;
            return this;
        }

        public Builder withEnableDnsSupport(@Nullable Boolean value) {
            this._enableDnsSupport = value;
            return this;
        }

        public Builder withGatewayEndpoints(@Nullable Map<String, GatewayVpcEndpointOptions> value) {
            this._gatewayEndpoints = value;
            return this;
        }

        public Builder withMaxAzs(@Nullable Number value) {
            this._maxAzs = value;
            return this;
        }

        public Builder withNatGateways(@Nullable Number value) {
            this._natGateways = value;
            return this;
        }

        public Builder withNatGatewaySubnets(@Nullable SubnetSelection value) {
            this._natGatewaySubnets = value;
            return this;
        }

        public Builder withSubnetConfiguration(@Nullable List<SubnetConfiguration> value) {
            this._subnetConfiguration = value;
            return this;
        }

        public Builder withVpnConnections(@Nullable Map<String, VpnConnectionOptions> value) {
            this._vpnConnections = value;
            return this;
        }

        public Builder withVpnGateway(@Nullable Boolean value) {
            this._vpnGateway = value;
            return this;
        }

        public Builder withVpnGatewayAsn(@Nullable Number value) {
            this._vpnGatewayAsn = value;
            return this;
        }

        public Builder withVpnRoutePropagation(@Nullable List<SubnetSelection> value) {
            this._vpnRoutePropagation = value;
            return this;
        }

        public VpcProps build() {
            return new VpcProps(){
                @Nullable
                private final String $cidr;
                @Nullable
                private final DefaultInstanceTenancy $defaultInstanceTenancy;
                @Nullable
                private final Boolean $enableDnsHostnames;
                @Nullable
                private final Boolean $enableDnsSupport;
                @Nullable
                private final Map<String, GatewayVpcEndpointOptions> $gatewayEndpoints;
                @Nullable
                private final Number $maxAzs;
                @Nullable
                private final Number $natGateways;
                @Nullable
                private final SubnetSelection $natGatewaySubnets;
                @Nullable
                private final List<SubnetConfiguration> $subnetConfiguration;
                @Nullable
                private final Map<String, VpnConnectionOptions> $vpnConnections;
                @Nullable
                private final Boolean $vpnGateway;
                @Nullable
                private final Number $vpnGatewayAsn;
                @Nullable
                private final List<SubnetSelection> $vpnRoutePropagation;
                {
                    this.$cidr = _cidr;
                    this.$defaultInstanceTenancy = _defaultInstanceTenancy;
                    this.$enableDnsHostnames = _enableDnsHostnames;
                    this.$enableDnsSupport = _enableDnsSupport;
                    this.$gatewayEndpoints = _gatewayEndpoints;
                    this.$maxAzs = _maxAzs;
                    this.$natGateways = _natGateways;
                    this.$natGatewaySubnets = _natGatewaySubnets;
                    this.$subnetConfiguration = _subnetConfiguration;
                    this.$vpnConnections = _vpnConnections;
                    this.$vpnGateway = _vpnGateway;
                    this.$vpnGatewayAsn = _vpnGatewayAsn;
                    this.$vpnRoutePropagation = _vpnRoutePropagation;
                }

                @Override
                public String getCidr() {
                    return this.$cidr;
                }

                @Override
                public DefaultInstanceTenancy getDefaultInstanceTenancy() {
                    return this.$defaultInstanceTenancy;
                }

                @Override
                public Boolean getEnableDnsHostnames() {
                    return this.$enableDnsHostnames;
                }

                @Override
                public Boolean getEnableDnsSupport() {
                    return this.$enableDnsSupport;
                }

                @Override
                public Map<String, GatewayVpcEndpointOptions> getGatewayEndpoints() {
                    return this.$gatewayEndpoints;
                }

                @Override
                public Number getMaxAzs() {
                    return this.$maxAzs;
                }

                @Override
                public Number getNatGateways() {
                    return this.$natGateways;
                }

                @Override
                public SubnetSelection getNatGatewaySubnets() {
                    return this.$natGatewaySubnets;
                }

                @Override
                public List<SubnetConfiguration> getSubnetConfiguration() {
                    return this.$subnetConfiguration;
                }

                @Override
                public Map<String, VpnConnectionOptions> getVpnConnections() {
                    return this.$vpnConnections;
                }

                @Override
                public Boolean getVpnGateway() {
                    return this.$vpnGateway;
                }

                @Override
                public Number getVpnGatewayAsn() {
                    return this.$vpnGatewayAsn;
                }

                @Override
                public List<SubnetSelection> getVpnRoutePropagation() {
                    return this.$vpnRoutePropagation;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getCidr() != null) {
                        obj.set("cidr", om.valueToTree((Object)this.getCidr()));
                    }
                    if (this.getDefaultInstanceTenancy() != null) {
                        obj.set("defaultInstanceTenancy", om.valueToTree((Object)this.getDefaultInstanceTenancy()));
                    }
                    if (this.getEnableDnsHostnames() != null) {
                        obj.set("enableDnsHostnames", om.valueToTree((Object)this.getEnableDnsHostnames()));
                    }
                    if (this.getEnableDnsSupport() != null) {
                        obj.set("enableDnsSupport", om.valueToTree((Object)this.getEnableDnsSupport()));
                    }
                    if (this.getGatewayEndpoints() != null) {
                        obj.set("gatewayEndpoints", om.valueToTree(this.getGatewayEndpoints()));
                    }
                    if (this.getMaxAzs() != null) {
                        obj.set("maxAzs", om.valueToTree((Object)this.getMaxAzs()));
                    }
                    if (this.getNatGateways() != null) {
                        obj.set("natGateways", om.valueToTree((Object)this.getNatGateways()));
                    }
                    if (this.getNatGatewaySubnets() != null) {
                        obj.set("natGatewaySubnets", om.valueToTree((Object)this.getNatGatewaySubnets()));
                    }
                    if (this.getSubnetConfiguration() != null) {
                        obj.set("subnetConfiguration", om.valueToTree(this.getSubnetConfiguration()));
                    }
                    if (this.getVpnConnections() != null) {
                        obj.set("vpnConnections", om.valueToTree(this.getVpnConnections()));
                    }
                    if (this.getVpnGateway() != null) {
                        obj.set("vpnGateway", om.valueToTree((Object)this.getVpnGateway()));
                    }
                    if (this.getVpnGatewayAsn() != null) {
                        obj.set("vpnGatewayAsn", om.valueToTree((Object)this.getVpnGatewayAsn()));
                    }
                    if (this.getVpnRoutePropagation() != null) {
                        obj.set("vpnRoutePropagation", om.valueToTree(this.getVpnRoutePropagation()));
                    }
                    return obj;
                }
            };
        }
    }
}

