package software.amazon.awscdk.services.ec2;
/**
 * Amazon Linux image properties
 */
public interface AmazonLinuxImageProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * What edition of Amazon Linux to use
     * @default Standard
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition();
    /**
     * What edition of Amazon Linux to use
     * @default Standard
     */
    void setEdition(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition value);
    /**
     * Virtualization type
     * @default HVM
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization();
    /**
     * Virtualization type
     * @default HVM
     */
    void setVirtualization(final software.amazon.awscdk.services.ec2.AmazonLinuxVirt value);
    /**
     * What storage backed image to use
     * @default GeneralPurpose
     */
    software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage();
    /**
     * What storage backed image to use
     * @default GeneralPurpose
     */
    void setStorage(final software.amazon.awscdk.services.ec2.AmazonLinuxStorage value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link AmazonLinuxImageProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * What edition of Amazon Linux to use
         * @default Standard
         */
        public Builder withEdition(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition value) {
            this.instance._edition = value;
            return this;
        }
        /**
         * Virtualization type
         * @default HVM
         */
        public Builder withVirtualization(final software.amazon.awscdk.services.ec2.AmazonLinuxVirt value) {
            this.instance._virtualization = value;
            return this;
        }
        /**
         * What storage backed image to use
         * @default GeneralPurpose
         */
        public Builder withStorage(final software.amazon.awscdk.services.ec2.AmazonLinuxStorage value) {
            this.instance._storage = value;
            return this;
        }
        public AmazonLinuxImageProps build() {
            AmazonLinuxImageProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link AmazonLinuxImageProps}.
     */
    final class Jsii$Pojo implements AmazonLinuxImageProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.ec2.AmazonLinuxEdition _edition;

        public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
            return this._edition;
        }
        public void setEdition(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition value) {
            this._edition = value;
        }

        protected software.amazon.awscdk.services.ec2.AmazonLinuxVirt _virtualization;

        public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
            return this._virtualization;
        }
        public void setVirtualization(final software.amazon.awscdk.services.ec2.AmazonLinuxVirt value) {
            this._virtualization = value;
        }

        protected software.amazon.awscdk.services.ec2.AmazonLinuxStorage _storage;

        public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
            return this._storage;
        }
        public void setStorage(final software.amazon.awscdk.services.ec2.AmazonLinuxStorage value) {
            this._storage = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.AmazonLinuxImageProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * What edition of Amazon Linux to use
         * @default Standard
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
            return this.jsiiGet("edition", software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class);
        }
        /**
         * What edition of Amazon Linux to use
         * @default Standard
         */
        public void setEdition(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxEdition value) {
            this.jsiiSet("edition", value);
        }
        /**
         * Virtualization type
         * @default HVM
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
            return this.jsiiGet("virtualization", software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class);
        }
        /**
         * Virtualization type
         * @default HVM
         */
        public void setVirtualization(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxVirt value) {
            this.jsiiSet("virtualization", value);
        }
        /**
         * What storage backed image to use
         * @default GeneralPurpose
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
            return this.jsiiGet("storage", software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class);
        }
        /**
         * What storage backed image to use
         * @default GeneralPurpose
         */
        public void setStorage(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.AmazonLinuxStorage value) {
            this.jsiiSet("storage", value);
        }
    }
}
