package software.amazon.awscdk.services.ec2;
/**
 * A Fleet represents a managed set of EC2 instances
 * 
 * The Fleet models a number of AutoScalingGroups, a launch configuration, a
 * security group and an instance role.
 * 
 * It allows adding arbitrary commands to the startup scripts of the instances
 * in the fleet.
 * 
 * The ASG spans all availability zones.
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AutoScalingGroup")
public class AutoScalingGroup extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget {
    protected AutoScalingGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public AutoScalingGroup(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.ec2.AutoScalingGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }
    /**
     * Attach load-balanced target to a classic ELB
     */
    public void attachToClassicLB(final software.amazon.awscdk.services.ec2.ClassicLoadBalancer loadBalancer) {
        this.jsiiCall("attachToClassicLB", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required")).toArray());
    }
    /**
     * Add command to the startup script of fleet instances.
     * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
     */
    public void addUserData(final java.lang.String script) {
        this.jsiiCall("addUserData", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(script, "script is required")).toArray());
    }
    public software.amazon.awscdk.Token autoScalingGroupName() {
        return this.jsiiCall("autoScalingGroupName", software.amazon.awscdk.Token.class);
    }
    /**
     * Adds a statement to the IAM role assumed by instances of this fleet.
     */
    public void addToRolePolicy(final software.amazon.awscdk.PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }
    public software.amazon.awscdk.services.ec2.IConnectionPeer getConnectionPeer() {
        return this.jsiiGet("connectionPeer", software.amazon.awscdk.services.ec2.IConnectionPeer.class);
    }
    /**
     * The type of OS instances of this fleet are running.
     */
    public software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
    }
    /**
     * Allows specify security group connections for instances of this fleet.
     */
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }
    /**
     * The IAM role assumed by instances of this fleet.
     */
    public software.amazon.awscdk.services.iam.Role getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
    }
}
