package software.amazon.awscdk.services.ec2;
/**
 * Reference to a listener's port just created
 * 
 * This class exists to make it convenient to add port ranges to the load
 * balancer's security group just for the port ranges that are involved in the
 * listener.
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClassicListenerPort")
public class ClassicListenerPort extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IDefaultConnectable {
    protected ClassicListenerPort(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public ClassicListenerPort(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.services.ec2.IPortRange defaultPortRange) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(securityGroup, "securityGroup is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(defaultPortRange, "defaultPortRange is required"))).toArray());
    }
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }
    public software.amazon.awscdk.services.ec2.IPortRange getDefaultPortRange() {
        return this.jsiiGet("defaultPortRange", software.amazon.awscdk.services.ec2.IPortRange.class);
    }
}
