package software.amazon.awscdk.services.ec2;
/**
 * Construction properties for a ClassicLoadBalancer
 */
public interface ClassicLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * VPC network of the fleet instances
     */
    software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc();
    /**
     * VPC network of the fleet instances
     */
    void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);
    /**
     * Whether this is an internet-facing Load Balancer
     * 
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     * @default false
     */
    java.lang.Boolean getInternetFacing();
    /**
     * Whether this is an internet-facing Load Balancer
     * 
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     * @default false
     */
    void setInternetFacing(final java.lang.Boolean value);
    /**
     * What listeners to set up for the load balancer.
     * 
     * Can also be added by .addListener()
     */
    java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> getListeners();
    /**
     * What listeners to set up for the load balancer.
     * 
     * Can also be added by .addListener()
     */
    void setListeners(final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value);
    /**
     * What targets to load balance to.
     * 
     * Can also be added by .addTarget()
     */
    java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> getTargets();
    /**
     * What targets to load balance to.
     * 
     * Can also be added by .addTarget()
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value);
    /**
     * Health check settings for the load balancing targets.
     * 
     * Not required but recommended.
     */
    software.amazon.awscdk.services.ec2.HealthCheck getHealthCheck();
    /**
     * Health check settings for the load balancing targets.
     * 
     * Not required but recommended.
     */
    void setHealthCheck(final software.amazon.awscdk.services.ec2.HealthCheck value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link ClassicLoadBalancerProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * VPC network of the fleet instances
         */
        public Build withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            return new FullBuilder().withVpc(value);
        }

        public interface Build {
            /**
             * @return a new {@link ClassicLoadBalancerProps} object, initialized with the values set on this builder.
             */
            ClassicLoadBalancerProps build();
            /**
             * Whether this is an internet-facing Load Balancer
             * 
             * This controls whether the LB has a public IP address assigned. It does
             * not open up the Load Balancer's security groups to public internet access.
             * @default false
             */
            Build withInternetFacing(final java.lang.Boolean value);
            /**
             * What listeners to set up for the load balancer.
             * 
             * Can also be added by .addListener()
             */
            Build withListeners(final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value);
            /**
             * What targets to load balance to.
             * 
             * Can also be added by .addTarget()
             */
            Build withTargets(final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value);
            /**
             * Health check settings for the load balancing targets.
             * 
             * Not required but recommended.
             */
            Build withHealthCheck(final software.amazon.awscdk.services.ec2.HealthCheck value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * VPC network of the fleet instances
             */
            public Build withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                java.util.Objects.requireNonNull(value, "ClassicLoadBalancerProps#vpc is required");
                this.instance._vpc = value;
                return this;
            }
            /**
             * Whether this is an internet-facing Load Balancer
             * 
             * This controls whether the LB has a public IP address assigned. It does
             * not open up the Load Balancer's security groups to public internet access.
             * @default false
             */
            public Build withInternetFacing(final java.lang.Boolean value) {
                this.instance._internetFacing = value;
                return this;
            }
            /**
             * What listeners to set up for the load balancer.
             * 
             * Can also be added by .addListener()
             */
            public Build withListeners(final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value) {
                this.instance._listeners = value;
                return this;
            }
            /**
             * What targets to load balance to.
             * 
             * Can also be added by .addTarget()
             */
            public Build withTargets(final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value) {
                this.instance._targets = value;
                return this;
            }
            /**
             * Health check settings for the load balancing targets.
             * 
             * Not required but recommended.
             */
            public Build withHealthCheck(final software.amazon.awscdk.services.ec2.HealthCheck value) {
                this.instance._healthCheck = value;
                return this;
            }
            public ClassicLoadBalancerProps build() {
                ClassicLoadBalancerProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link ClassicLoadBalancerProps}.
     */
    final class Jsii$Pojo implements ClassicLoadBalancerProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;

        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this._vpc;
        }
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = value;
        }

        protected java.lang.Boolean _internetFacing;

        public java.lang.Boolean getInternetFacing() {
            return this._internetFacing;
        }
        public void setInternetFacing(final java.lang.Boolean value) {
            this._internetFacing = value;
        }

        protected java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> _listeners;

        public java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> getListeners() {
            return this._listeners;
        }
        public void setListeners(final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value) {
            this._listeners = value;
        }

        protected java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> _targets;

        public java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> getTargets() {
            return this._targets;
        }
        public void setTargets(final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value) {
            this._targets = value;
        }

        protected software.amazon.awscdk.services.ec2.HealthCheck _healthCheck;

        public software.amazon.awscdk.services.ec2.HealthCheck getHealthCheck() {
            return this._healthCheck;
        }
        public void setHealthCheck(final software.amazon.awscdk.services.ec2.HealthCheck value) {
            this._healthCheck = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ClassicLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * VPC network of the fleet instances
         */
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }
        /**
         * VPC network of the fleet instances
         */
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }
        /**
         * Whether this is an internet-facing Load Balancer
         * 
         * This controls whether the LB has a public IP address assigned. It does
         * not open up the Load Balancer's security groups to public internet access.
         * @default false
         */
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }
        /**
         * Whether this is an internet-facing Load Balancer
         * 
         * This controls whether the LB has a public IP address assigned. It does
         * not open up the Load Balancer's security groups to public internet access.
         * @default false
         */
        public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("internetFacing", value);
        }
        /**
         * What listeners to set up for the load balancer.
         * 
         * Can also be added by .addListener()
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> getListeners() {
            return this.jsiiGet("listeners", java.util.List.class);
        }
        /**
         * What listeners to set up for the load balancer.
         * 
         * Can also be added by .addListener()
         */
        public void setListeners(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.ClassicLoadBalancerListener> value) {
            this.jsiiSet("listeners", value);
        }
        /**
         * What targets to load balance to.
         * 
         * Can also be added by .addTarget()
         */
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }
        /**
         * What targets to load balance to.
         * 
         * Can also be added by .addTarget()
         */
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.ec2.IClassicLoadBalancerTarget> value) {
            this.jsiiSet("targets", value);
        }
        /**
         * Health check settings for the load balancing targets.
         * 
         * Not required but recommended.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.ec2.HealthCheck.class);
        }
        /**
         * Health check settings for the load balancing targets.
         * 
         * Not required but recommended.
         */
        public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.HealthCheck value) {
            this.jsiiSet("healthCheck", value);
        }
    }
}
