package software.amazon.awscdk.services.ec2;
/**
 * Manage the security group (firewall) for a connectable resource.
 * 
 * This object contains method to allow connections between objects
 * that can allow connections.
 * 
 * The .allowDefaultPortXxx() methods are only available if the resource
 * this object was created for has the concept of a default port range.
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Connections")
public class Connections extends software.amazon.jsii.JsiiObject {
    protected Connections(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Connections(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPortRange defaultPortRange) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(securityGroup, "securityGroup is required")), java.util.stream.Stream.of(defaultPortRange)).toArray());
    }
    public Connections(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(securityGroup, "securityGroup is required")).toArray());
    }
    /**
     * Allow connections to the peer on their default port
     */
    public void allowToDefaultPort(final software.amazon.awscdk.services.ec2.IDefaultConnectable other, final java.lang.String description) {
        this.jsiiCall("allowToDefaultPort", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow connections to the peer on the given port
     */
    public void allowTo(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange, final java.lang.String description) {
        this.jsiiCall("allowTo", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow connections from the peer on the given port
     */
    public void allowFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final software.amazon.awscdk.services.ec2.IPortRange portRange, final java.lang.String description) {
        this.jsiiCall("allowFrom", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow hosts inside the security group to connect to each other on the given port
     */
    public void allowInternally(final software.amazon.awscdk.services.ec2.IPortRange portRange, final java.lang.String description) {
        this.jsiiCall("allowInternally", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow to all IPv4 ranges
     */
    public void allowToAnyIpv4(final software.amazon.awscdk.services.ec2.IPortRange portRange, final java.lang.String description) {
        this.jsiiCall("allowToAnyIpv4", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow from any IPv4 ranges
     */
    public void allowFromAnyIpv4(final software.amazon.awscdk.services.ec2.IPortRange portRange, final java.lang.String description) {
        this.jsiiCall("allowFromAnyIpv4", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(portRange, "portRange is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow connections from the peer on our default port
     * 
     * Even if the peer has a default port, we will always use our default port.
     */
    public void allowDefaultPortFrom(final software.amazon.awscdk.services.ec2.IConnectable other, final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFrom", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(other, "other is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required"))).toArray());
    }
    /**
     * Allow hosts inside the security group to connect to each other
     */
    public void allowDefaultPortInternally(final java.lang.String description) {
        this.jsiiCall("allowDefaultPortInternally", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required")).toArray());
    }
    /**
     * Allow default connections from all IPv4 ranges
     */
    public void allowDefaultPortFromAnyIpv4(final java.lang.String description) {
        this.jsiiCall("allowDefaultPortFromAnyIpv4", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(description, "description is required")).toArray());
    }
    public software.amazon.awscdk.services.ec2.IConnectionPeer getConnectionPeer() {
        return this.jsiiGet("connectionPeer", software.amazon.awscdk.services.ec2.IConnectionPeer.class);
    }
}
