package software.amazon.awscdk.services.ec2;
/**
 * The goal of this module is to make possible to write statements like this:
 * 
 *     ```ts
 *  *    database.connections.allowFrom(fleet);
 *  *    fleet.connections.allowTo(database);
 *  *    rdgw.connections.allowFromCidrIp('0.3.1.5/86');
 *  *    rgdw.connections.allowTrafficTo(fleet, new AllPorts());
 *  *    ```
 * 
 * The insight here is that some connecting peers have information on what ports should
 * be involved in the connection, and some don't.
 * An object that has a Connections object
 */
public interface IConnectable extends software.amazon.jsii.JsiiSerializable {
    software.amazon.awscdk.services.ec2.Connections getConnections();

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link IConnectable}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        public Build withConnections(final software.amazon.awscdk.services.ec2.Connections value) {
            return new FullBuilder().withConnections(value);
        }

        public interface Build {
            /**
             * @return a new {@link IConnectable} object, initialized with the values set on this builder.
             */
            IConnectable build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            public Build withConnections(final software.amazon.awscdk.services.ec2.Connections value) {
                java.util.Objects.requireNonNull(value, "IConnectable#connections is required");
                this.instance._connections = value;
                return this;
            }
            public IConnectable build() {
                IConnectable result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link IConnectable}.
     */
    final class Jsii$Pojo implements IConnectable {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.ec2.Connections _connections;

        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this._connections;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }
    }
}
