package software.amazon.awscdk.services.ec2;
public interface SecurityGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the security group. For valid values, see the GroupName
     * parameter of the CreateSecurityGroup action in the Amazon EC2 API
     * Reference.
     * 
     * It is not recommended to use an explicit group name.
     * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
     */
    java.lang.String getGroupName();
    /**
     * The name of the security group. For valid values, see the GroupName
     * parameter of the CreateSecurityGroup action in the Amazon EC2 API
     * Reference.
     * 
     * It is not recommended to use an explicit group name.
     * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
     */
    void setGroupName(final java.lang.String value);
    /**
     * A description of the security group.
     * @default The default name will be the construct's CDK path.
     */
    java.lang.String getDescription();
    /**
     * A description of the security group.
     * @default The default name will be the construct's CDK path.
     */
    void setDescription(final java.lang.String value);
    /**
     * The VPC in which to create the security group.
     */
    software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc();
    /**
     * The VPC in which to create the security group.
     */
    void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link SecurityGroupProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The VPC in which to create the security group.
         */
        public Build withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            return new FullBuilder().withVpc(value);
        }

        public interface Build {
            /**
             * @return a new {@link SecurityGroupProps} object, initialized with the values set on this builder.
             */
            SecurityGroupProps build();
            /**
             * The name of the security group. For valid values, see the GroupName
             * parameter of the CreateSecurityGroup action in the Amazon EC2 API
             * Reference.
             * 
             * It is not recommended to use an explicit group name.
             * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
             */
            Build withGroupName(final java.lang.String value);
            /**
             * A description of the security group.
             * @default The default name will be the construct's CDK path.
             */
            Build withDescription(final java.lang.String value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The name of the security group. For valid values, see the GroupName
             * parameter of the CreateSecurityGroup action in the Amazon EC2 API
             * Reference.
             * 
             * It is not recommended to use an explicit group name.
             * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
             */
            public Build withGroupName(final java.lang.String value) {
                this.instance._groupName = value;
                return this;
            }
            /**
             * A description of the security group.
             * @default The default name will be the construct's CDK path.
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * The VPC in which to create the security group.
             */
            public Build withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                java.util.Objects.requireNonNull(value, "SecurityGroupProps#vpc is required");
                this.instance._vpc = value;
                return this;
            }
            public SecurityGroupProps build() {
                SecurityGroupProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link SecurityGroupProps}.
     */
    final class Jsii$Pojo implements SecurityGroupProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _groupName;

        public java.lang.String getGroupName() {
            return this._groupName;
        }
        public void setGroupName(final java.lang.String value) {
            this._groupName = value;
        }

        protected java.lang.String _description;

        public java.lang.String getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }

        protected software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;

        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this._vpc;
        }
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.SecurityGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The name of the security group. For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * 
         * It is not recommended to use an explicit group name.
         * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
         */
        @javax.annotation.Nullable
        public java.lang.String getGroupName() {
            return this.jsiiGet("groupName", java.lang.String.class);
        }
        /**
         * The name of the security group. For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * 
         * It is not recommended to use an explicit group name.
         * @default If you don't specify a GroupName, AWS CloudFormation generates a unique physical ID and uses that ID for the group name.
         */
        public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("groupName", value);
        }
        /**
         * A description of the security group.
         * @default The default name will be the construct's CDK path.
         */
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
        /**
         * A description of the security group.
         * @default The default name will be the construct's CDK path.
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * The VPC in which to create the security group.
         */
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }
        /**
         * The VPC in which to create the security group.
         */
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }
    }
}
